/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.json.writer;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.json.JsonDataFormat;
import org.mule.weave.v2.module.json.writer.GroupByOrderedImplicitImpl$;
import org.mule.weave.v2.module.json.writer.JsonWriter$;
import org.mule.weave.v2.module.json.writer.JsonWriterSettings;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.module.writer.WriterWithAttributes;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u00193\u0001\u0005C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011)\u0019!C\u0001/\"AA\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u0015!\u0007\u0001\"\u0001f\u0011!\u0019\u0004\u0001#b\u0001\n\u0003Y\u0007bB8\u0001\u0001\u0004%I\u0001\u001d\u0005\bi\u0002\u0001\r\u0011\"\u0003v\u0011\u0019Y\b\u0001)Q\u0005c\")A\u0010\u0001C!{\")a\u0010\u0001C!\u007f\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u0019\u0011\u0019\u0001\u0001C!{\"9!Q\u0001\u0001\u0005B\t\u001dqa\u0002B\u0013e!\u0005!q\u0005\u0004\u0007cIB\tA!\u000b\t\r\u0011LB\u0011\u0001B\u0016\u0011%\u0011i#\u0007b\u0001\n\u0003\u0011y\u0003\u0003\u0005\u00038e\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011I$\u0007b\u0001\n\u0003\u0011Y\u0004\u0003\u0005\u0003He\u0001\u000b\u0011\u0002B\u001f\u0011%\u0011I%\u0007b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003Ne\u0001\u000b\u0011BAw\u0011%\u0011y%\u0007b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003Re\u0001\u000b\u0011BAw\u0011%\u0011\u0019&\u0007b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003Ve\u0001\u000b\u0011BAw\u0011%\u00119&\u0007b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003Ze\u0001\u000b\u0011BAw\u0011%\u0011Y&\u0007b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003^e\u0001\u000b\u0011BAw\u0011!\u0011y&\u0007b\u0001\n\u0013\u0001\bb\u0002B13\u0001\u0006I!\u001d\u0005\n\u0005GJ\"\u0019!C\u0005\u0005_A\u0001B!\u001a\u001aA\u0003%!\u0011\u0007\u0005\u0007\u0005OJB\u0011A?\t\u000f\t%\u0014\u0004\"\u0001\u0003l!9!\u0011O\r\u0005\u0002\tM\u0004b\u0002B93\u0011\u0005!Q\u0011\u0002\u000b\u0015N|gn\u0016:ji\u0016\u0014(BA\u001a5\u0003\u00199(/\u001b;fe*\u0011QGN\u0001\u0005UN|gN\u0003\u00028q\u00051Qn\u001c3vY\u0016T!!\u000f\u001e\u0002\u0005Y\u0014$BA\u001e=\u0003\u00159X-\u0019<f\u0015\tid(\u0001\u0003nk2,'\"A \u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0013.k\u0011A\u0013\u0006\u0003gYJ!\u0001\u0014&\u0003)]\u0013\u0018\u000e^3s/&$\b.\u0011;ue&\u0014W\u000f^3t\u00031yW\u000f\u001e9viN#(/Z1n!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u00051yU\u000f\u001e9viN#(/Z1n\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001-\u0011\u0005eSV\"\u0001\u001a\n\u0005m\u0013$A\u0005&t_:<&/\u001b;feN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u0007\r$\b\u0010\u0005\u0002`E6\t\u0001M\u0003\u0002bq\u0005)Qn\u001c3fY&\u00111\r\u0019\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002gS*$\"a\u001a5\u0011\u0005e\u0003\u0001\"B/\u0006\u0001\bq\u0006\"B'\u0006\u0001\u0004q\u0005\"\u0002,\u0006\u0001\u0004AV#\u00017\u0011\u0005%k\u0017B\u00018K\u0005A\u0011UO\u001a4fe\u0016$\u0017jT,sSR,'/\u0001\u0004j]\u0012,g\u000e^\u000b\u0002cB\u00111I]\u0005\u0003g\u0012\u00131!\u00138u\u0003)Ig\u000eZ3oi~#S-\u001d\u000b\u0003mf\u0004\"aQ<\n\u0005a$%\u0001B+oSRDqA\u001f\u0005\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\nq!\u001b8eK:$\b%A\u0003dY>\u001cX\rF\u0001w\u0003\u0019\u0011Xm];miV\ta*A\u0006xe&$Xm\u00142kK\u000e$H\u0003BA\u0003\u0003\u0013!2A^A\u0004\u0011\u0015iF\u0002q\u0001_\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\t\u0011b\u001c2kK\u000e$8+Z9\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005a\u0003%\u0019HO];diV\u0014X-\u0003\u0003\u0002\u0018\u0005E!!C(cU\u0016\u001cGoU3r\u0003E9(/\u001b;f\u0017\u0016Lh+\u00197vKB\u000b\u0017N\u001d\u000b\u0007\u0003;\t\t#a\u000b\u0015\u0007Y\fy\u0002C\u0003^\u001b\u0001\u000fa\fC\u0004\u0002$5\u0001\r!!\n\u0002\u000bEt\u0017-\\3\u0011\t\u0005=\u0011qE\u0005\u0005\u0003S\t\tBA\u0007Rk\u0006d\u0017NZ5fI:\u000bW.\u001a\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003\u00191\u0018\r\\;fgB1\u0011\u0011GA\u001e\u0003\u007fi!!a\r\u000b\t\u0005U\u0012qG\u0001\b[V$\u0018M\u00197f\u0015\r\tI\u0004R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001f\u0003g\u0011!\u0002T5ti\n+hMZ3s!\u0011\ty!!\u0011\n\t\u0005\r\u0013\u0011\u0003\u0002\r\u0017\u0016Lh+\u00197vKB\u000b\u0017N]\u0001\foJLG/\u001a(v[\n,'\u000f\u0006\u0003\u0002J\u00055Cc\u0001<\u0002L!)QL\u0004a\u0002=\"9\u0011q\n\bA\u0002\u0005E\u0013!\u0002<bYV,\u0007\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0005[\u0006$\bN\u0003\u0002\u0002\\\u0005)1\u000f]5sK&!\u0011qLA+\u0005\u0019qU/\u001c2fe\u0006aqO]5uK\n{w\u000e\\3b]R!\u0011QMA5)\r1\u0018q\r\u0005\u0006;>\u0001\u001dA\u0018\u0005\b\u0003\u001fz\u0001\u0019AA6!\r\u0019\u0015QN\u0005\u0004\u0003_\"%a\u0002\"p_2,\u0017M\\\u0001\noJLG/\u001a(vY2$B!!\u001e\u0002zQ\u0019a/a\u001e\t\u000bu\u0003\u00029\u00010\t\u000f\u0005=\u0003\u00031\u0001\u0002|A1\u0011QPAA\u0003\u000bk!!a \u000b\u0007\u00055\u0002-\u0003\u0003\u0002\u0004\u0006}$!\u0002,bYV,\u0007cA\"\u0002\b&\u0019\u0011\u0011\u0012#\u0003\t9+H\u000e\\\u0001\foJLG/\u001a\"j]\u0006\u0014\u0018\u0010\u0006\u0003\u0002\u0010\u0006MEc\u0001<\u0002\u0012\")Q,\u0005a\u0002=\"9\u0011qJ\tA\u0002\u0005U\u0005\u0003BAL\u00037k!!!'\u000b\u0005EC\u0014\u0002BAO\u00033\u0013abU3fW\u0006\u0014G.Z*ue\u0016\fW.\u0001\u0007e_^\u0013\u0018\u000e^3WC2,X\r\u0006\u0003\u0002$\u0006\u001dFc\u0001<\u0002&\")QL\u0005a\u0002=\"9\u0011\u0011\u0016\nA\u0002\u0005-\u0016!\u0001<1\t\u00055\u00161\u0017\t\u0007\u0003{\n\t)a,\u0011\t\u0005E\u00161\u0017\u0007\u0001\t1\t),a*\u0002\u0002\u0003\u0005)\u0011AA\\\u0005\ryF%M\t\u0005\u0003s\u000by\fE\u0002D\u0003wK1!!0E\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aQAa\u0013\r\t\u0019\r\u0012\u0002\u0004\u0003:L\u0018AC<sSR,\u0017I\u001d:bsR!\u0011\u0011ZAg)\r1\u00181\u001a\u0005\u0006;N\u0001\u001dA\u0018\u0005\b\u0003\u001f\u001c\u0002\u0019AAi\u0003!\t'O]1z'\u0016\f\b\u0003BA\b\u0003'LA!!6\u0002\u0012\tA\u0011I\u001d:bsN+\u0017/A\u0004oK^d\u0017N\\3\u0015\u0007Y\fY\u000eC\u0003p)\u0001\u0007\u0011\u000fK\u0002\u0015\u0003?\u00042aQAq\u0013\r\t\u0019\u000f\u0012\u0002\u0007S:d\u0017N\\3\u0002!]\u0014\u0018\u000e^3Rk>$Xm\u0015;sS:<Gc\u0001<\u0002j\"9\u00111^\u000bA\u0002\u00055\u0018\u0001C:ueZ\u000bG.^3\u0011\t\u0005=\u0018Q \b\u0005\u0003c\fI\u0010E\u0002\u0002t\u0012k!!!>\u000b\u0007\u0005]\b)\u0001\u0004=e>|GOP\u0005\u0004\u0003w$\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\n\u0005!AB*ue&twMC\u0002\u0002|\u0012\u000bQA\u001a7vg\"\f!\u0002Z1uC\u001a{'/\\1u+\t\u0011I\u0001E\u0003D\u0005\u0017\u0011y!C\u0002\u0003\u000e\u0011\u0013aa\u00149uS>t\u0007G\u0002B\t\u00057\u0011\t\u0003\u0005\u0005\u0003\u0014\tU!\u0011\u0004B\u0010\u001b\u00051\u0014b\u0001B\fm\tQA)\u0019;b\r>\u0014X.\u0019;\u0011\t\u0005E&1\u0004\u0003\f\u0005;9\u0012\u0011!A\u0001\u0006\u0003\t9LA\u0002`IM\u0002B!!-\u0003\"\u0011Y!1E\f\u0002\u0002\u0003\u0005)\u0011AA\\\u0005\ryF\u0005N\u0001\u000b\u0015N|gn\u0016:ji\u0016\u0014\bCA-\u001a'\tI\"\t\u0006\u0002\u0003(\u0005\t\"+\u0012)M\u0003\u000e+U*\u0012(U?\u000eC\u0015IU*\u0016\u0005\tE\u0002#B\"\u00034\u00055\u0018b\u0001B\u001b\t\n)\u0011I\u001d:bs\u0006\u0011\"+\u0012)M\u0003\u000e+U*\u0012(U?\u000eC\u0015IU*!\u0003\u0015\u0019w\u000e\\8o+\t\u0011i\u0004\u0005\u0003\u0003@\t\u0015SB\u0001B!\u0015\r\u0011\u0019EU\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0000\n\u0005\u0013AB2pY>t\u0007%A\u0003d_6l\u0017-\u0006\u0002\u0002n\u000611m\\7nC\u0002\n!b\u001c9f]~\u001bWO\u001d7z\u0003-y\u0007/\u001a8`GV\u0014H.\u001f\u0011\u0002\u0017\rdwn]3`GV\u0014H._\u0001\rG2|7/Z0dkJd\u0017\u0010I\u0001\f_B,gnX:rk\u0006\u0014X-\u0001\u0007pa\u0016twl]9vCJ,\u0007%\u0001\u0007dY>\u001cXmX:rk\u0006\u0014X-A\u0007dY>\u001cXmX:rk\u0006\u0014X\rI\u0001\u0010S:$WM\u001c;DC\u000eDWmU5{K\u0006\u0001\u0012N\u001c3f]R\u001c\u0015m\u00195f'&TX\rI\u0001\u0011S:$WM\u001c;Ta\u0006\u001cWmQ1dQ\u0016\f\u0011#\u001b8eK:$8\u000b]1dK\u000e\u000b7\r[3!\u0003%Ig.\u001b;DC\u000eDW-A\bhKRLe\u000eZ3oiN\u0003\u0018mY3t)\u0011\tiO!\u001c\t\r\t=d\u00061\u0001r\u0003\u0019\tWn\\;oi\u0006)\u0011\r\u001d9msR1!Q\u000fB=\u0005\u0007#2a\u001aB<\u0011\u0015iv\u0006q\u0001_\u0011\u001d\u0011Yh\fa\u0001\u0005{\na\u0002^1sO\u0016$\bK]8wS\u0012,'\u000fE\u0002J\u0005\u007fJ1A!!K\u00059!\u0016M]4fiB\u0013xN^5eKJDQAV\u0018A\u0002a#bAa\"\u0003\f\n=EcA4\u0003\n\")Q\f\ra\u0002=\"1!Q\u0012\u0019A\u00029\u000b!a\\:\t\u000bY\u0003\u0004\u0019\u0001-")
public class JsonWriter
implements WriterWithAttributes {
    private BufferedIOWriter writer;
    private final OutputStream outputStream;
    private final JsonWriterSettings settings;
    private final EvaluationContext ctx;
    private int indent;
    private volatile boolean bitmap$0;

    public static JsonWriter apply(OutputStream outputStream, JsonWriterSettings jsonWriterSettings, EvaluationContext evaluationContext) {
        return JsonWriter$.MODULE$.apply(outputStream, jsonWriterSettings, evaluationContext);
    }

    public static JsonWriter apply(TargetProvider targetProvider, JsonWriterSettings jsonWriterSettings, EvaluationContext evaluationContext) {
        return JsonWriter$.MODULE$.apply(targetProvider, jsonWriterSettings, evaluationContext);
    }

    public static String getIndentSpaces(int n) {
        return JsonWriter$.MODULE$.getIndentSpaces(n);
    }

    public static void initCache() {
        JsonWriter$.MODULE$.initCache();
    }

    public static String close_square() {
        return JsonWriter$.MODULE$.close_square();
    }

    public static String open_square() {
        return JsonWriter$.MODULE$.open_square();
    }

    public static String close_curly() {
        return JsonWriter$.MODULE$.close_curly();
    }

    public static String open_curly() {
        return JsonWriter$.MODULE$.open_curly();
    }

    public static String comma() {
        return JsonWriter$.MODULE$.comma();
    }

    public static String colon() {
        return JsonWriter$.MODULE$.colon();
    }

    public static String[] REPLACEMENT_CHARS() {
        return JsonWriter$.MODULE$.REPLACEMENT_CHARS();
    }

    public void writeAttributesAndValue(KeyValuePair kv, boolean writeAttributes, EvaluationContext ctx) {
        WriterWithAttributes.writeAttributesAndValue$((WriterWithAttributes)this, (KeyValuePair)kv, (boolean)writeAttributes, (EvaluationContext)ctx);
    }

    public void internalWriteValue(Value<?> v, EvaluationContext ctx) {
        WriterWithAttributes.internalWriteValue$((WriterWithAttributes)this, v, (EvaluationContext)ctx);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public JsonWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            if (!this.bitmap$0) {
                Charset charset = this.settings().charset(this.ctx);
                this.writer = BufferedIOWriter$.MODULE$.apply(this.outputStream, charset, this.settings().bufferSize());
                this.bitmap$0 = true;
            }
        }
        return this.writer;
    }

    public BufferedIOWriter writer() {
        return !this.bitmap$0 ? this.writer$lzycompute() : this.writer;
    }

    private int indent() {
        return this.indent;
    }

    private void indent_$eq(int x$1) {
        this.indent = x$1;
    }

    public void close() {
        this.writer().close();
    }

    public OutputStream result() {
        return this.outputStream;
    }

    public void writeObject(ObjectSeq objectSeq, EvaluationContext ctx) {
        Iterator filtered;
        this.indent_$eq(this.indent() + 1);
        this.writer().write(JsonWriter$.MODULE$.open_curly());
        this.newline(this.indent());
        Iterator iterator = filtered = this.settings().skipNullOnObjects() ? objectSeq.toIterator(ctx).filterNot((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)JsonWriter.$anonfun$writeObject$1(ctx, v))) : objectSeq.toIterator(ctx);
        if (this.settings().duplicateKeyAsArray()) {
            Iterator impl = filtered;
            Iterator grouped = GroupByOrderedImplicitImpl$.MODULE$.groupByOrdered$extension(impl, (Function1 & Serializable & scala.Serializable)kv -> (QualifiedName)kv._1().evaluate(ctx)).iterator();
            boolean first = true;
            while (grouped.hasNext()) {
                Tuple2 groups = (Tuple2)grouped.next();
                if (!first) {
                    this.writer().write(JsonWriter$.MODULE$.comma());
                    this.newline(this.indent());
                }
                this.writeKeyValuePair((QualifiedName)groups._1(), (ListBuffer<KeyValuePair>)((ListBuffer)groups._2()), ctx);
                first = false;
            }
        } else {
            boolean first = true;
            while (filtered.hasNext()) {
                KeyValuePair kv2 = (KeyValuePair)filtered.next();
                if (!first) {
                    this.writer().write(JsonWriter$.MODULE$.comma());
                    this.newline(this.indent());
                }
                this.writeQuoteString(((QualifiedName)kv2._1().evaluate(ctx)).name());
                this.writer().write(JsonWriter$.MODULE$.colon());
                this.writeAttributesAndValue(kv2, this.settings().writeAttributes(), ctx);
                first = false;
            }
        }
        this.indent_$eq(this.indent() - 1);
        this.newline(this.indent());
        this.writer().write(JsonWriter$.MODULE$.close_curly());
    }

    private void writeKeyValuePair(QualifiedName qname, ListBuffer<KeyValuePair> values, EvaluationContext ctx) {
        if (values.size() > 1) {
            this.writeQuoteString(qname.name());
            this.writer().write(JsonWriter$.MODULE$.colon());
            this.writer().write(JsonWriter$.MODULE$.open_square());
            this.newline(this.indent());
            BooleanRef first = BooleanRef.create((boolean)true);
            values.foreach((Function1 & Serializable & scala.Serializable)v2 -> {
                JsonWriter.$anonfun$writeKeyValuePair$1(this, first, ctx, v2);
                return BoxedUnit.UNIT;
            });
            this.newline(this.indent());
            this.writer().write(JsonWriter$.MODULE$.close_square());
        } else {
            KeyValuePair firstElementInGroup = (KeyValuePair)values.head();
            this.writeQuoteString(qname.name());
            this.writer().write(JsonWriter$.MODULE$.colon());
            this.writeAttributesAndValue(firstElementInGroup, this.settings().writeAttributes(), ctx);
        }
    }

    public void writeNumber(Number value, EvaluationContext ctx) {
        this.writer().write(value.toString());
    }

    public void writeBoolean(boolean value, EvaluationContext ctx) {
        this.writer().write(((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public void writeNull(Value<Null$> value, EvaluationContext ctx) {
        this.writer().write("null");
    }

    public void writeBinary(SeekableStream value, EvaluationContext ctx) {
        this.writeQuoteString(BinaryValue$.MODULE$.toString(value, this.settings().charset(ctx), true));
    }

    public void doWriteValue(Value<?> v, EvaluationContext ctx) {
        Object object = v.evaluate(ctx);
        if (object instanceof ObjectSeq) {
            Object object2 = object;
            this.writeObject((ObjectSeq)object2, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof ArraySeq) {
            Object object3 = object;
            this.writeArray((ArraySeq)object3, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Range) {
            this.writeArray((ArraySeq)ArrayType$.MODULE$.coerce(v, ctx).evaluate(ctx), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Number) {
            Object object4 = object;
            this.writeNumber((Number)object4, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            this.writeBoolean(bl, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object == null) {
            this.writeNull((Value<Null$>)NullType$.MODULE$.coerce(v, ctx), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof SeekableStream) {
            Object object5 = object;
            this.writeBinary((SeekableStream)object5, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof String) {
            String string = (String)object;
            this.writeQuoteString(string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeQuoteString((String)StringType$.MODULE$.withSchema(v.valueType(ctx).schema(ctx), ctx).coerce(v, ctx).evaluate(ctx));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void writeArray(ArraySeq arraySeq, EvaluationContext ctx) {
        this.indent_$eq(this.indent() + 1);
        this.writer().write(JsonWriter$.MODULE$.open_square());
        this.newline(this.indent());
        Iterator filtered = this.settings().skipNullOnArrays() ? arraySeq.toIterator().filterNot((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)JsonWriter.$anonfun$writeArray$1(ctx, v))) : arraySeq.toIterator();
        boolean first = true;
        while (filtered.hasNext()) {
            Value arrayValue = (Value)filtered.next();
            if (!first) {
                this.writer().write(JsonWriter$.MODULE$.comma());
                this.newline(this.indent());
            }
            this.writeValue(arrayValue, ctx);
            first = false;
        }
        this.indent_$eq(this.indent() - 1);
        this.newline(this.indent());
        this.writer().write(JsonWriter$.MODULE$.close_square());
    }

    private void newline(int indent) {
        block0: {
            if (!this.settings().indent()) break block0;
            this.writer().write("\n");
            this.writer().write(JsonWriter$.MODULE$.getIndentSpaces(indent));
        }
    }

    private void writeQuoteString(String strValue) {
        int i;
        int len = strValue.length();
        this.writer().write(34);
        int last = 0;
        for (i = 0; i < len; ++i) {
            char c = strValue.charAt(i);
            String replacement = null;
            if (c < '\u10000') {
                replacement = JsonWriter$.MODULE$.REPLACEMENT_CHARS()[c];
            }
            if (replacement == null) continue;
            if (last < i) {
                this.writer().write(strValue, last, i - last);
            }
            this.writer().write(replacement);
            last = i + 1;
        }
        if (last < i) {
            this.writer().write(strValue, last, i - last);
        }
        this.writer().write(34);
    }

    public void flush() {
        this.writer().flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new JsonDataFormat());
    }

    public static final /* synthetic */ boolean $anonfun$writeObject$1(EvaluationContext ctx$1, KeyValuePair v) {
        return v._2().valueType(ctx$1).isInstanceOf((Type)NullType$.MODULE$, ctx$1);
    }

    public static final /* synthetic */ void $anonfun$writeKeyValuePair$1(JsonWriter $this, BooleanRef first$1, EvaluationContext ctx$2, KeyValuePair v2) {
        if (!first$1.elem) {
            $this.writer().write(JsonWriter$.MODULE$.comma());
            $this.newline($this.indent());
        }
        $this.writeAttributesAndValue(v2, $this.settings().writeAttributes(), ctx$2);
        first$1.elem = false;
    }

    public static final /* synthetic */ boolean $anonfun$writeArray$1(EvaluationContext ctx$3, Value v) {
        return v.valueType(ctx$3).isInstanceOf((Type)NullType$.MODULE$, ctx$3);
    }

    public JsonWriter(OutputStream outputStream, JsonWriterSettings settings, EvaluationContext ctx) {
        this.outputStream = outputStream;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
        WriterWithAttributes.$init$((WriterWithAttributes)this);
        this.indent = 0;
    }
}

