/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.shared.JenaException;

public class MakeSkolem
extends BaseBuiltin {
    @Override
    public String getName() {
        return "makeSkolem";
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        StringBuilder key = new StringBuilder();
        for (int i = 1; i < length; ++i) {
            Node n = this.getArg(i, args, context);
            if (n.isBlank()) {
                key.append("B");
                key.append(n.getBlankNodeLabel());
                continue;
            }
            if (n.isURI()) {
                key.append("U");
                key.append(n.getURI());
                continue;
            }
            if (n.isLiteral()) {
                key.append("L");
                key.append(n.getLiteralLexicalForm());
                if (n.getLiteralLanguage() != null) {
                    key.append("@" + n.getLiteralLanguage());
                }
                if (n.getLiteralDatatypeURI() == null) continue;
                key.append("^^" + n.getLiteralDatatypeURI());
                continue;
            }
            key.append("O");
            key.append(n.toString());
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            digester.reset();
            byte[] digest = digester.digest(key.toString().getBytes());
            String label = Base64.encodeBase64String((byte[])digest);
            Node skolem = NodeFactory.createBlankNode(label);
            return context.getEnv().bind(args[0], skolem);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JenaException(e);
        }
    }
}

