%dw 2.0

type HashMapSetOperation<T> = {|
  operation: String,
  prevValue: T | Null,
  newValue: T,
  key: String
|}

type IHashMap = {
  get: (key: String) -> Nothing,
  set: (key: String, value: Any) -> HashMapSetOperation<Any>,
  instance: Any,
  getAll: () -> { _?: Nothing }
}

/**
*
*
* Creates a mutable Map like structure (see `IHashMap`).
*
* === Example
*
* This example shows how the `HashMap` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
*
* var context = bat::Mutable::HashMap() // <--- First, the HashMap
* ---
* describe `Deck of cards` in [
*   // Then we get a new deck of cards
*   GET `http://deckofcardsapi.com/api/deck/new/shuffle/?deck_count=1` with {} assert [
*     $.response.status mustEqual 200, // <--- Then a status assertion
*     $.response.mime mustEqual "application/json", // <--- And a MIME type assertion
*     $.response.body.remaining mustEqual 52 // <--- And a boolean assertion
*   ] execute [
*     context.set('deck_id', $.response.body.deck_id), // <--- Setting deck_id
*     log($.response) // <--- Then we’ll log the response
*   ]
* ]
* ----
**/
fun HashMap(): IHashMap = native("bat::HashMap")

type IListBuffer<T> = {
  peek: () -> T,
  pop: () -> T,
  push: (item: T) -> T,
  removeAt: (at: Number) -> T,
  getAt: (at: Number) -> T,
  setAt: (at: Number, item: T) -> T,
  instance: Any,
  items: () -> Array<T>,
  length: () -> Number
}

/**
*
* Creates a List like structure (see `IListBuffer`).
*
* === Example
*
* This example shows how the `ListBuffer` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
*
* var context = bat::Mutable::ListBuffer()
* ---
* describe `Deck of cards` in [
*   // Then we get a new deck of cards
*   GET `http://deckofcardsapi.com/api/deck/new/shuffle/?deck_count=1` with {} assert [
*     $.response.status mustEqual 200, // <--- Then a status assertion
*     $.response.mime mustEqual "application/json", // <--- And a MIME type assertion
*     $.response.body.remaining mustEqual 52 // <--- And a boolean assertion
*   ] execute [
*     context.push('deck_id', $.response.body.deck_id), // <--- Setting deck_id
*     log($.response) // <--- Then we’ll log the response
*   ]
* ]
* ----
**/
fun ListBuffer(): IListBuffer<Any> = native("bat::ListBuffer")
