/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.debugger.client;

import java.io.Serializable;
import org.mule.weave.v2.debugger.WeaveBreakpoint;
import org.mule.weave.v2.debugger.client.ClientProtocol;
import org.mule.weave.v2.debugger.client.DebuggerClient$;
import org.mule.weave.v2.debugger.client.DebuggerClientListener;
import org.mule.weave.v2.debugger.client.DebuggerEventHandler;
import org.mule.weave.v2.debugger.client.DefaultDebuggerEventHandler;
import org.mule.weave.v2.debugger.client.ScriptEvaluationListener;
import org.mule.weave.v2.debugger.client.ServerMessageHandler;
import org.mule.weave.v2.debugger.commands.AddBreakpointCommand;
import org.mule.weave.v2.debugger.commands.ClearBreakpointsCommand;
import org.mule.weave.v2.debugger.commands.EvaluateScriptCommand;
import org.mule.weave.v2.debugger.commands.InitializeSessionCommand;
import org.mule.weave.v2.debugger.commands.NextStepDebuggerCommand;
import org.mule.weave.v2.debugger.commands.RemoveBreakpointCommand;
import org.mule.weave.v2.debugger.commands.ResumeDebuggerCommand;
import org.mule.weave.v2.debugger.commands.StepIntoDebuggerCommand;
import org.mule.weave.v2.debugger.event.DebuggerEvent;
import org.mule.weave.v2.debugger.event.RemoteServerMessage;
import org.mule.weave.v2.debugger.event.ScriptResultEvent;
import org.mule.weave.v2.debugger.event.UnexpectedServerErrorEvent;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\f\u0019\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004B\u0002%\u0001A\u0003%A\bC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r=\u0003\u0001\u0015!\u0003L\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0001R\u0011\u0015Y\u0006\u0001\"\u0001R\u0011\u0015a\u0006\u0001\"\u0001R\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0019\t\t\u0001\u0001C\u0001#\"1\u00111\u0001\u0001\u0005\u0002ECq!!\u0002\u0001\t\u0013\t9aB\u0005\u0002\u001aa\t\t\u0011#\u0001\u0002\u001c\u0019Aq\u0003GA\u0001\u0012\u0003\ti\u0002\u0003\u00046)\u0011\u0005\u0011q\u0004\u0005\n\u0003C!\u0012\u0013!C\u0001\u0003G\u0011a\u0002R3ck\u001e<WM]\"mS\u0016tGO\u0003\u0002\u001a5\u000511\r\\5f]RT!a\u0007\u000f\u0002\u0011\u0011,'-^4hKJT!!\b\u0010\u0002\u0005Y\u0014$BA\u0010!\u0003\u00159X-\u0019<f\u0015\t\t#%\u0001\u0003nk2,'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-A\neK\u001a\fW\u000f\u001c;Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002/_5\t\u0001$\u0003\u000211\t1B)\u001a2vO\u001e,'o\u00117jK:$H*[:uK:,'/\u0001\u0005qe>$xnY8m!\tq3'\u0003\u000251\tq1\t\\5f]R\u0004&o\u001c;pG>d\u0017A\u0002\u001fj]&$h\bF\u00028qe\u0002\"A\f\u0001\t\u000b1\u001a\u0001\u0019A\u0017\t\u000fE\u001a\u0001\u0013!a\u0001e\u0005Y!M]3bWB|\u0017N\u001c;t+\u0005a\u0004cA\u001fC\t6\taH\u0003\u0002@\u0001\u00069Q.\u001e;bE2,'BA!)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0007z\u0012!\u0002T5ti\n+hMZ3s!\t)e)D\u0001\u001b\u0013\t9%DA\bXK\u00064XM\u0011:fC.\u0004x.\u001b8u\u00031\u0011'/Z1la>Lg\u000e^:!\u00035)g/\u001a8u\u0011\u0006tG\r\\3sgV\t1\nE\u0002>\u00052\u0003\"AL'\n\u00059C\"\u0001\u0006#fEV<w-\u001a:Fm\u0016tG\u000fS1oI2,'/\u0001\bfm\u0016tG\u000fS1oI2,'o\u001d\u0011\u0002\u000f\r|gN\\3diR\t!\u000b\u0005\u0002('&\u0011A\u000b\u000b\u0002\u0005+:LG/A\u0006jg\u000e{gN\\3di\u0016$G#A,\u0011\u0005\u001dB\u0016BA-)\u0005\u001d\u0011un\u001c7fC:\faA]3tk6,\u0017\u0001\u00038fqR\u001cF/\u001a9\u0002\u0011M$X\r]%oi>\fQ\"\u00193e\u0005J,\u0017m\u001b9pS:$HCA0c!\t9\u0003-\u0003\u0002bQ\t\u0019\u0011I\\=\t\u000b\rl\u0001\u0019\u0001#\u0002\u0015\t\u0014X-Y6q_&tG/\u0001\tsK6|g/\u001a\"sK\u0006\\\u0007o\\5oiR\u0011qL\u001a\u0005\u0006G:\u0001\r\u0001R\u0001\u000fKZ\fG.^1uKN\u001b'/\u001b9u)\u0011\u0011\u0016N\\>\t\u000b)|\u0001\u0019A6\u0002\u0005%$\u0007CA\u0014m\u0013\ti\u0007FA\u0002J]RDQa\\\bA\u0002A\faa]2sSB$\bCA9y\u001d\t\u0011h\u000f\u0005\u0002tQ5\tAO\u0003\u0002vI\u00051AH]8pizJ!a\u001e\u0015\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003o\"BQ\u0001`\bA\u0002u\f\u0001bY1mY\n\f7m\u001b\t\u0003]yL!a \r\u00031M\u001b'/\u001b9u\u000bZ\fG.^1uS>tG*[:uK:,'/\u0001\tdY\u0016\f'O\u0011:fC.\u0004x.\u001b8ug\u0006QA-[:d_:tWm\u0019;\u0002\u001b\u0011L7\u000f]1uG\",e/\u001a8u)\r\u0011\u0016\u0011\u0002\u0005\b\u0003\u0017\u0011\u0002\u0019AA\u0007\u0003!1wN]#wK:$\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M!$A\u0003fm\u0016tG/\u0003\u0003\u0002\u0018\u0005E!a\u0005*f[>$XmU3sm\u0016\u0014X*Z:tC\u001e,\u0017A\u0004#fEV<w-\u001a:DY&,g\u000e\u001e\t\u0003]Q\u0019\"\u0001\u0006\u0014\u0015\u0005\u0005m\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002&)\u001a!'a\n,\u0005\u0005%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\r)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\tiCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DebuggerClient {
    private final ClientProtocol protocol;
    private final ListBuffer<WeaveBreakpoint> breakpoints;
    private final ListBuffer<DebuggerEventHandler> org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers;

    public static ClientProtocol $lessinit$greater$default$2() {
        return DebuggerClient$.MODULE$.$lessinit$greater$default$2();
    }

    private ListBuffer<WeaveBreakpoint> breakpoints() {
        return this.breakpoints;
    }

    public ListBuffer<DebuggerEventHandler> org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers() {
        return this.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers;
    }

    public void connect() {
        this.protocol.addServerMessageHandler(DebuggerEvent.class, new ServerMessageHandler<DebuggerEvent>(this){
            private final /* synthetic */ DebuggerClient $outer;

            public void handle(DebuggerEvent message) {
                this.$outer.org$mule$weave$v2$debugger$client$DebuggerClient$$dispatchEvent(message);
            }

            public void handleUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                this.$outer.org$mule$weave$v2$debugger$client$DebuggerClient$$dispatchEvent(unexpectedServerErrorEvent);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                ServerMessageHandler.$init$(this);
            }
        });
        if (!this.protocol.isConnected()) {
            this.protocol.connect();
        }
        this.protocol.sendCommand(new InitializeSessionCommand((WeaveBreakpoint[])this.breakpoints().toArray(ClassTag$.MODULE$.apply(WeaveBreakpoint.class))));
        this.breakpoints().clear();
    }

    public boolean isConnected() {
        return this.protocol.isConnected();
    }

    public void resume() {
        this.protocol.sendCommand(new ResumeDebuggerCommand());
    }

    public void nextStep() {
        this.protocol.sendCommand(new NextStepDebuggerCommand());
    }

    public void stepInto() {
        this.protocol.sendCommand(new StepIntoDebuggerCommand());
    }

    public Object addBreakpoint(WeaveBreakpoint breakpoint) {
        ListBuffer listBuffer;
        if (this.protocol.isConnected()) {
            this.protocol.sendCommand(new AddBreakpointCommand(breakpoint));
            listBuffer = BoxedUnit.UNIT;
        } else {
            listBuffer = this.breakpoints().$plus$eq((Object)breakpoint);
        }
        return listBuffer;
    }

    public Object removeBreakpoint(WeaveBreakpoint breakpoint) {
        ListBuffer listBuffer;
        if (this.protocol.isConnected()) {
            this.protocol.sendCommand(new RemoveBreakpointCommand(breakpoint));
            listBuffer = BoxedUnit.UNIT;
        } else {
            listBuffer = this.breakpoints().$minus$eq((Object)breakpoint);
        }
        return listBuffer;
    }

    public void evaluateScript(int id, String script, ScriptEvaluationListener callback) {
        block0: {
            if (!this.protocol.isConnected()) break block0;
            this.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers().prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DebuggerEventHandler[]{new DebuggerEventHandler(this, script, callback){
                private final /* synthetic */ DebuggerClient $outer;
                private final String script$1;
                private final ScriptEvaluationListener callback$1;

                public boolean accepts(RemoteServerMessage event) {
                    boolean bl;
                    RemoteServerMessage remoteServerMessage = event;
                    if (remoteServerMessage instanceof ScriptResultEvent) {
                        ScriptResultEvent scriptResultEvent = (ScriptResultEvent)remoteServerMessage;
                        bl = scriptResultEvent.script().equals(this.script$1);
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public void handle(RemoteServerMessage event) {
                    RemoteServerMessage remoteServerMessage = event;
                    if (remoteServerMessage instanceof ScriptResultEvent) {
                        ScriptResultEvent scriptResultEvent = (ScriptResultEvent)remoteServerMessage;
                        this.callback$1.onScriptEvaluated(this.$outer, scriptResultEvent);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers().$minus$eq((Object)this);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.script$1 = script$1;
                    this.callback$1 = callback$1;
                }
            }}));
            this.protocol.sendCommand(new EvaluateScriptCommand(script, id));
        }
    }

    public void clearBreakpoints() {
        block0: {
            if (!this.protocol.isConnected()) break block0;
            this.protocol.sendCommand(new ClearBreakpointsCommand());
        }
    }

    public void disconnect() {
        this.protocol.disconnect();
    }

    public void org$mule$weave$v2$debugger$client$DebuggerClient$$dispatchEvent(RemoteServerMessage forEvent) {
        Option find = this.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers().find((Function1 & Serializable & scala.Serializable)handler -> BoxesRunTime.boxToBoolean((boolean)handler.accepts(forEvent)));
        find.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.handle(forEvent);
            return BoxedUnit.UNIT;
        });
    }

    public DebuggerClient(DebuggerClientListener defaultEventHandler, ClientProtocol protocol) {
        this.protocol = protocol;
        this.breakpoints = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$mule$weave$v2$debugger$client$DebuggerClient$$eventHandlers().$plus$eq((Object)new DefaultDebuggerEventHandler(defaultEventHandler, this));
    }
}

