/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.jenax.functions.DeclarativeFunctionDriver;
import org.topbraid.jenax.functions.DeclarativeFunctionFactory;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLFunctionDriver;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class DeclarativeFunctionDrivers
implements DeclarativeFunctionDriver {
    public static final Property SPIN_ABSTRACT = ResourceFactory.createProperty((String)"http://spinrdf.org/spin#abstract");
    private static DeclarativeFunctionDrivers singleton = new DeclarativeFunctionDrivers();
    private Map<Property, DeclarativeFunctionDriver> drivers = new HashMap<Property, DeclarativeFunctionDriver>();

    public static DeclarativeFunctionDrivers get() {
        return singleton;
    }

    public static void set(DeclarativeFunctionDrivers value) {
        singleton = value;
    }

    DeclarativeFunctionDrivers() {
        this.register(SH.ask, new SHACLFunctionDriver());
        this.register(SH.select, new SHACLFunctionDriver());
        this.register(SH.jsLibrary, new SHACLFunctionDriver());
    }

    @Override
    public DeclarativeFunctionFactory create(Resource function) {
        DeclarativeFunctionDriver driver = this.getDriver(function);
        if (driver != null) {
            return driver.create(function);
        }
        return null;
    }

    public void register(Property predicate, DeclarativeFunctionDriver driver) {
        this.drivers.put(predicate, driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeclarativeFunctionDriver getDriver(Resource functionR) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            DeclarativeFunctionDriver direct = this.getDirectDriver(functionR);
            if (direct != null) {
                DeclarativeFunctionDriver declarativeFunctionDriver = direct;
                return declarativeFunctionDriver;
            }
            DeclarativeFunctionDriver declarativeFunctionDriver = this.getDriver(functionR, new HashSet<Resource>());
            return declarativeFunctionDriver;
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    private DeclarativeFunctionDriver getDriver(Resource functionR, Set<Resource> reached) {
        reached.add(functionR);
        for (Resource superClass : JenaUtil.getSuperClasses(functionR)) {
            DeclarativeFunctionDriver superFunction;
            if (reached.contains(functionR) || (superFunction = this.getDirectDriver(superClass)) == null) continue;
            return superFunction;
        }
        return null;
    }

    private DeclarativeFunctionDriver getDirectDriver(Resource spinFunction) {
        if (!spinFunction.hasProperty(SPIN_ABSTRACT, (RDFNode)JenaDatatypes.TRUE) && !spinFunction.hasProperty(DASH.abstract_, (RDFNode)JenaDatatypes.TRUE)) {
            StmtIterator it = spinFunction.listProperties();
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                DeclarativeFunctionDriver driver = this.drivers.get(s.getPredicate());
                if (driver == null) continue;
                it.close();
                return driver;
            }
        }
        return null;
    }
}

