/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLFunctions;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;

public class RuleUtil {
    public static Model executeRules(Model dataModel, Model shapesModel, Model inferencesModel, ProgressMonitor monitor) {
        return RuleUtil.executeRulesHelper(dataModel, null, shapesModel, inferencesModel, monitor);
    }

    public static Model executeRules(RDFNode focusNode, Model shapesModel, Model inferencesModel, ProgressMonitor monitor) {
        return RuleUtil.executeRulesHelper(focusNode.getModel(), focusNode, shapesModel, inferencesModel, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model executeRulesHelper(Model dataModel, RDFNode focusNode, Model shapesModel, Model inferencesModel, ProgressMonitor monitor) {
        if (!shapesModel.contains(TOSH.hasShape, RDF.type, (RDFNode)null)) {
            Model unionModel = SHACLSystemModel.getSHACLModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{unionModel.getGraph(), shapesModel.getGraph()});
            shapesModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        }
        SHACLFunctions.registerFunctions(shapesModel);
        if (inferencesModel == null) {
            inferencesModel = JenaUtil.createDefaultModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{dataModel.getGraph(), inferencesModel.getGraph()});
            dataModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        }
        URI shapesGraphURI = URI.create("urn:x-shacl-shapes-graph:" + UUID.randomUUID().toString());
        Dataset dataset = ARQFactory.get().getDataset(dataModel);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        ShapesGraph shapesGraph = new ShapesGraph(shapesModel);
        RuleEngine engine = new RuleEngine(dataset, shapesGraphURI, shapesGraph, inferencesModel);
        engine.setProgressMonitor(monitor);
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            engine.applyEntailments();
            if (focusNode == null) {
                engine.executeAll();
            } else {
                List<Shape> shapes = RuleUtil.getShapesWithTargetNode(focusNode, shapesGraph);
                engine.executeShapes(shapes, focusNode);
            }
        }
        catch (InterruptedException ex) {
            Model model = null;
            return model;
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        return inferencesModel;
    }

    public static List<Shape> getShapesWithTargetNode(RDFNode focusNode, ShapesGraph shapesGraph) {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Shape shape : shapesGraph.getRootShapes()) {
            if (!shape.getShapeResource().hasProperty(SH.rule) || !shape.getShapeResource().hasTargetNode(focusNode)) continue;
            shapes.add(shape);
        }
        return shapes;
    }
}

