
import wait from dw::Runtime

import HttpClientResult from dw::http::Types
import HttpCustomOptions from dw::http::Client

import * from bat::core::Helpers
import * from bat::Types
import executeStep0, runSequence from bat::core::Executors
import println from bat::core::Console

var DEPRECATION_WARNING = println('Warning: `import bat::Core` should not be used anymore, use `bat::BDD` instead.\n         Read the documentation at https://github.com/mulesoft/bat-demo/blob/master/BDD.md', 'INFO')

// This file should only contain the DSL of testing. Any other function should be placed in other module(s)

// DSL =================================================================================================================

fun GET(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'GET')

fun POST(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'POST')

fun PUT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PUT')

fun PATCH(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PATCH')

fun OPTIONS(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'OPTIONS')

fun DELETE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'DELETE')

fun TRACE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'TRACE')

fun CONNECT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'CONNECT')

fun SCENARIO(parts: Array<String>, interpolation: Array<String>) =
  createNamedBlock("SCENARIO", stringInterpolation(parts, interpolation), { softFail: true })

fun MUST(parts: Array<String>, interpolation: Array<String>) =
  createNamedBlock("MUST", stringInterpolation(parts, interpolation), { softFail: false })

fun SHOULD(parts: Array<String>, interpolation: Array<String>) =
  createNamedBlock("SHOULD", stringInterpolation(parts, interpolation), { softFail: true })

fun SUITE(parts: Array<String>, interpolation: Array<String>) =
  createNamedBlock("SUITE", stringInterpolation(parts, interpolation), { kind: "SUITE", softFail: false })

fun IS<T>(sequence: BATTest, statements: Array<() -> T | Array<T>>) =
  describeSequence(sequence, statements)

fun IN<T>(sequence: BATTest, statements: Array<() -> T | Array<T>>) =
  describeSequence(sequence, statements)

fun WAIT(ms: Number) =
  createNamedBlock("Wait", println("Wait $(ms wait ms)ms."), { kind: "Wait" })

fun REPEAT(times: Number) =
  createNamedBlock("REPEAT", "Repeat $times times", {
    kind: "LOOPABLE",
    metadata: {
      batLoopable: {
        times: times
      }
    }
  })

fun TIMES<T>(sequence: BATTest, statements: Array<() -> T | Array<T>>) =
  describeSequence(sequence, statements)