/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.writer;

import java.io.OutputStream;
import java.io.Serializable;
import org.mule.weave.v2.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.csv.CSVDataFormat;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettingsHelper;
import org.mule.weave.v2.module.csv.reader.parser.CSVWriterSettings;
import org.mule.weave.v2.module.csv.writer.CSVWriter$;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\f\u0018\u0001\u0019B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tw\u0001\u0011)\u0019!C\u0001y!AQ\t\u0001B\u0001B\u0003%Q\b\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!A\u0002\u0001#b\u0001\n\u0003)\u0006\u0002C-\u0001\u0011\u000b\u0007I\u0011\u0001.\t\u000by\u0003A\u0011I0\t\u000b\r\u0004A\u0011\u000b3\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\ty\u0007\u0001C!\u0003cBq!a\u001d\u0001\t\u0003\n\t\bC\u0004\u0002v\u0001!\t%a\u001e\b\u000f\u0005Uu\u0003#\u0001\u0002\u0018\u001a1ac\u0006E\u0001\u00033Ca!T\n\u0005\u0002\u0005m\u0005bBAO'\u0011\u0005\u0011q\u0014\u0002\n\u0007N3vK]5uKJT!\u0001G\r\u0002\r]\u0014\u0018\u000e^3s\u0015\tQ2$A\u0002dgZT!\u0001H\u000f\u0002\r5|G-\u001e7f\u0015\tqr$\u0001\u0002we)\u0011\u0001%I\u0001\u0006o\u0016\fg/\u001a\u0006\u0003E\r\nA!\\;mK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00181\u001b\u0005y#B\u0001\r\u001c\u0013\t\ttF\u0001\u0004Xe&$XM]\u0001\u0003_N\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u0005%|'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012AbT;uaV$8\u000b\u001e:fC6\f\u0001b]3ui&twm]\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005\tK\u0012A\u0002:fC\u0012,'/\u0003\u0002E\u007f\t\t2i\u0015,Xe&$XM]*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013aA2uqB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*H\u0001\u0006[>$W\r\\\u0005\u0003\u0019&\u0013\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019qj\u0015+\u0015\u0005A\u0013\u0006CA)\u0001\u001b\u00059\u0002\"\u0002$\u0006\u0001\b9\u0005\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"B\u001e\u0006\u0001\u0004iT#\u0001,\u0011\u00059:\u0016B\u0001-0\u0005A\u0011UO\u001a4fe\u0016$\u0017jT,sSR,'/A\u0005dgZ,5oY1qKV\t1\f\u0005\u0002?9&\u0011Ql\u0010\u0002\u0012\u0007N36+\u001a;uS:<7\u000fS3ma\u0016\u0014\u0018A\u0002:fgVdG/F\u0001a!\tA\u0013-\u0003\u0002cS\t\u0019\u0011I\\=\u0002\u0019\u0011|wK]5uKZ\u000bG.^3\u0015\u0005\u0015TGC\u00014j!\tAs-\u0003\u0002iS\t!QK\\5u\u0011\u00151\u0015\u0002q\u0001H\u0011\u0015Y\u0017\u00021\u0001m\u0003\u00151\u0018\r\\;fa\tiW\u000fE\u0002ocNl\u0011a\u001c\u0006\u0003a&\u000baA^1mk\u0016\u001c\u0018B\u0001:p\u0005\u00151\u0016\r\\;f!\t!X\u000f\u0004\u0001\u0005\u0013YT\u0017\u0011!A\u0001\u0006\u00039(aA0%cE\u0011\u0001\u0010\u0019\t\u0003QeL!A_\u0015\u0003\u000f9{G\u000f[5oO\u0006YqO]5uK\"+\u0017\rZ3s)\tix\u0010\u0006\u0002g}\")aI\u0003a\u0002\u000f\"11N\u0003a\u0001\u0003\u0003\u0001D!a\u0001\u0002\bA!a.]A\u0003!\r!\u0018q\u0001\u0003\u000b\u0003\u0013y\u0018\u0011!A\u0001\u0006\u00039(aA0%e\u0005AqO]5uK\u000e\u001bf\u000b\u0006\u0003\u0002\u0010\u0005MAc\u00014\u0002\u0012!)ai\u0003a\u0002\u000f\"9\u0011QC\u0006A\u0002\u0005]\u0011\u0001C5uKJ\fGo\u001c:\u0011\r\u0005e\u0011\u0011FA\u0018\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t&\u0003\u0019a$o\\8u}%\t!&C\u0002\u0002(%\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\u001d\u0012\u0006\r\u0003\u00022\u0005U\u0002\u0003\u00028r\u0003g\u00012\u0001^A\u001b\t-\t9$a\u0005\u0002\u0002\u0003\u0005)\u0011A<\u0003\u0007}#3'\u0001\u0006xe&$X-\u00128uef$B!!\u0010\u0002BQ\u0019a-a\u0010\t\u000b\u0019c\u00019A$\t\r-d\u0001\u0019AA\"a\u0011\t)%!\u0013\u0011\t9\f\u0018q\t\t\u0004i\u0006%CaCA&\u0003\u0003\n\t\u0011!A\u0003\u0002]\u00141a\u0018\u00136\u0003-9(/\u001b;f%\u0016\u001cwN\u001d3\u0015\t\u0005E\u0013Q\u000b\u000b\u0004M\u0006M\u0003\"\u0002$\u000e\u0001\b9\u0005bBA\u000b\u001b\u0001\u0007\u0011q\u000b\t\u0007\u00033\tI#!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018J\u0003%\u0019HO];diV\u0014X-\u0003\u0003\u0002d\u0005u#\u0001D&fsZ\u000bG.^3QC&\u0014\u0018!C:fa\u0006\u0014\u0018\r^8s+\t\tI\u0007E\u0002)\u0003WJ1!!\u001c*\u0005\u0011\u0019\u0005.\u0019:\u0002\u000b\rdwn]3\u0015\u0003\u0019\fQA\u001a7vg\"\f!\u0002Z1uC\u001a{'/\\1u+\t\tI\bE\u0003)\u0003w\ny(C\u0002\u0002~%\u0012aa\u00149uS>t\u0007GBAA\u0003\u0017\u000b\t\n\u0005\u0005\u0002\u0004\u0006\u0015\u0015\u0011RAH\u001b\u0005Y\u0012bAAD7\tQA)\u0019;b\r>\u0014X.\u0019;\u0011\u0007Q\fY\t\u0002\u0006\u0002\u000eF\t\t\u0011!A\u0003\u0002]\u00141a\u0018\u00137!\r!\u0018\u0011\u0013\u0003\u000b\u0003'\u000b\u0012\u0011!A\u0001\u0006\u00039(aA0%o\u0005I1i\u0015,Xe&$XM\u001d\t\u0003#N\u0019\"aE\u0014\u0015\u0005\u0005]\u0015!B1qa2LHCBAQ\u0003K\u000by\u000bF\u0002Q\u0003GCQAR\u000bA\u0004\u001dCq!a*\u0016\u0001\u0004\tI+\u0001\u0002uaB\u0019a&a+\n\u0007\u00055vF\u0001\bUCJ<W\r\u001e)s_ZLG-\u001a:\t\u000bm*\u0002\u0019A\u001f")
public class CSVWriter
implements Writer {
    private BufferedIOWriter writer;
    private CSVSettingsHelper csvEscape;
    private final OutputStream os;
    private final CSVWriterSettings settings;
    private final EvaluationContext ctx;
    private volatile byte bitmap$0;

    public static CSVWriter apply(TargetProvider targetProvider, CSVWriterSettings cSVWriterSettings, EvaluationContext evaluationContext) {
        return CSVWriter$.MODULE$.apply(targetProvider, cSVWriterSettings, evaluationContext);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public CSVWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, this.settings().charset(this.ctx), this.settings().bufferSize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.ctx = null;
        return this.writer;
    }

    public BufferedIOWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private CSVSettingsHelper csvEscape$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.csvEscape = new CSVSettingsHelper(this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.csvEscape;
    }

    public CSVSettingsHelper csvEscape() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.csvEscape$lzycompute() : this.csvEscape;
    }

    public Object result() {
        return this.os;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Value<?> value2 = value;
        if (value.valueType(ctx).isInstanceOf((Type)ObjectType$.MODULE$, ctx)) {
            this.doWriteValue((Value<?>)ArrayValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Value[]{value2}))), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (value.valueType(ctx).isInstanceOf((Type)ArrayType$.MODULE$, ctx)) {
            this.writeCSV(((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new WriterExecutionException(value.location(), this.getName(), new StringBuilder(60).append("CSV Structure should be and Array<Object> or Object but got ").append(value.valueType(ctx)).toString());
        }
    }

    public void writeHeader(Value<?> value, EvaluationContext ctx) {
        ObjectSeq evaluate = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        BooleanRef first = BooleanRef.create((boolean)true);
        evaluate.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvv -> {
            CSVWriter.$anonfun$writeHeader$1(this, ctx, first, kvv);
            return BoxedUnit.UNIT;
        });
        this.writer().write(this.settings().lineSeparator());
    }

    public void writeCSV(Iterator<Value<?>> iterator, EvaluationContext ctx) {
        boolean first = true;
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (this.settings().header() && first) {
                value = value.materialize(ctx);
                this.writeHeader(value, ctx);
            }
            this.writeRecord((Iterator<KeyValuePair>)((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx), ctx);
            first = false;
        }
    }

    public void writeEntry(Value<?> value, EvaluationContext ctx) {
        block4: {
            boolean quoteValues;
            Option<Object> quote = this.settings().quote();
            boolean bl = quoteValues = this.settings().quoteValues() && quote.isDefined();
            if (quoteValues) {
                this.writer().write((int)BoxesRunTime.unboxToChar((Object)quote.get()));
            }
            if (!value.valueType(ctx).isInstanceOf((Type)NullType$.MODULE$, ctx)) {
                String stringValue = (String)StringType$.MODULE$.withSchema(value.valueType(ctx).schema(ctx), ctx).coerce(value, ctx).evaluate(ctx);
                if (quoteValues) {
                    this.writer().write(this.csvEscape().escapeQuotedString(stringValue));
                } else {
                    this.writer().write(this.csvEscape().escapeUnquotedString(stringValue));
                }
            }
            if (!quoteValues) break block4;
            this.writer().write((int)BoxesRunTime.unboxToChar((Object)quote.get()));
        }
    }

    public void writeRecord(Iterator<KeyValuePair> iterator, EvaluationContext ctx) {
        int index = 0;
        while (iterator.hasNext()) {
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            if (index > 0) {
                this.writer().write((int)this.separator());
            }
            this.writeEntry(kvp._2(), ctx);
            ++index;
        }
        this.writer().write(this.settings().lineSeparator());
    }

    public char separator() {
        return this.settings().separator();
    }

    public void close() {
        this.writer().close();
    }

    public void flush() {
        this.writer().flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new CSVDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeHeader$1(CSVWriter $this, EvaluationContext ctx$1, BooleanRef first$1, KeyValuePair kvv) {
        String name = ((QualifiedName)kvv._1().evaluate(ctx$1)).name();
        if (!first$1.elem) {
            $this.writer().write((int)$this.separator());
        }
        if ($this.settings().quoteHeader()) {
            $this.writer().write(new StringBuilder(2).append("\"").append(name).append("\"").toString());
        } else {
            $this.writer().write(name);
        }
        first$1.elem = false;
    }

    public CSVWriter(OutputStream os, CSVWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

