/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.optimize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaNodeUtil;
import org.topbraid.shacl.optimize.ClassPropertyMetadata;
import org.topbraid.shacl.optimize.OntologyOptimizations;
import org.topbraid.shacl.optimize.PathMetadata;
import org.topbraid.shacl.vocabulary.SH;

public class ClassMetadata {
    private Node classNode;
    private String graphKey;
    private Map<Node, Set<PathMetadata>> groupPaths;
    private Map<PathMetadata, ClassPropertyMetadata> properties = new HashMap<PathMetadata, ClassPropertyMetadata>();
    private List<ClassMetadata> superClasses;

    public static Object createKey(Node classNode, String graphKey) {
        return new Key(classNode, graphKey);
    }

    public ClassMetadata(Node classNode, String graphKey) {
        this.classNode = classNode;
        this.graphKey = graphKey;
    }

    public synchronized Set<PathMetadata> getGroupPaths(Node group, Graph graph) {
        if (this.groupPaths == null) {
            this.groupPaths = new HashMap<Node, Set<PathMetadata>>();
            if (JenaNodeUtil.isInstanceOf(this.classNode, SH.Shape.asNode(), graph)) {
                this.addGroupProperties(this.classNode, graph, SH.parameter.asNode());
                this.addGroupProperties(this.classNode, graph, SH.property.asNode());
            }
            ExtendedIterator it = graph.find(null, SH.targetClass.asNode(), this.classNode);
            while (it.hasNext()) {
                Node shape = ((Triple)it.next()).getSubject();
                this.addGroupProperties(shape, graph, SH.parameter.asNode());
                this.addGroupProperties(shape, graph, SH.property.asNode());
            }
        }
        return this.groupPaths.get(group);
    }

    private void addGroupProperties(Node nodeShape, Graph graph, Node systemPredicate) {
        ExtendedIterator it = graph.find(nodeShape, systemPredicate, Node.ANY);
        while (it.hasNext()) {
            Node path;
            Node group;
            Node propertyShape = ((Triple)it.next()).getObject();
            if (graph.contains(propertyShape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode()) || (group = JenaNodeUtil.getObject(propertyShape, SH.group.asNode(), graph)) == null || (path = JenaNodeUtil.getObject(propertyShape, SH.path.asNode(), graph)) == null) continue;
            Set<PathMetadata> paths = this.groupPaths.get(group);
            if (paths == null) {
                paths = new HashSet<PathMetadata>();
                this.groupPaths.put(group, paths);
            }
            if (path.isURI()) {
                paths.add(new PathMetadata(path, false));
                continue;
            }
            Node inverse = JenaNodeUtil.getObject(path, SH.inversePath.asNode(), graph);
            if (inverse == null || !inverse.isURI()) continue;
            paths.add(new PathMetadata(inverse, true));
        }
    }

    public Node getPropertyDescription(final Node property, final boolean inverse, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getDescription();
            }
        }, null);
    }

    public Node getPropertyEditWidget(final Node property, final boolean inverse, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getEditWidget();
            }
        }, null);
    }

    public Node getPropertyLocalRange(final Node property, final boolean inverse, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getLocalRange();
            }
        }, null);
    }

    public Integer getPropertyMaxCount(final Node property, final boolean inverse, final Graph graph) {
        return (Integer)this.nearestObject(graph, new Function<ClassMetadata, Object>(){

            @Override
            public Object apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getMaxCount();
            }
        }, new HashSet<Node>());
    }

    public Node getPropertyName(final Node property, final boolean inverse, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getName();
            }
        }, null);
    }

    public Node getPropertyViewWidget(final Node property, final boolean inverse, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, inverse, graph).getViewWidget();
            }
        }, null);
    }

    public synchronized Iterable<ClassMetadata> getSuperClasses(Graph graph) {
        if (this.superClasses == null) {
            this.superClasses = new LinkedList<ClassMetadata>();
            ExtendedIterator it = graph.find(this.classNode, RDFS.subClassOf.asNode(), Node.ANY);
            while (it.hasNext()) {
                Node superClass = ((Triple)it.next()).getObject();
                this.superClasses.add(OntologyOptimizations.get().getClassMetadata(superClass, graph, this.graphKey));
            }
        }
        return this.superClasses;
    }

    public synchronized ClassPropertyMetadata getProperty(Node predicate, boolean inverse, Graph graph) {
        PathMetadata pm = new PathMetadata(predicate, inverse);
        return this.getProperty(pm, graph);
    }

    public synchronized ClassPropertyMetadata getProperty(PathMetadata pm, Graph graph) {
        ClassPropertyMetadata result = this.properties.get(pm);
        if (result == null) {
            result = new ClassPropertyMetadata(this.classNode, pm.getPredicate(), pm.isInverse(), graph);
            this.properties.put(pm, result);
        }
        return result;
    }

    private Node nearest(Graph graph, Function<ClassMetadata, Node> supplier, Set<Node> visited) {
        Node result = supplier.apply(this);
        if (result != null) {
            return result;
        }
        if (visited == null) {
            visited = new HashSet<Node>();
        }
        visited.add(this.classNode);
        for (ClassMetadata superClass : this.getSuperClasses(graph)) {
            if (visited.contains(superClass.classNode) || (result = superClass.nearest(graph, supplier, visited)) == null) continue;
            return result;
        }
        return null;
    }

    private Object nearestObject(Graph graph, Function<ClassMetadata, Object> supplier, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            Object result = supplier.apply(this);
            if (result != null) {
                return result;
            }
            visited.add(this.classNode);
            for (ClassMetadata superClass : this.getSuperClasses(graph)) {
                result = superClass.nearestObject(graph, supplier, visited);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void walkSuperClasses(Graph graph, Consumer<ClassMetadata> consumer, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            consumer.accept(this);
            visited.add(this.classNode);
            for (ClassMetadata superClassMetadata : this.getSuperClasses(graph)) {
                superClassMetadata.walkSuperClasses(graph, consumer, visited);
            }
        }
    }

    public boolean walkSuperClassesUntil(Graph graph, Predicate<ClassMetadata> predicate, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            if (predicate.test(this)) {
                return true;
            }
            visited.add(this.classNode);
            for (ClassMetadata superClassMetadata : this.getSuperClasses(graph)) {
                if (!superClassMetadata.walkSuperClassesUntil(graph, predicate, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ClassMetadata for " + this.classNode + " with " + this.properties.size() + " properties";
    }

    private static class Key {
        private Node classNode;
        private String graphKey;

        Key(Node classNode, String graphKey) {
            this.classNode = classNode;
            this.graphKey = graphKey;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                return this.classNode.equals((Object)((Key)obj).classNode) && this.graphKey.equals(((Key)obj).graphKey);
            }
            return false;
        }

        public int hashCode() {
            return this.classNode.hashCode() + this.graphKey.hashCode();
        }

        public String toString() {
            return this.graphKey + ".classMetadata." + this.classNode;
        }
    }
}

