/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.vocabulary.RDF;

public class Util {
    public static boolean isNumeric(Node n) {
        return n.isLiteral() && n.getLiteralValue() instanceof Number;
    }

    public static int getIntValue(Node n) {
        return ((Number)n.getLiteralValue()).intValue();
    }

    public static int compareNumbers(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof Number && v2 instanceof Number) {
                long l2;
                if (v1 instanceof Float || v1 instanceof Double || v2 instanceof Float || v2 instanceof Double) {
                    double d2;
                    double d1 = ((Number)v1).doubleValue();
                    return d1 < (d2 = ((Number)v2).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
                }
                long l1 = ((Number)v1).longValue();
                return l1 < (l2 = ((Number)v2).longValue()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static boolean isInstant(Node n) {
        if (n.isLiteral()) {
            Object o = n.getLiteralValue();
            return o instanceof XSDDateTime;
        }
        return false;
    }

    public static int compareInstants(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof XSDDateTime && v2 instanceof XSDDateTime) {
                XSDDateTime a = (XSDDateTime)v1;
                XSDDateTime b = (XSDDateTime)v2;
                return a.compare(b);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static int compareTypedLiterals(Node n1, Node n2) {
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            if (v1 instanceof XSDDateTime && v2 instanceof XSDDateTime) {
                XSDDateTime a = (XSDDateTime)v1;
                XSDDateTime b = (XSDDateTime)v2;
                return a.compare(b);
            }
            if (v1 instanceof Number && v2 instanceof Number) {
                long l2;
                if (v1 instanceof Float || v1 instanceof Double || v2 instanceof Float || v2 instanceof Double) {
                    double d2;
                    double d1 = ((Number)v1).doubleValue();
                    return d1 < (d2 = ((Number)v2).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
                }
                long l1 = ((Number)v1).longValue();
                return l1 < (l2 = ((Number)v2).longValue()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        }
        throw new ClassCastException("Compare typed literals can only compare numbers and datetimes");
    }

    public static boolean comparable(Node n1, Node n2) {
        return Util.isNumeric(n1) && Util.isNumeric(n2) || Util.isInstant(n1) && Util.isInstant(n2);
    }

    public static Node getPropValue(Node root, Node prop, Finder context) {
        return Util.doGetPropValue(context.find(new TriplePattern(root, prop, null)));
    }

    public static Node getPropValue(Node root, Node prop, Graph context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    public static Node getPropValue(Node root, Node prop, RuleContext context) {
        return Util.doGetPropValue(context.find(root, prop, null));
    }

    private static Node doGetPropValue(ClosableIterator<Triple> it) {
        Node result = null;
        if (it.hasNext()) {
            result = ((Triple)it.next()).getObject();
        }
        it.close();
        return result;
    }

    public static List<Node> convertList(Node root, RuleContext context) {
        return Util.convertList(root, context, new LinkedList<Node>());
    }

    private static List<Node> convertList(Node node, RuleContext context, List<Node> sofar) {
        if (node == null || node.equals(RDF.nil.asNode())) {
            return sofar;
        }
        Node next = Util.getPropValue(node, RDF.first.asNode(), context);
        if (next != null) {
            sofar.add(next);
            return Util.convertList(Util.getPropValue(node, RDF.rest.asNode(), context), context, sofar);
        }
        return sofar;
    }

    public static Node makeIntNode(int value) {
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
    }

    public static Node makeLongNode(long value) {
        if (value > Integer.MAX_VALUE) {
            return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral((int)value));
    }

    public static Node makeDoubleNode(double value) {
        return NodeFactory.createLiteral(LiteralLabelFactory.createTypedLiteral(value));
    }

    public static Node makeList(Node[] nodes, Graph graph) {
        return Util.doMakeList(nodes, 0, graph);
    }

    private static Node doMakeList(Node[] nodes, int next, Graph graph) {
        if (next < nodes.length) {
            Node listNode = NodeFactory.createBlankNode();
            graph.add(new Triple(listNode, RDF.Nodes.first, nodes[next]));
            graph.add(new Triple(listNode, RDF.Nodes.rest, Util.doMakeList(nodes, next + 1, graph)));
            return listNode;
        }
        return RDF.Nodes.nil;
    }

    public static Rule.Parser loadRuleParserFromResourceFile(String filename) {
        return Rule.rulesParserFromReader(FileUtils.openResourceFile(filename));
    }

    /*
     * Exception decompiling
     */
    public static String loadURLFile(String urlStr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean checkBinaryPredicate(Property predicate, Resource configuration) {
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext()) {
            return i.nextStatement().getObject().toString().equalsIgnoreCase("true");
        }
        return null;
    }

    public static Integer getIntegerPredicate(Property predicate, Resource configuration) {
        RDFNode lit;
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext() && (lit = i.nextStatement().getObject()) instanceof Literal) {
            return ((Literal)lit).getInt();
        }
        return null;
    }

    public static boolean convertBooleanPredicateArg(Property parameter, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase("true");
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use a Boolean");
    }

    public static int convertIntegerPredicateArg(Property parameter, Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
            }
        }
        throw new IllegalParameterException("Illegal type for " + parameter + " setting - use an integer");
    }

    public static void updateParameter(Resource config, Property parameter, Object value) {
        StmtIterator i = config.listProperties(parameter);
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        config.addProperty(parameter, value.toString());
    }
}

