%dw 2.0
output application/json
ns bat http://mulesoft.com/ns/bat

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client
import * from bat::Reporters::Common

var guid = "com.mulesoft.BAT"

fun processHttp(httpCall, suite: String, scenario: String) = {
  // TODO: Validate null optional fields
  time: httpCall.startDate default payload.startDae default now(),
  name: httpCall.name default 'Test name',
  executionId: payload.metadata.executionId default '',
  testId: payload.metadata.testId default '',
  targetId: payload.metadata.targetId default '',
  organizationId: payload.metadata.organizationId default '',
  configuration: payload.metadata.configuration default 'default',
  url: httpCall.result.request.url default '',
  path: httpCall.result.request.path default '',
  method: httpCall.result.request.method,
  status: httpCall.result.response.status,
  filepath: '-',
  suite: suite default 'Suite',
  scenario: 'Component/BATSuite/Suite/' ++ (scenario default 'Scenario'),
  pass: httpCall.pass,
  timers: ensureTimers(httpCall.result.timers)
}

// TODO: Missing values must not be sent
fun ensureTimers(timers) = {
  blocked: timers.blocked default 0,
  dns: timers.dns default 0,
  connect: timers.connect default 0,
  send: timers.send default 0,
  waitTime: timers.waitTime default 0,
  receive: timers.receive default 0,
  ssl: timers.ssl default 0,
  total: timers.total default 0
}

fun processSuite(elem) = do {
  flatten(elem.result map print($, elem.name, elem.name))
}

fun processTest(elem: BATPassCapable<Any>, suite: String, classname: String = '') = do {
  var package = elem.name
  var head = if(classname == '') '' else (classname ++ '/')
  ---
  if (elem.prefix == "SUITE")
    processSuite(elem)
  else
    flatten(elem.result map print($, suite, head ++ sanitizeName(package)))
}

fun print(elem, suite: String = payload.name, classname: String = '') =
  elem match {
    case passCapable is BATPassCapable<Any> ->
      passCapable.kind match {
        case "TEST"  -> processTest(passCapable, suite, classname)
        case "HTTP"  -> processHttp(passCapable, suite, classname)
        case "LOOPABLE" -> processTest(passCapable, suite, classname)
        else -> []
      }
    else -> using(yy = log('No match for', elem)) {}
  }


var analytics = flatten(print(payload))

fun timers(metrics) = do {
  var totals = metrics map $.timers.total
  var theMin = min(totals)
  var theMax = max(totals)
  var theSum = sum(totals)
  ---
  {
    "min" : theMin,
    "max" : theMax,
    "total": theSum,
    "count" : sizeOf(metrics),
    "sum_of_squares" : (theMin pow 2) + (theMax pow 2)
  }
}

fun cutString(str, len = 32) = do {
  if(sizeOf(str) < len)
    str
  else
    str[0 to len]
}

fun arrayToObject(array: Array<Object>) =
  array reduce (a, acc = {}) -> acc ++ a

fun pagerDutyRoutingKey() = getReporterProperty(options, "PAGER_DUTY_ROUTING_KEY")

var executionId = payload.metadata.executionId default ''
var scheduleId = payload.metadata.scheduleId default 'MANUAL_EXECUTION'
var testIdSplit = (payload.metadata.testId default '') splitBy ":"
var toPagerDuty = {
"payload": {
    "summary": "Test: " ++ payload.name ++ " has FAILED",
    "source": "BAT",
    "severity": "error",
    "component": testIdSplit[1] default 'manual',
    "group": testIdSplit[0] default 'manual',
    "class": "BAT test failed",
    "custom_details": {
      "ping time": timers(analytics).total
    }
  },
  "routing_key": pagerDutyRoutingKey(),
  "dedup_key": scheduleId ,
  "event_action": "trigger",
  "client": "BAT",
  "client_url": "https://anypoint.mulesoft.com/apitesting/" ++ executionId,
}

var disabled = isDisabled(options, context)

---
if (DEBUG or pagerDutyRoutingKey() == '' or (payload.pass != false and !disabled))
  toPagerDuty
else
  request('POST', 'https://events.pagerduty.com/v2/enqueue', {
    body: toPagerDuty
  })

