%dw 2.0
output aplication/json

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client
import envVar from dw::System
import prop from dw::Runtime
import * from bat::Reporters::Common

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

var TARGET_SECRET_ENV = (envVar('targetSecret'))
var TARGET_SECRET_PROP = (prop('targetSecret'))


var emails = getReporterProperty(options, "EMAILS")

fun mails(): Array<String> =
  if(emails != null and emails != '')
        if(emails contains(","))
            emails splitBy(",")
        else if(emails contains(";"))
            emails splitBy(";")
        else
            [emails]
  else
    log('Missing EMAILS option', [""])


fun subject(payload, context) =
    if(payload.pass)
        "Functional Monitoring Alert: " ++ payload.name ++ " passed" ++ ending(context)
    else
        "Functional Monitoring Alert: " ++ payload.name ++ " failed" ++ ending(context)

fun contentSummary(payload) =
    if(payload.pass)
            "Functional Monitor: " ++ payload.name ++ " has passed."
        else
            "Functional Monitor: " ++ payload.name ++ " has failed."

fun generateDetailsLink(payload) =
    if(payload != null and payload.metadata != null and payload.metadata.executionId != null and payload.metadata.testId != null)
        a @(href: generateLink(payload)): "Click here to more details."
    else
        null

fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processAssertions(results) = do {
    tr: flatten(results) flatMap ( (result, index) ->
                    result.assertions map (assertion, assertionIndex) -> {
                        th @(style: bullet(assertion.pass)): '',
                        th: result.name ++ " ( " ++ (reason(assertion , assertion.kind)) ++ ")"
                        }
                )
}

fun flatten(results) = do {
    results flatMap ((item, index) -> (matching(item)))
}

fun reason(assertion, kind): String = do {
    kind match {
        case "Assertion" -> assertion.name default "Assertion Failed"
        case "RuntimeException" -> "Exception: " ++ assertion.message
        else -> "Assertion failed"
    } default "Assertion Failed"
}


fun process(payload, context) = [
                          {
                            payload: {
                              channel: "email",
                              layout: "default",
                              to: {
                                emails: mails()
                              },
                                subject: subject(payload, context),
                                content: write(getHtml(payload, context), "text/xml",{writeDeclaration:false}),
                            },
                            vars: {
                              serverName: "bat-monitoring",
                              userName: "bat"
                            }
                          }
                        ]

fun bullet(pass: Boolean) = do {
    var color = if (pass) "#6cc644" else "#E3174A"
    ---
    "display: inline-block; width: 9px; height: 9px; border-radius: 1em; background: $(color); vertical-align: baseline; margin: 5px 5px;"
}

fun assertionsContainer() = `
                                display: flex;
                                flex-direction: row;
                                align-items: center;
                             `
fun strong() = 'font-weight:bold'

fun getHtml(payload, context) =     div @(id: 'main-content'): {
                              div @(class:"blankslate blankslate-narrow", style: 'margin: 15px'): {
                                span @(style: 'font-size: 20px;font-weight: 300;color: #555;' ++ strong()): contentSummary(payload),
                                br: null,
                                span @(style:  strong()):
                                    if(payload.pass)
                                        "All assertions have passed" ++ ending(context)
                                    else
                                        "Some assertions have failed" ++ ending(context),
                                br: null,
                                table @(style: assertionsContainer()):  processAssertions(payload.result),
                                br: null,
                                div @(style: strong()):  generateDetailsLink(payload)
                              }
                            }

fun getOrganizationId() = payload.metadata.organizationId default ''

fun getTargetId() = payload.metadata.targetId default ''

fun getTargetSecret() =  if(TARGET_SECRET_ENV != null) TARGET_SECRET_ENV
                         else if (TARGET_SECRET_PROP != null) TARGET_SECRET_PROP
                         else ''

fun getUrlBase() = native("email::GetEndpointMail")

fun endpoint(): String = "$(getUrlBase())/v1/organizations/$(getOrganizationId())/messages"

fun getToken() = payload.metadata.token default ''

fun getHeaders() =
    if (getToken() == '' or getToken() == ' ')
        {'Content-Type' : 'application/json',
         'X-TARGET-ID': getTargetId(),
         'X-TARGET-SECRET': getTargetSecret()
         }
     else
         {'Content-Type' : 'application/json',
          'Authorization': getToken(),
          }

var disabled = isDisabled(options, context)
var sendNotification = sendNotificationIfPassed(options)
---
if (DEBUG or endpoint() == '' or mails() == [''] or getOrganizationId() == '' or disabled or (!sendNotification and payload.pass))
     process(payload, context)
else
  (request('POST', endpoint(), {
     body: process(payload, context) ,
     headers: getHeaders()
  }) write 'application/json')
