/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.remote.Content;
import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.Root$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.client.ParsingOptions;
import amf.core.exception.CyclicReferenceException;
import amf.core.exception.UnsupportedMediaTypeException;
import amf.core.exception.UnsupportedVendorException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.parser.ErrorHandler;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParsedReference$;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.RefContainer;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceCollector;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.ReferenceKind;
import amf.core.parser.ReferenceResolutionResult;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.FileMediaType$;
import amf.core.remote.PathResolutionError;
import amf.core.remote.Platform;
import amf.core.utils.package$;
import amf.internal.environment.Environment;
import amf.plugins.features.validation.ParserSideValidations$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0001\u0003\u0001\u001d\u00111\"Q'G\u0007>l\u0007/\u001b7fe*\u00111\u0001B\u0001\u0005G>\u0014XMC\u0001\u0006\u0003\r\tWNZ\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u00051!/Y<Ve2,\u0012!\u0005\t\u0003%eq!aE\f\u0011\u0005QQQ\"A\u000b\u000b\u0005Y1\u0011A\u0002\u001fs_>$h(\u0003\u0002\u0019\u0015\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tA\"\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u001d\u0011\u0018m^+sY\u0002B\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001I\u0001\u0007e\u0016lw\u000e^3\u0016\u0003\u0005\u0002\"A\t\u0013\u000e\u0003\rR!a\b\u0002\n\u0005\u0015\u001a#\u0001\u0003)mCR4wN]7\t\u0011\u001d\u0002!\u0011!Q\u0001\n\u0005\nqA]3n_R,\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\u0011\u0017m]3\u0016\u0003-\u00022!\u0003\u0017/\u0013\ti#B\u0001\u0004PaRLwN\u001c\t\u0003E=J!\u0001M\u0012\u0003\u000f\r{g\u000e^3yi\"A!\u0007\u0001B\u0001B\u0003%1&A\u0003cCN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u0003%iW\rZ5b)f\u0004X-F\u00017!\rIA&\u0005\u0005\tq\u0001\u0011\t\u0011)A\u0005m\u0005QQ.\u001a3jCRK\b/\u001a\u0011\t\u0011i\u0002!Q1A\u0005\u0002U\naA^3oI>\u0014\b\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000fY,g\u000eZ8sA!Aa\b\u0001BC\u0002\u0013\u0005q(A\u0007sK\u001a,'/\u001a8dK.Kg\u000eZ\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111IA\u0001\u0007a\u0006\u00148/\u001a:\n\u0005\u0015\u0013%!\u0004*fM\u0016\u0014XM\\2f\u0017&tG\r\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003A\u00039\u0011XMZ3sK:\u001cWmS5oI\u0002B\u0001\"\u0013\u0001\u0003\u0006\u0004%IAS\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u0017B\u0011!\u0005T\u0005\u0003\u001b\u000e\u0012QaQ1dQ\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IaS\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u0011E\u0003!Q1A\u0005\nI\u000b1BY1tK\u000e{g\u000e^3yiV\t1\u000bE\u0002\nYQ\u0003\"!Q+\n\u0005Y\u0013%!\u0004)beN,'oQ8oi\u0016DH\u000f\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003T\u00031\u0011\u0017m]3D_:$X\r\u001f;!\u0011!Q\u0006A!b\u0001\n\u0003Y\u0016aA3omV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006YQM\u001c<je>tW.\u001a8u\u0015\t\tG!\u0001\u0005j]R,'O\\1m\u0013\t\u0019gLA\u0006F]ZL'o\u001c8nK:$\b\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\u0002\t\u0015tg\u000f\t\u0005\tO\u0002\u0011)\u0019!C\u0001Q\u0006q\u0001/\u0019:tS:<w\n\u001d;j_:\u001cX#A5\u0011\u0005)lW\"A6\u000b\u00051\u0014\u0011AB2mS\u0016tG/\u0003\u0002oW\nq\u0001+\u0019:tS:<w\n\u001d;j_:\u001c\b\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B5\u0002\u001fA\f'o]5oO>\u0003H/[8og\u0002BQA\u001d\u0001\u0005\u0002M\fa\u0001P5oSRtDc\u0003;wobL(p\u001f?~}~\u0004\"!\u001e\u0001\u000e\u0003\tAQaD9A\u0002EAQaH9A\u0002\u0005BQ!K9A\u0002-BQ\u0001N9A\u0002YBQAO9A\u0002YBqAP9\u0011\u0002\u0003\u0007\u0001\tC\u0004JcB\u0005\t\u0019A&\t\u000fE\u000b\b\u0013!a\u0001'\"9!,\u001dI\u0001\u0002\u0004a\u0006bB4r!\u0003\u0005\r!\u001b\u0005\t\u0003\u0007\u0001!\u0019!C\u0001!\u0005!\u0001/\u0019;i\u0011\u001d\t9\u0001\u0001Q\u0001\nE\tQ\u0001]1uQ\u0002B\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\u0002\u000f\r|g\u000e^3yiV\ta\u0006C\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u0011\r|g\u000e^3yi\u0002B\u0001\"!\u0006\u0001\u0005\u0004%I\u0001E\u0001\tY>\u001c\u0017\r^5p]\"9\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0012!\u00037pG\u0006$\u0018n\u001c8!\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\"A\u0002dib,\u0012\u0001\u0016\u0005\b\u0003G\u0001\u0001\u0015!\u0003U\u0003\u0011\u0019G\u000f\u001f\u0011\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005)!-^5mIR\u0011\u00111\u0006\t\u0007\u0003[\t\u0019$a\u000e\u000e\u0005\u0005=\"bAA\u0019\u0015\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0012q\u0006\u0002\u0007\rV$XO]3\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005AAm\\2v[\u0016tGOC\u0002\u0002B\t\tQ!\\8eK2LA!!\u0012\u0002<\tA!)Y:f+:LG\u000fC\u0004\u0002J\u0001!I!!\u000b\u0002\u000f\r|W\u000e]5mK\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013\u0001E1vi>$W\r^3diNKh\u000e^1y)\r1\u0014\u0011\u000b\u0005\t\u0003'\nY\u00051\u0001\u0002V\u000511\u000f\u001e:fC6\u0004B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003mC:<'BAA0\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0014\u0011\f\u0002\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0005\b\u0003O\u0002A\u0011BA5\u0003-\u0001\u0018M]:f'ftG/\u0019=\u0015\t\u0005-\u0014q\u0012\t\t\u0003[\n9(! \u0002\n:!\u0011qNA:\u001d\r!\u0012\u0011O\u0005\u0002\u0017%\u0019\u0011Q\u000f\u0006\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011Q\u000f\u0006\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1aHAB\u0015\taG!\u0003\u0003\u0002\b\u0006\u0005%aB\"p]R,g\u000e\u001e\t\u0004k\u0006-\u0015bAAG\u0005\t!!k\\8u\u0011!\t\t*!\u001aA\u0002\u0005u\u0014!B5oaV$\bbBAK\u0001\u0011\u0005\u0011qS\u0001\u0016a\u0006\u00148/Z#yi\u0016\u0014h.\u00197Ge\u0006<W.\u001a8u)\u0011\tY#!'\t\u0011\u0005m\u00151\u0013a\u0001\u0003{\nqaY8oi\u0016tG\u000fC\u0004\u0002 \u0002!I!!)\u0002\u0017A\f'o]3E_6\f\u0017N\u001c\u000b\u0005\u0003W\t\u0019\u000b\u0003\u0005\u0002&\u0006u\u0005\u0019AA6\u0003\u0019\u0001\u0018M]:fI\"9\u0011q\u0014\u0001\u0005\n\u0005%F\u0003BA\u0016\u0003WC\u0001\"!\u0010\u0002(\u0002\u0007\u0011\u0011\u0012\u0005\b\u0003_\u0003A\u0011BAY\u0003=\u0001\u0018M]:f%\u00164WM]3oG\u0016\u001cHCBAZ\u0003k\u000bI\f\u0005\u0004\u0002.\u0005M\u0012\u0011\u0012\u0005\t\u0003o\u000bi\u000b1\u0001\u0002\n\u0006!!o\\8u\u0011!\tY,!,A\u0002\u0005u\u0016\u0001\u00043p[\u0006Lg\u000e\u00157vO&t\u0007\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u00171Q\u0001\ba2,x-\u001b8t\u0013\u0011\t9-!1\u0003#\u0005ke\tR8dk6,g\u000e\u001e)mk\u001eLg\u000eC\u0004\u0002L\u0002!I!!4\u0002\u000fI,7o\u001c7wKR\u0011\u0011q\u001a\t\u0007\u0003[\t\u0019$! \t\u000f\u0005]\u0006\u0001\"\u0001\u0002TR\u0011\u00111W\u0004\b\u0003/\u0014\u0001\u0012AAm\u0003-\tUJR\"p[BLG.\u001a:\u0011\u0007U\fYN\u0002\u0004\u0002\u0005!\u0005\u0011Q\\\n\u0004\u00037D\u0001b\u0002:\u0002\\\u0012\u0005\u0011\u0011\u001d\u000b\u0003\u00033D\u0001\"!:\u0002\\\u0012\u0005\u0011q]\u0001\u0005S:LG\u000f\u0006\u0002\u0002jB\u0019\u0011\"a;\n\u0007\u00055(B\u0001\u0003V]&$\bBCAy\u00037\f\n\u0011\"\u0001\u0002t\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!!>+\u0007\u0001\u000b9p\u000b\u0002\u0002zB!\u00111 B\u0003\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019AC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0004\u0003{\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011Y!a7\u0012\u0002\u0013\u0005!QB\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t=!fA&\u0002x\"Q!1CAn#\u0003%\tA!\u0006\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u00119BK\u0002T\u0003oD!Ba\u0007\u0002\\F\u0005I\u0011\u0001B\u000f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!q\u0004\u0016\u00049\u0006]\bB\u0003B\u0012\u00037\f\n\u0011\"\u0001\u0003&\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B\u0014U\rI\u0017q\u001f")
public class AMFCompiler {
    private final String rawUrl;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final Option<String> vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final Environment env;
    private final ParsingOptions parsingOptions;
    private final String path;
    private final Context context;
    private final String location;
    private final ParserContext ctx;

    public static ParsingOptions $lessinit$greater$default$10() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$10();
    }

    public static Environment $lessinit$greater$default$9() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static Cache $lessinit$greater$default$7() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$7();
    }

    public static ReferenceKind $lessinit$greater$default$6() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$6();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String rawUrl() {
        return this.rawUrl;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public Option<String> vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    public Environment env() {
        return this.env;
    }

    public ParsingOptions parsingOptions() {
        return this.parsingOptions;
    }

    public String path() {
        return this.path;
    }

    private Context context() {
        return this.context;
    }

    private String location() {
        return this.location;
    }

    private ParserContext ctx() {
        return this.ctx;
    }

    public Future<BaseUnit> build() {
        ExecutionLog$.MODULE$.log(new StringBuilder(28).append("AMFCompiler#build: Building ").append(this.rawUrl()).toString());
        return this.context().hasCycles() ? Future$.MODULE$.failed((Throwable)new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), (Function0<Future<BaseUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log(new StringBuilder(29).append("AMFCompiler#build: compiling ").append(this.rawUrl()).toString());
            return this.compile();
        });
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)parsed2 -> this.parseDomain((Either<Content, Root>)parsed2), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<String> autodetectSyntax(CharSequence stream) {
        Option option;
        if (stream.length() > 2 && stream.charAt(0) == '#' && stream.charAt(1) == '%') {
            ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/yaml media type");
            option = new Some((Object)"application/yaml");
        } else {
            option = this.base().flatMap((Function1 & Serializable & scala.Serializable)b -> {
                None$ none$;
                Some some;
                char c2;
                Option<Object> option = b.platform().findCharInCharSequence(stream, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AMFCompiler.$anonfun$autodetectSyntax$2(BoxesRunTime.unboxToChar((Object)c))));
                if (option instanceof Some && ((c2 = BoxesRunTime.unboxToChar((Object)(some = (Some)option).value())) == '{' || c2 == '[')) {
                    ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/json media type");
                    none$ = new Some((Object)"application/json");
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }
        return option;
    }

    private Either<Content, Root> parseSyntax(Content input) {
        Left left;
        Some some;
        Tuple2 tuple2;
        Option parsed2;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseSyntax: parsing syntax ").append(this.rawUrl()).toString());
        Content content = (Content)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)input, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Content c = (Content)tuple2._1();
            AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
            Content content = p.onBeginDocumentParsing(this.path(), c, this.referenceKind());
            return content;
        });
        Option option = parsed2 = this.mediaType().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(mime, x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option = this.mediaType();
            Object object = None$.MODULE$.equals(option) ? content.mime().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$5 -> new Tuple2(mime, x$5))).orElse((Function0 & Serializable & scala.Serializable)() -> FileMediaType$.MODULE$.extension(content.url()).flatMap((Function1 & Serializable & scala.Serializable)extension -> FileMediaType$.MODULE$.mimeFromExtension((String)extension)).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(infered, x$7)))).orElse((Function0 & Serializable & scala.Serializable)() -> this.autodetectSyntax(content.stream()).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$9 -> new Tuple2(infered, x$9)))) : None$.MODULE$;
            return object;
        });
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String effective = (String)tuple2._1();
            ParsedDocument document = (ParsedDocument)tuple2._2();
            ParsedDocument doc = (ParsedDocument)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)document, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ParsedDocument d = (ParsedDocument)tuple2._1();
                AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
                ParsedDocument parsedDocument = p.onSyntaxParsed(this.path(), d);
                return parsedDocument;
            });
            left = scala.package$.MODULE$.Right().apply((Object)Root$.MODULE$.apply(doc, content.url(), effective, (Seq<ParsedReference>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.referenceKind(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)content);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExternalDomainElement result = ((ExternalDomainElement)ExternalDomainElement$.MODULE$.apply().withId(new StringBuilder(2).append(content.url()).append("#/").toString())).withRaw(content.stream().toString());
            content.mime().foreach((Function1 & Serializable & scala.Serializable)mime -> result.withMediaType((String)mime));
            return (ExternalFragment)((BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(content.url()).withId(content.url())).withEncodes(result))).withLocation(content.url());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed2) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed2;
        if (either instanceof Left) {
            Some some;
            String mime;
            Left left = (Left)either;
            Content content = (Content)left.value();
            Option<String> option = this.mediaType();
            if (option instanceof Some && AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType(mime = (String)(some = (Some)option).value()).isEmpty()) {
                throw new UnsupportedMediaTypeException(mime);
            }
            Future<BaseUnit> future2 = this.parseExternalFragment(content);
            future = future2;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future future;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseDomain: parsing domain ").append(this.rawUrl()).toString());
        int currentRun = this.ctx().parserCount();
        Option domainPluginOption = (Option)this.vendor().fold((Function0 & Serializable & scala.Serializable)() -> AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.canParse(document))), (Function1 & Serializable & scala.Serializable)x$11 -> AMFPluginsRegistry$.MODULE$.documentPluginForVendor((String)x$11).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.canParse(document))));
        boolean bl = false;
        Option option = null;
        Option option2 = domainPluginOption;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            ExecutionLog$.MODULE$.log(new StringBuilder(48).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" plugin ").append(domainPlugin.ID()).toString());
            future = this.parseReferences(document, domainPlugin).map((Function1 & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, this.ctx(), this.remote(), this.parsingOptions());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    baseUnit = baseUnit2.withRaw(document.raw());
                } else if (None$.MODULE$.equals(option)) {
                    baseUnit = (BaseUnit)((Object)((EncodesModel)((Object)((BaseUnit)ExternalFragment$.MODULE$.apply().withId(document.location())).withLocation(document.location()))).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype())));
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (this.vendor().isDefined()) {
                    throw new UnsupportedVendorException((String)this.vendor().get());
                }
            }
            if (bl) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" NO PLUGIN").toString());
                    return (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(document.location()).withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option2);
            }
        }
        Future futureDocument = future;
        return futureDocument.map((Function1 & Serializable & scala.Serializable)baseUnit -> {
            baseUnit.parserRun_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)currentRun)));
            ExecutionLog$.MODULE$.log(new StringBuilder(37).append("AMFCompiler#parseDomain: model ready ").append(this.rawUrl()).toString());
            return (BaseUnit)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(baseUnit, (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseUnit unit = (BaseUnit)tuple2._1();
                AMFFeaturePlugin plugin = (AMFFeaturePlugin)tuple2._2();
                BaseUnit baseUnit = plugin.onModelParsed(this.path(), unit);
                return baseUnit;
            });
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Root> parseReferences(Root root, AMFDocumentPlugin domainPlugin) {
        ReferenceHandler handler = domainPlugin.referenceHandler();
        ReferenceCollector refs = handler.collect(root.parsed(), this.ctx());
        ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseReferences: ").append(refs.toReferences().size()).append(" references found in ").append(this.rawUrl()).toString());
        Seq parsed2 = (Seq)((TraversableLike)refs.toReferences().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isRemote()))).map((Function1 & Serializable & scala.Serializable)link -> link.resolve(this.context(), this.cache(), this.ctx(), this.env(), (Seq<YNode>)((Seq)link.refs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.node(), Seq$.MODULE$.canBuildFrom())), domainPlugin.allowRecursiveReferences()).flatMap(arg_0 -> AMFCompiler.$anonfun$parseReferences$4(this, domainPlugin, handler, link, arg_0), ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)parsed2, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Seq x$18 = (Seq)rs.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            ParsedDocument x$19 = root.copy$default$1();
            String x$20 = root.copy$default$2();
            String x$21 = root.copy$default$3();
            ReferenceKind x$22 = root.copy$default$5();
            String x$23 = root.copy$default$6();
            return root.copy(x$19, x$20, x$21, (Seq<ParsedReference>)x$18, x$22, x$23);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.env());
    }

    public Future<Root> root() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Right right;
            Root document;
            Either either = x0$5;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                Future future;
                Root root = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root.mediatype()).find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.canParse(root)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    future = this.parseReferences(root, domainPlugin);
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> root, ExecutionContext.Implicits$.MODULE$.global());
                }
                return future;
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringBuilder(37).append("Cannot parse document with mime type ").append(content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = package$.MODULE$.Strings(this.rawUrl()).normalizePath();
        }
        catch (URISyntaxException e) {
            ((ErrorHandler)this.baseContext().getOrElse((Function0 & Serializable & scala.Serializable)() -> new ParserContext(this.rawUrl(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4()))).violation(this.path(), e.getMessage(), (YPart)YNode$.MODULE$.apply(this.path()));
            string = this.rawUrl();
        }
        catch (Exception e) {
            throw new PathResolutionError(e.getMessage());
        }
        return string;
    }

    public static final /* synthetic */ Context $anonfun$context$1(AMFCompiler $this, Context x$1) {
        return x$1.update($this.path());
    }

    public static final /* synthetic */ Context $anonfun$context$2(AMFCompiler $this) {
        return Context$.MODULE$.apply($this.remote(), $this.path());
    }

    public static final /* synthetic */ boolean $anonfun$autodetectSyntax$2(char c) {
        return c != '\n' && c != '\t' && c != '\r' && c != ' ';
    }

    public static final /* synthetic */ Some $anonfun$parseReferences$5(ParsedReference x$15) {
        return new Some((Object)x$15);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$6() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ YNode $anonfun$parseReferences$7(RefContainer x$16) {
        return x$16.node();
    }

    public static final /* synthetic */ void $anonfun$parseReferences$8(AMFCompiler $this, Throwable e$1, Reference link$1, YNode ref) {
        $this.ctx().violation(link$1.url(), e$1.getMessage(), (YPart)ref);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$9() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$10() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Future $anonfun$parseReferences$4(AMFCompiler $this, AMFDocumentPlugin domainPlugin$2, ReferenceHandler handler$1, Reference link$1, ReferenceResolutionResult x0$4) {
        block4: {
            block5: {
                block3: {
                    var7_5 = x0$4;
                    if (var7_5 == null || !((var8_6 = var7_5.unit()) instanceof Some)) break block3;
                    var9_7 = (Some)var8_6;
                    unit = (BaseUnit)var9_7.value();
                    reference = new ParsedReference(unit, link$1, ParsedReference$.MODULE$.apply$default$3());
                    var5_10 = handler$1.update(reference, $this.ctx(), $this.context(), $this.env()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$5(amf.core.parser.ParsedReference ), (Lamf/core/parser/ParsedReference;)Lscala/Some;)(), ExecutionContext.Implicits$.MODULE$.global());
                    break block4;
                }
                if (var7_5 == null || !((var12_11 = var7_5.exception()) instanceof Some)) break block5;
                var13_12 = (Some)var12_11;
                e = (Throwable)var13_12.value();
                var15_14 = e;
                if (!(var15_14 instanceof CyclicReferenceException)) ** GOTO lbl-1000
                var16_15 = (CyclicReferenceException)var15_14;
                if (!domainPlugin$2.allowRecursiveReferences()) {
                    $this.ctx().violation(ParserSideValidations$.MODULE$.CycleReferenceError().id(), link$1.url(), var16_15.getMessage(), (YPart)((RefContainer)link$1.refs().head()).node());
                    var6_16 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$6(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                } else lbl-1000:
                // 2 sources

                {
                    if (!link$1.isInferred()) {
                        ((IterableLike)link$1.refs().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$7(amf.core.parser.RefContainer ), (Lamf/core/parser/RefContainer;)Lorg/yaml/model/YNode;)(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$8$adapted(amf.core.AMFCompiler java.lang.Throwable amf.core.parser.Reference org.yaml.model.YNode ), (Lorg/yaml/model/YNode;)Ljava/lang/Object;)((AMFCompiler)$this, (Throwable)e, (Reference)link$1));
                    }
                    var6_16 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$9(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                }
                var5_10 = var6_16;
                break block4;
            }
            var5_10 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$10(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return var5_10;
    }

    /*
     * Unable to fully structure code
     */
    public AMFCompiler(String rawUrl, Platform remote, Option<Context> base, Option<String> mediaType, Option<String> vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext, Environment env, ParsingOptions parsingOptions) {
        this.rawUrl = rawUrl;
        this.remote = remote;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.env = env;
        this.parsingOptions = parsingOptions;
        super();
        this.path = this.liftedTree1$1();
        this.context = (Context)base.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$context$1(amf.core.AMFCompiler amf.core.remote.Context ), (Lamf/core/remote/Context;)Lamf/core/remote/Context;)((AMFCompiler)this)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$context$2(amf.core.AMFCompiler ), ()Lamf/core/remote/Context;)((AMFCompiler)this));
        this.location = this.context().current();
        var12_11 = false;
        var13_12 = null;
        var14_13 = baseContext;
        if (!(var14_13 instanceof Some)) ** GOTO lbl-1000
        var12_11 = true;
        var13_12 = (Some)var14_13;
        given = (ParserContext)var13_12.value();
        if (given.currentFile().equals(this.location())) {
            var11_15 = given;
        } else if (var12_11) {
            given = (ParserContext)var13_12.value();
            var11_15 = given.forLocation(this.location());
        } else if (None$.MODULE$.equals(var14_13)) {
            var11_15 = new ParserContext(this.location(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4());
        } else {
            throw new MatchError(var14_13);
        }
        this.ctx = var11_15;
    }

    public static final /* synthetic */ Object $anonfun$parseReferences$8$adapted(AMFCompiler $this, Throwable e$1, Reference link$1, YNode ref) {
        AMFCompiler.$anonfun$parseReferences$8($this, e$1, link$1, ref);
        return BoxedUnit.UNIT;
    }
}

