/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.List;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ConstraintExecutors;
import org.topbraid.shacl.vocabulary.SH;

public class Constraint {
    private SHConstraintComponent component;
    private ConstraintExecutor executor;
    private RDFNode parameterValue;
    private List<SHParameter> params;
    private Shape shape;

    public Constraint(Shape shape, SHConstraintComponent component, List<SHParameter> params, RDFNode parameterValue) {
        this.component = component;
        this.params = params;
        this.parameterValue = parameterValue;
        this.shape = shape;
    }

    public void addBindings(QuerySolutionMap map) {
        if (this.parameterValue != null) {
            SHParameter param = this.params.get(0);
            if (!map.contains(param.getVarName())) {
                map.add(param.getVarName(), this.parameterValue);
            }
        } else {
            for (SHParameter param : this.params) {
                RDFNode parameterValue;
                String varName = param.getVarName();
                if (map.contains(varName) || (parameterValue = JenaUtil.getProperty(this.shape.getShapeResource(), param.getPredicate())) == null) continue;
                map.add(varName, parameterValue);
            }
        }
    }

    public SHConstraintComponent getComponent() {
        return this.component;
    }

    public Resource getContext() {
        if (this.shape.getShapeResource().hasProperty(SH.path)) {
            return SH.PropertyShape;
        }
        return SH.NodeShape;
    }

    public ConstraintExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = ConstraintExecutors.get().getExecutor(this);
        }
        return this.executor;
    }

    public RDFNode getParameterValue() {
        return this.parameterValue;
    }

    public Shape getShape() {
        return this.shape;
    }

    public SHShape getShapeResource() {
        return this.shape.getShapeResource();
    }

    public String toString() {
        return "Constraint " + this.component.getLocalName() + " at " + this.shape;
    }
}

