/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.path.Path;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.expr.AppendContext;
import org.topbraid.shacl.expr.AtomicNodeExpression;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;

public class PathExpression
extends ComplexNodeExpression {
    private NodeExpression input;
    private Path jenaPath;
    private Resource path;

    public PathExpression(Resource path, NodeExpression input) {
        this.input = input;
        this.path = path;
        if (path.isAnon()) {
            this.jenaPath = (Path)SHACLPaths.getJenaPath(SHACLPaths.getPathString(path), path.getModel());
        }
    }

    @Override
    public void appendLabel(AppendContext context, String targetVarName) {
        if (this.input instanceof ComplexNodeExpression) {
            String varName = context.getNextVarName();
            ((ComplexNodeExpression)this.input).appendLabel(context, varName);
            context.indent();
            context.append("?" + varName);
            context.append(" ");
            context.append(SHACLPaths.getPathString(this.path));
            context.append(" ");
            context.append("?" + targetVarName);
        } else {
            context.indent();
            if (this.input instanceof AtomicNodeExpression) {
                context.append(this.input.toString());
            } else {
                context.append("$this");
            }
            context.append(" ");
            context.append(SHACLPaths.getPathString(this.path));
            context.append(" ");
            context.append("?" + targetVarName);
        }
        context.append(" .\n");
    }

    @Override
    public List<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        if (this.input != null) {
            HashSet<RDFNode> results = new HashSet<RDFNode>();
            if (this.jenaPath == null) {
                for (RDFNode node : this.input.eval(focusNode, context)) {
                    SHACLPaths.addValueNodes(node.inModel(context.getDataset().getDefaultModel()), this.path, results);
                }
            } else {
                for (RDFNode node : this.input.eval(focusNode, context)) {
                    SHACLPaths.addValueNodes(node.inModel(context.getDataset().getDefaultModel()), this.jenaPath, results);
                }
            }
            return new ArrayList<RDFNode>(results);
        }
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        if (this.jenaPath == null) {
            SHACLPaths.addValueNodes(focusNode.inModel(context.getDataset().getDefaultModel()), this.path, results);
        } else {
            SHACLPaths.addValueNodes(focusNode.inModel(context.getDataset().getDefaultModel()), this.jenaPath, results);
        }
        return results;
    }
}

