/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.topbraid.spin.arq.AbstractFunction2;
import org.topbraid.spin.arq.functions.ConstructViolationsPFunction;
import org.topbraid.spin.constraints.ConstraintViolation;
import org.topbraid.spin.constraints.SPINConstraints;
import org.topbraid.spin.model.QueryOrTemplateCall;
import org.topbraid.spin.progress.NullProgressMonitor;

public class ViolatesConstraintsFunction
extends AbstractFunction2
implements FunctionFactory {
    public Function create(String uri) {
        return this;
    }

    @Override
    protected NodeValue exec(Node instanceNode, Node classNode, FunctionEnv env) {
        Model model = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
        Resource cls = (Resource)model.asRDFNode(classNode);
        List<QueryOrTemplateCall> qots = ConstructViolationsPFunction.getConstraints(cls);
        Resource instance = (Resource)model.asRDFNode(instanceNode);
        NullProgressMonitor monitor = new NullProgressMonitor();
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        for (QueryOrTemplateCall qot : qots) {
            if (qot.getTemplateCall() != null) {
                SPINConstraints.addTemplateCallResults(results, qot, instance, false, monitor);
            } else if (qot.getQuery() != null) {
                SPINConstraints.addQueryResults(results, qot, instance, false, null, monitor);
            }
            if (results.isEmpty()) continue;
            return NodeValue.makeBoolean((boolean)true);
        }
        return NodeValue.makeBoolean((boolean)false);
    }
}

