/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.jena.atlas.iterator.Iter;

public class StringUtils {
    static NumberFormat integerFormat = NumberFormat.getNumberInstance();
    static FastDateFormat dateTimeFormat = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss");
    static DecimalFormat decimalFormat = new DecimalFormat("#,##0.0");
    private static Pattern p = Pattern.compile("http:[^ \n]*[#/]([^/ \n]*)");

    public static String str(long v) {
        return integerFormat.format(v);
    }

    public static String str(Date date2) {
        return dateTimeFormat.format(date2);
    }

    public static String str(float value) {
        return decimalFormat.format(value);
    }

    public static String str(double value) {
        return decimalFormat.format(value);
    }

    public static <T> String str(T[] array) {
        return Arrays.asList(array).toString();
    }

    public static String printAbbrev(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        String x = obj.toString();
        return p.matcher(x).replaceAll("::$1");
    }

    public static <T> String printAbbrevList(List<T> objs) {
        String x = Iter.asString(objs, (String)"\n");
        return StringUtils.printAbbrev(x);
    }
}

