/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.CSVOutput;
import org.apache.jena.sparql.resultset.JSONOutput;
import org.apache.jena.sparql.resultset.TSVOutput;
import org.apache.jena.sparql.resultset.TextOutput;
import org.apache.jena.sparql.resultset.XMLOutput;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterRegistry {
    private static Map<Lang, ResultSetWriterFactory> registry = new HashMap<Lang, ResultSetWriterFactory>();
    private static boolean initialized = false;
    private static ResultSetWriter writerXML;
    private static ResultSetWriter writerJSON;
    private static ResultSetWriter writerCSV;
    private static ResultSetWriter writerTSV;
    private static ResultSetWriter writerNo;
    private static ResultSetWriter writerText;

    public static ResultSetWriterFactory lookup(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static void register(Lang lang, ResultSetWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetWriterFactoryStd factory = new ResultSetWriterFactoryStd();
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetXML, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetJSON, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetCSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetTSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetThrift, new ResultSetWriterThriftFactory());
        ResultSetWriterRegistry.register(ResultSetLang.SPARQLResultSetText, factory);
    }

    static {
        ResultSetLang.init();
        writerXML = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
                XMLOutput xOut = new XMLOutput(null);
                xOut.format(out, resultSet);
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
                throw new NotImplemented("Writer");
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
                XMLOutput xOut = new XMLOutput(null);
                xOut.format(out, result);
            }
        };
        writerJSON = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
                JSONOutput jOut = new JSONOutput();
                jOut.format(out, resultSet);
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
                throw new NotImplemented("Writer");
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
                JSONOutput jOut = new JSONOutput();
                jOut.format(out, result);
            }
        };
        writerCSV = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
                CSVOutput fmt = new CSVOutput();
                fmt.format(out, resultSet);
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
                throw new NotImplemented("Writer");
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
                CSVOutput fmt = new CSVOutput();
                fmt.format(out, result);
            }
        };
        writerTSV = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
                TSVOutput fmt = new TSVOutput();
                fmt.format(out, resultSet);
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
                throw new NotImplemented("Writer");
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
                TSVOutput fmt = new TSVOutput();
                fmt.format(out, result);
            }
        };
        writerNo = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
            }
        };
        writerText = new ResultSetWriter(){

            @Override
            public void write(OutputStream out, ResultSet resultSet, Context context) {
                TextOutput tFmt = new TextOutput(new SerializationContext((Prologue)null));
                tFmt.format(out, resultSet);
            }

            @Override
            public void write(Writer out, ResultSet resultSet, Context context) {
                throw new NotImplemented("Writer");
            }

            @Override
            public void write(OutputStream out, boolean result, Context context) {
                TextOutput tFmt = new TextOutput(new SerializationContext((Prologue)null));
                tFmt.format(out, result);
            }
        };
    }

    private static class ResultSetWriterThriftFactory
    implements ResultSetWriterFactory {
        private ResultSetWriterThriftFactory() {
        }

        @Override
        public ResultSetWriter create(Lang lang) {
            return new ResultSetWriter(){

                @Override
                public void write(OutputStream out, ResultSet resultSet, Context context) {
                    BinRDF.writeResultSet(out, resultSet);
                }

                @Override
                public void write(Writer out, ResultSet resultSet, Context context) {
                    throw new NotImplemented("Writing binary data to a java.io.Writer is not possible");
                }

                @Override
                public void write(OutputStream out, boolean result, Context context) {
                    throw new NotImplemented("No Thrift RDF encoding defined for boolean results");
                }
            };
        }
    }

    private static class ResultSetWriterFactoryStd
    implements ResultSetWriterFactory {
        private ResultSetWriterFactoryStd() {
        }

        @Override
        public ResultSetWriter create(Lang lang) {
            if ((lang = Objects.requireNonNull(lang, "Language must not be null")).equals(ResultSetLang.SPARQLResultSetXML)) {
                return writerXML;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetJSON)) {
                return writerJSON;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetCSV)) {
                return writerCSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetTSV)) {
                return writerTSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetText)) {
                return writerText;
            }
            throw new RiotException("Lang not registered (ResultSet writer)");
        }
    }
}

