/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;

class SHACLRecursionGuard {
    private static ThreadLocal<Set<Call>> sets = new ThreadLocal();

    SHACLRecursionGuard() {
    }

    public static boolean start(Node resource, Node matchType) {
        Call call;
        Set<Call> set = sets.get();
        if (set == null) {
            set = new HashSet<Call>();
            sets.set(set);
        }
        if (set.contains(call = new Call(resource, matchType))) {
            return true;
        }
        set.add(call);
        return false;
    }

    public static void end(Node resource, Node matchType) {
        sets.get().remove(new Call(resource, matchType));
    }

    private static class Call {
        private Node resource;
        private Node shape;

        Call(Node resource, Node shape) {
            this.resource = resource;
            this.shape = shape;
        }

        public boolean equals(Object other) {
            if (other instanceof Call) {
                return ((Call)other).resource.equals((Object)this.resource) && ((Call)other).shape.equals((Object)this.shape);
            }
            return false;
        }

        public int hashCode() {
            return this.resource.hashCode() + this.shape.hashCode();
        }

        public String toString() {
            return "(" + this.resource + ", " + this.shape + ")";
        }
    }
}

