/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.inference.ControlledUpdateGraph;
import org.topbraid.spin.inference.ControlledUpdateGraphStore;
import org.topbraid.spin.inference.DefaultSPINRuleComparator;
import org.topbraid.spin.inference.SPINConstructors;
import org.topbraid.spin.inference.SPINExplanations;
import org.topbraid.spin.inference.SPINInferencesOptimizer;
import org.topbraid.spin.inference.SPINRuleComparator;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.CommandWrapper;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.QueryWrapper;
import org.topbraid.spin.util.SPINQueryFinder;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.util.UpdateUtil;
import org.topbraid.spin.util.UpdateWrapper;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINInferences {
    private static List<SPINInferencesOptimizer> optimizers = new LinkedList<SPINInferencesOptimizer>();

    public static void addOptimizer(SPINInferencesOptimizer optimizer) {
        optimizers.add(optimizer);
    }

    public static void removeOptimizer(SPINInferencesOptimizer optimizer) {
        optimizers.remove(optimizer);
    }

    public static boolean isRuleProperty(Property property) {
        if (SPIN.rule.equals(property)) {
            return true;
        }
        if (JenaUtil.hasSuperProperty(property, property.getModel().getProperty(SPIN.rule.getURI()))) {
            return true;
        }
        return JenaUtil.hasIndirectType((Resource)property, SPIN.RuleProperty.inModel(property.getModel()));
    }

    public static int run(Model queryModel, Model newTriples, SPINExplanations explanations, List<SPINStatistics> statistics, boolean singlePass, ProgressMonitor monitor) {
        return SPINInferences.run(queryModel, SPIN.rule, newTriples, explanations, statistics, singlePass, monitor);
    }

    public static int run(Model queryModel, Property rulePredicate, Model newTriples, SPINExplanations explanations, List<SPINStatistics> statistics, boolean singlePass, ProgressMonitor monitor) {
        Map<Resource, List<CommandWrapper>> cls2Query = SPINQueryFinder.getClass2QueryMap(queryModel, queryModel, rulePredicate, true, false);
        Map<Resource, List<CommandWrapper>> cls2Constructor = SPINQueryFinder.getClass2QueryMap(queryModel, queryModel, SPIN.constructor, true, false);
        DefaultSPINRuleComparator comparator = new DefaultSPINRuleComparator(queryModel);
        return SPINInferences.run(queryModel, newTriples, cls2Query, cls2Constructor, explanations, statistics, singlePass, rulePredicate, comparator, monitor);
    }

    public static int run(Model queryModel, Model newTriples, Map<Resource, List<CommandWrapper>> class2Query, Map<Resource, List<CommandWrapper>> class2Constructor, SPINExplanations explanations, List<SPINStatistics> statistics, boolean singlePass, Property rulePredicate, SPINRuleComparator comparator, ProgressMonitor monitor) {
        boolean changed;
        for (SPINInferencesOptimizer optimizer : optimizers) {
            class2Query = optimizer.optimize(class2Query);
        }
        ArrayList<CommandWrapper> rulesList = new ArrayList<CommandWrapper>();
        HashMap<CommandWrapper, Resource> rule2Class = new HashMap<CommandWrapper, Resource>();
        for (Resource cls : class2Query.keySet()) {
            List<CommandWrapper> queryWrappers = class2Query.get(cls);
            for (CommandWrapper queryWrapper : queryWrappers) {
                rulesList.add(queryWrapper);
                rule2Class.put(queryWrapper, cls);
            }
        }
        if (comparator != null) {
            Collections.sort(rulesList, comparator);
        }
        if (rulePredicate.getModel() == null) {
            rulePredicate = queryModel.getProperty(rulePredicate.getURI());
        }
        int iteration = 1;
        do {
            HashSet<Statement> newRules = new HashSet<Statement>();
            changed = false;
            for (CommandWrapper arqWrapper : rulesList) {
                StringBuffer sb;
                Property predicate;
                Integer maxIterationCount;
                if (arqWrapper.getStatement() != null && (maxIterationCount = JenaUtil.getIntegerProperty((Resource)(predicate = arqWrapper.getStatement().getPredicate()), SPIN.rulePropertyMaxIterationCount)) != null && iteration > maxIterationCount) continue;
                Resource cls = (Resource)rule2Class.get(arqWrapper);
                if (monitor != null) {
                    if (monitor.isCanceled()) {
                        return iteration - 1;
                    }
                    sb = new StringBuffer("TopSPIN iteration ");
                    sb.append(iteration);
                    sb.append(" at ");
                    sb.append(SPINLabels.get().getLabel(cls));
                    sb.append(", rule ");
                    sb.append(arqWrapper.getLabel() != null ? arqWrapper.getLabel() : arqWrapper.getText());
                    monitor.subTask(sb.toString());
                }
                sb = new StringBuffer();
                sb.append("Inferred by ");
                sb.append(SPINLabels.get().getLabel((Resource)rulePredicate));
                sb.append(" at class ");
                sb.append(SPINLabels.get().getLabel(cls));
                sb.append(":\n\n" + arqWrapper.getText());
                String explanationText = sb.toString();
                boolean thisUnbound = arqWrapper.isThisUnbound();
                changed |= SPINInferences.runCommandOnClass(arqWrapper, arqWrapper.getLabel(), queryModel, newTriples, cls, true, class2Constructor, statistics, explanations, explanationText, newRules, thisUnbound, monitor);
                if (SPINUtil.isRootClass(cls) || thisUnbound) continue;
                Set<Resource> subClasses = JenaUtil.getAllSubClasses(cls);
                for (Resource subClass : subClasses) {
                    changed |= SPINInferences.runCommandOnClass(arqWrapper, arqWrapper.getLabel(), queryModel, newTriples, subClass, true, class2Constructor, statistics, explanations, explanationText, newRules, thisUnbound, monitor);
                }
            }
            ++iteration;
            if (newRules.isEmpty() || singlePass) continue;
            for (Statement s : newRules) {
                SPINQueryFinder.add(class2Query, queryModel.asStatement(s.asTriple()), queryModel, true, false);
            }
        } while (!singlePass && changed);
        return iteration - 1;
    }

    private static boolean runCommandOnClass(CommandWrapper commandWrapper, String queryLabel, Model queryModel, Model newTriples, Resource cls, boolean checkContains, Map<Resource, List<CommandWrapper>> class2Constructor, List<SPINStatistics> statistics, SPINExplanations explanations, String explanationText, Set<Statement> newRules, boolean thisUnbound, ProgressMonitor monitor) {
        if (thisUnbound || SPINUtil.isRootClass(cls) || queryModel.contains(null, RDF.type, (RDFNode)cls)) {
            boolean changed = false;
            QuerySolutionMap bindings = new QuerySolutionMap();
            boolean needsClass = !SPINUtil.isRootClass(cls) && !thisUnbound;
            Map<String, RDFNode> initialBindings = commandWrapper.getTemplateBinding();
            if (initialBindings != null) {
                for (String varName : initialBindings.keySet()) {
                    RDFNode value = initialBindings.get(varName);
                    bindings.add(varName, value);
                }
            }
            long startTime = System.currentTimeMillis();
            HashMap<Resource, Resource> newInstances = new HashMap<Resource, Resource>();
            if (commandWrapper instanceof QueryWrapper) {
                Throwable instance;
                Model cm;
                Query arq = ((QueryWrapper)commandWrapper).getQuery();
                if (commandWrapper.isThisDeep() && needsClass) {
                    cm = JenaUtil.createDefaultModel();
                    StmtIterator it = queryModel.listStatements(null, RDF.type, (RDFNode)cls);
                    while (it.hasNext()) {
                        instance = ((Statement)it.next()).getSubject();
                        bindings.add("this", (RDFNode)instance);
                        QueryExecution qexec2 = ARQFactory.get().createQueryExecution(arq, queryModel, (QuerySolution)bindings);
                        Throwable throwable = null;
                        try {
                            qexec2.execConstruct(cm);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (qexec2 == null) continue;
                            if (throwable != null) {
                                try {
                                    qexec2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            qexec2.close();
                        }
                    }
                } else {
                    if (needsClass) {
                        bindings.add("TYPE_CLASS", (RDFNode)cls);
                    }
                    instance = null;
                    try (QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, queryModel, (QuerySolution)bindings);){
                        cm = qexec.execConstruct();
                    }
                    catch (Throwable qexec2) {
                        instance = qexec2;
                        throw qexec2;
                    }
                }
                StmtIterator cit = cm.listStatements();
                while (cit.hasNext()) {
                    Statement s = (Statement)cit.next();
                    if (checkContains && queryModel.contains(s)) continue;
                    changed = true;
                    newTriples.add(s);
                    if (explanations != null && commandWrapper.getStatement() != null) {
                        Resource source = commandWrapper.getStatement().getSubject();
                        explanations.put(s.asTriple(), explanationText, source.asNode(), commandWrapper.getSource() != null ? commandWrapper.getSource().asNode() : null);
                    }
                    if (RDF.type.equals(s.getPredicate()) && s.getObject().isResource()) {
                        Resource subject = s.getSubject().inModel(queryModel);
                        newInstances.put(subject, s.getResource());
                    }
                    if (!SPIN.rule.equals(s.getPredicate())) continue;
                    newRules.add(s);
                }
            } else {
                UpdateWrapper updateWrapper = (UpdateWrapper)commandWrapper;
                Map<String, RDFNode> templateBindings = commandWrapper.getTemplateBinding();
                Dataset dataset = ARQFactory.get().getDataset(queryModel);
                Update update = updateWrapper.getUpdate();
                Collection<Graph> updateGraphs = UpdateUtil.getUpdatedGraphs(update, dataset.asDatasetGraph(), templateBindings);
                ControlledUpdateGraphStore cugs = new ControlledUpdateGraphStore(dataset, updateGraphs);
                if (commandWrapper.isThisDeep() && needsClass) {
                    for (Statement s : queryModel.listStatements(null, RDF.type, (RDFNode)cls).toList()) {
                        Resource instance = s.getSubject();
                        bindings.add("this", (RDFNode)instance);
                        UpdateProcessor up = UpdateExecutionFactory.create((Update)update, (DatasetGraph)cugs, (Binding)JenaUtil.asBinding((QuerySolution)bindings));
                        up.execute();
                    }
                } else {
                    if (needsClass) {
                        bindings.add("TYPE_CLASS", (RDFNode)cls);
                    }
                    UpdateProcessor up = UpdateExecutionFactory.create((Update)update, (DatasetGraph)cugs, (Binding)JenaUtil.asBinding((QuerySolution)bindings));
                    up.execute();
                }
                for (ControlledUpdateGraph cug : cugs.getControlledUpdateGraphs()) {
                    changed |= cug.isChanged();
                    for (Triple triple : cug.getAddedTriples()) {
                        if (!RDF.type.asNode().equals((Object)triple.getPredicate()) || triple.getObject().isLiteral()) continue;
                        Resource subject = (Resource)queryModel.asRDFNode(triple.getSubject());
                        newInstances.put(subject, (Resource)queryModel.asRDFNode(triple.getObject()));
                    }
                }
            }
            if (statistics != null) {
                String queryText;
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                Command spinCommand = commandWrapper.getSPINCommand();
                String string = queryText = spinCommand != null ? SPINLabels.get().getLabel(spinCommand) : commandWrapper.getLabel();
                if (queryLabel == null) {
                    queryLabel = queryText;
                }
                statistics.add(new SPINStatistics(queryLabel, queryText, duration, startTime, cls.asNode()));
            }
            if (!newInstances.isEmpty()) {
                ArrayList<Resource> newRs = new ArrayList<Resource>(newInstances.keySet());
                SPINConstructors.construct(queryModel, newRs, newTriples, new HashSet<Resource>(), class2Constructor, statistics, explanations, monitor);
            }
            return changed;
        }
        return false;
    }

    public static boolean runQueryOnInstance(QueryWrapper queryWrapper, Model queryModel, Model newTriples, Resource instance, boolean checkContains) {
        boolean changed = false;
        QuerySolutionMap bindings = new QuerySolutionMap();
        bindings.add("this", (RDFNode)instance);
        Map<String, RDFNode> initialBindings = queryWrapper.getTemplateBinding();
        if (initialBindings != null) {
            for (String varName : initialBindings.keySet()) {
                RDFNode value = initialBindings.get(varName);
                bindings.add(varName, value);
            }
        }
        QueryExecution qexec = ARQFactory.get().createQueryExecution(queryWrapper.getQuery(), queryModel, (QuerySolution)bindings);
        Model cm = qexec.execConstruct();
        StmtIterator cit = cm.listStatements();
        while (cit.hasNext()) {
            Statement s = cit.nextStatement();
            if (checkContains && queryModel.contains(s)) continue;
            changed = true;
            newTriples.add(s);
        }
        return changed;
    }
}

