/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.net.MalformedURLException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotChars;

public class NodeFormatterTTL
extends NodeFormatterNT {
    private final NodeToLabel nodeToLabel;
    private final PrefixMap prefixMap;
    private final String baseIRI;
    private final IRI iriResolver;
    private static int relFlags = 9;
    private static final String dtDecimal = XSDDatatype.XSDdecimal.getURI();
    private static final String dtInteger = XSDDatatype.XSDinteger.getURI();
    private static final String dtDouble = XSDDatatype.XSDdouble.getURI();
    private static final String dtBoolean = XSDDatatype.XSDboolean.getURI();

    public NodeFormatterTTL(String baseIRI, PrefixMap prefixMap) {
        this(baseIRI, prefixMap, NodeToLabel.createBNodeByLabelEncoded());
    }

    public NodeFormatterTTL(String baseIRI, PrefixMap prefixMap, NodeToLabel nodeToLabel) {
        super(CharSpace.UTF8);
        this.nodeToLabel = nodeToLabel;
        if (prefixMap == null) {
            prefixMap = PrefixMapFactory.create();
        }
        this.prefixMap = prefixMap;
        this.baseIRI = baseIRI;
        this.iriResolver = baseIRI != null ? IRIResolver.iriFactory.construct(baseIRI) : null;
    }

    @Override
    public void formatURI(AWriter w, String uriStr) {
        String x;
        Pair<String, String> pName = this.prefixMap.abbrev(uriStr);
        if (pName != null) {
            String pref = (String)pName.getLeft();
            String ln2 = (String)pName.getRight();
            if (NodeFormatterTTL.safeForPrefix(pref) && NodeFormatterTTL.safeForPrefixLocalname(ln2)) {
                w.print((String)pName.getLeft());
                w.print(':');
                w.print((String)pName.getRight());
                return;
            }
        }
        if (this.iriResolver != null && (x = this.abbrevByBase(uriStr)) != null) {
            w.print('<');
            w.print(x);
            w.print('>');
            return;
        }
        super.formatURI(w, uriStr);
    }

    private String abbrevByBase(String uri) {
        IRI rel = this.iriResolver.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }

    static boolean safeForPrefix(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_BASE(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT(str2, idx, N - 1)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS(str2, idx)) == -1) {
            return false;
        }
        return idx == N;
    }

    @Override
    public void formatBNode(AWriter w, Node n) {
        String x = (String)this.nodeToLabel.get(null, n);
        w.print(x);
    }

    static boolean safeForPrefixLocalname(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_U_or_digit(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT(str2, idx, N - 1)) == -1) {
            return false;
        }
        return (idx = NodeFormatterTTL.skip1_PN_CHARS(str2, idx)) == N;
    }

    private static boolean is_PN_CHARS_BASE(int ch) {
        return RiotChars.isAlpha(ch);
    }

    private static boolean is_PN_CHARS_U(int ch) {
        return NodeFormatterTTL.is_PN_CHARS_BASE(ch) || ch == 95;
    }

    private static boolean is_PN_CHARS(int ch) {
        return NodeFormatterTTL.is_PN_CHARS_U(ch) || ch == 45 || RiotChars.isDigit(ch) || NodeFormatterTTL.isCharsExtra(ch);
    }

    private static boolean isCharsExtra(int ch) {
        return ch == 183 || RiotChars.range(ch, '\u0300', '\u036f') || RiotChars.range(ch, '\u203f', '\u2040');
    }

    private static int skip1_PN_CHARS_U_or_digit(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS_U(ch)) {
            return idx + 1;
        }
        if (RiotChars.isDigit(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skip1_PN_CHARS_BASE(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS_BASE(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skipAny_PN_CHARS_or_DOT(String str2, int idx, int max2) {
        for (int i = idx; i < max2; ++i) {
            char ch = str2.charAt(i);
            if (NodeFormatterTTL.is_PN_CHARS(ch) || ch == '.') continue;
            return i;
        }
        return max2;
    }

    private static int skip1_PN_CHARS(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS(ch)) {
            return idx + 1;
        }
        return -1;
    }

    @Override
    public void formatLitDT(AWriter w, String lex, String datatypeURI) {
        boolean b = this.writeLiteralAbbreviated(w, lex, datatypeURI);
        if (b) {
            return;
        }
        this.writeLiteralLongForm(w, lex, datatypeURI);
    }

    protected void writeLiteralLongForm(AWriter w, String lex, String datatypeURI) {
        this.writeLiteralOneLine(w, lex, datatypeURI);
    }

    protected void writeLiteralOneLine(AWriter w, String lex, String datatypeURI) {
        super.formatLitDT(w, lex, datatypeURI);
    }

    protected boolean writeLiteralAbbreviated(AWriter w, String lex, String datatypeURI) {
        if (dtDecimal.equals(datatypeURI)) {
            if (NodeFormatterTTL.validDecimal(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtInteger.equals(datatypeURI)) {
            if (NodeFormatterTTL.validInteger(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtDouble.equals(datatypeURI)) {
            if (NodeFormatterTTL.validDouble(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtBoolean.equals(datatypeURI) && (lex.equals("true") || lex.equals("false"))) {
            w.print(lex);
            return true;
        }
        return false;
    }

    private static boolean validInteger(String lex) {
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDecimal(String lex) {
        int N = lex.length();
        if (N <= 1) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        if ((idx = NodeFormatterTTL.skipDigits(lex, idx)) >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch != '.') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDouble(String lex) {
        int idx2;
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        boolean initialDigits = (idx = NodeFormatterTTL.skipSign(lex, idx)) != (idx2 = NodeFormatterTTL.skipDigits(lex, idx));
        idx = idx2;
        if (idx >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch == '.') {
            if (++idx >= N) {
                return false;
            }
            idx2 = NodeFormatterTTL.skipDigits(lex, idx);
            boolean trailingDigits = idx != idx2;
            idx = idx2;
            if (idx >= N) {
                return false;
            }
            if (!initialDigits && !trailingDigits) {
                return false;
            }
        }
        if ((ch = lex.charAt(idx)) != 'e' && ch != 'E') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipSign(lex, idx)) >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static int skipDigits(String str2, int start) {
        int N = str2.length();
        for (int i = start; i < N; ++i) {
            char ch = str2.charAt(i);
            if (RiotChars.isDigit(ch)) continue;
            return i;
        }
        return N;
    }

    private static int skipSign(String str2, int idx) {
        int N = str2.length();
        char ch = str2.charAt(idx);
        if (ch == '+' || ch == '-') {
            return idx + 1;
        }
        return idx;
    }
}

