/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsListener;

public class SPINStatisticsManager {
    private static SPINStatisticsManager singleton = new SPINStatisticsManager();
    private Set<SPINStatisticsListener> listeners = new HashSet<SPINStatisticsListener>();
    private boolean recording;
    private boolean recordingNativeFunctions;
    private boolean recordingSPINFunctions;
    private List<SPINStatistics> stats = Collections.synchronizedList(new LinkedList());

    public static SPINStatisticsManager get() {
        return singleton;
    }

    public void addListener(SPINStatisticsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void add(Iterable<SPINStatistics> values) {
        this.addSilently(values);
        this.notifyListeners();
    }

    public void addSilently(Iterable<SPINStatistics> values) {
        for (SPINStatistics s : values) {
            this.stats.add(s);
        }
    }

    public synchronized List<SPINStatistics> getStatistics() {
        return this.stats;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isRecordingNativeFunctions() {
        return this.recordingNativeFunctions;
    }

    public boolean isRecordingSPINFunctions() {
        return this.recordingSPINFunctions;
    }

    public void removeListener(SPINStatisticsListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void reset() {
        this.stats.clear();
        this.notifyListeners();
    }

    public void notifyListeners() {
        for (SPINStatisticsListener listener : new ArrayList<SPINStatisticsListener>(this.listeners)) {
            listener.statisticsUpdated();
        }
    }

    public void setRecording(boolean value) {
        this.recording = value;
    }

    public void setRecordingNativeFunctions(boolean value) {
        this.recordingNativeFunctions = value;
    }

    public void setRecordingSPINFunctions(boolean value) {
        this.recordingSPINFunctions = value;
    }
}

