/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.js;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.NashornUtil;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.js.model.TermFactory;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.ExceptionUtil;
import org.topbraid.spin.util.JenaUtil;

public class NashornScriptEngine
implements JSScriptEngine {
    private static final String ARGS_FUNCTION_NAME = "theGoodOldArgsFunction";
    private static final String ARGS_FUNCTION = "function theGoodOldArgsFunction(funcString) {\n    var args = funcString.match(/function\\s.*?\\(([^)]*)\\)/)[1];\n    return args.split(',').map(function(arg) {\n        return arg.replace(/\\/\\*.*\\*\\//, '').trim();\n    }).filter(function(arg) {\n        return arg;\n    });\n}";
    public static final String DASH_JS = "http://datashapes.org/js/dash.js";
    public static final String RDFQUERY_JS = "http://datashapes.org/js/rdfquery.js";
    private ScriptEngine engine;
    private Map<String, List<String>> functionParametersMap = new HashMap<String, List<String>>();
    private Set<Resource> visitedLibraries = new HashSet<Resource>();
    private Set<String> loadedURLs = new HashSet<String>();

    public NashornScriptEngine() {
        this.engine = this.findNashorn();
        this.engine.put("TermFactory", new TermFactory());
        try {
            this.engine.eval(ARGS_FUNCTION);
        }
        catch (ScriptException ex) {
            ExceptionUtil.throwUnchecked(ex);
        }
    }

    private ScriptEngine findNashorn() {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        if (nashorn == null) {
            nashorn = new ScriptEngineManager(null).getEngineByName("nashorn");
        }
        if (nashorn == null) {
            throw new RuntimeException("Oracle Nashorn not found in the current context");
        }
        return nashorn;
    }

    @Override
    public Object eval(String expr) throws ScriptException {
        return this.engine.eval(expr);
    }

    @Override
    public void executeLibraries(Resource e) throws Exception {
        for (Resource library : JenaUtil.getResourceProperties(e, SH.jsLibrary)) {
            if (this.visitedLibraries.contains(library)) continue;
            this.visitedLibraries.add(library);
            this.executeLibraries(library);
        }
        for (Statement s : e.listProperties(SH.jsLibraryURL).toList()) {
            if (!s.getObject().isLiteral()) continue;
            String url = s.getString();
            this.executeScriptFromURL(url);
        }
    }

    @Override
    public final void executeScriptFromURL(String url) throws Exception {
        if (!this.loadedURLs.contains(url)) {
            this.loadedURLs.add(url);
            try (Reader reader = this.createScriptReader(url);){
                this.engine.eval(reader);
            }
        }
    }

    protected Reader createScriptReader(String url) throws Exception {
        if (DASH_JS.equals(url)) {
            return new InputStreamReader(NashornScriptEngine.class.getResourceAsStream("/etc/dash.js"));
        }
        if (RDFQUERY_JS.equals(url)) {
            return new InputStreamReader(NashornScriptEngine.class.getResourceAsStream("/etc/rdfquery.js"));
        }
        return new InputStreamReader(new URL(url).openStream());
    }

    @Override
    public Object get(String varName) {
        return this.engine.get(varName);
    }

    public final ScriptEngine getEngine() {
        return this.engine;
    }

    private List<String> getFunctionParameters(String functionName) throws ScriptException {
        List<String> cached = this.functionParametersMap.get(functionName);
        if (cached != null) {
            return cached;
        }
        Object what = this.engine.get(functionName);
        if (what == null) {
            throw new ScriptException("Cannot find JavaScript function \"" + functionName + "\"");
        }
        try {
            String funcString = what.toString();
            Object result = ((Invocable)((Object)this.engine)).invokeFunction(ARGS_FUNCTION_NAME, funcString);
            Object[] params = NashornUtil.asArray(result);
            ArrayList<String> results = new ArrayList<String>(params.length);
            for (Object param : params) {
                results.add((String)param);
            }
            this.functionParametersMap.put(functionName, results);
            return results;
        }
        catch (Exception ex) {
            throw new ScriptException(ex);
        }
    }

    @Override
    public Object invokeFunction(String functionName, QuerySolution bindings) throws ScriptException, NoSuchMethodException {
        List<String> functionParams = this.getFunctionParameters(functionName);
        Object[] params = new Object[functionParams.size()];
        Iterator varNames = bindings.varNames();
        while (varNames.hasNext()) {
            RDFNode value;
            String varName = (String)varNames.next();
            int index = functionParams.indexOf(varName);
            if (index < 0) {
                index = functionParams.indexOf("$" + varName);
            }
            if (index < 0 || (value = bindings.get(varName)) == null) continue;
            params[index] = JSFactory.asJSTerm(value.asNode());
        }
        return this.invokeFunctionOrdered(functionName, params);
    }

    @Override
    public Object invokeFunctionOrdered(String functionName, Object[] params) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)this.engine)).invokeFunction(functionName, params);
    }

    @Override
    public void put(String varName, Object value) {
        this.engine.put(varName, value);
    }
}

