/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.shacl.arq.SHACLFunctionDriver;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.SPINBodyFunctionDriver;
import org.topbraid.spin.arq.SPINFunctionDriver;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINFunctionDrivers
implements SPINFunctionDriver {
    private static SPINFunctionDrivers singleton = new SPINFunctionDrivers();
    private Map<Property, SPINFunctionDriver> drivers = new HashMap<Property, SPINFunctionDriver>();

    public static SPINFunctionDrivers get() {
        return singleton;
    }

    public static void set(SPINFunctionDrivers value) {
        singleton = value;
    }

    SPINFunctionDrivers() {
        this.register(SPIN.body, new SPINBodyFunctionDriver());
        this.register(SH.ask, new SHACLFunctionDriver());
        this.register(SH.select, new SHACLFunctionDriver());
        this.register(SH.jsLibrary, new SHACLFunctionDriver());
    }

    @Override
    public SPINFunctionFactory create(Resource function) {
        SPINFunctionDriver driver = this.getDriver(function);
        if (driver != null) {
            return driver.create(function);
        }
        return null;
    }

    public void register(Property predicate, SPINFunctionDriver driver) {
        this.drivers.put(predicate, driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SPINFunctionDriver getDriver(Resource spinFunction) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            SPINFunctionDriver direct = this.getDirectDriver(spinFunction);
            if (direct != null) {
                SPINFunctionDriver sPINFunctionDriver = direct;
                return sPINFunctionDriver;
            }
            SPINFunctionDriver sPINFunctionDriver = this.getDriver(spinFunction, new HashSet<Resource>());
            return sPINFunctionDriver;
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    private SPINFunctionDriver getDriver(Resource spinFunction, Set<Resource> reached) {
        reached.add(spinFunction);
        for (Resource superClass : JenaUtil.getSuperClasses(spinFunction)) {
            SPINFunctionDriver superFunction;
            if (reached.contains(spinFunction) || (superFunction = this.getDirectDriver(superClass)) == null) continue;
            return superFunction;
        }
        return null;
    }

    private SPINFunctionDriver getDirectDriver(Resource spinFunction) {
        if (!spinFunction.hasProperty(SPIN.abstract_, (RDFNode)JenaDatatypes.TRUE) && !spinFunction.hasProperty(DASH.abstract_, (RDFNode)JenaDatatypes.TRUE)) {
            StmtIterator it = spinFunction.listProperties();
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                SPINFunctionDriver driver = this.drivers.get(s.getPredicate());
                if (driver == null) continue;
                it.close();
                return driver;
            }
        }
        return null;
    }
}

