/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.model.impl.ModuleCallImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.vocabulary.SPIN;

public class TemplateCallImpl
extends ModuleCallImpl
implements TemplateCall {
    public TemplateCallImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public QueryExecution createQueryExecution(Dataset dataset) {
        Module template = this.getModule();
        Query query = ARQFactory.get().createQuery(SPINFactory.asQuery(template.getBody()));
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        Map<Argument, RDFNode> args = this.getArgumentsMap();
        for (Argument arg : args.keySet()) {
            RDFNode value = args.get(arg);
            initialBindings.add(arg.getVarName(), value);
        }
        return ARQFactory.get().createQueryExecution(query, dataset, (QuerySolution)initialBindings);
    }

    @Override
    public Map<Argument, RDFNode> getArgumentsMap() {
        HashMap<Argument, RDFNode> map = new HashMap<Argument, RDFNode>();
        Template template = this.getTemplate();
        if (template != null) {
            for (Argument ad : template.getArguments(false)) {
                Statement valueS;
                Property argProperty = ad.getPredicate();
                if (argProperty == null || (valueS = this.getProperty(argProperty)) == null) continue;
                map.put(ad, valueS.getObject());
            }
        }
        return map;
    }

    @Override
    public Map<Property, RDFNode> getArgumentsMapByProperties() {
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        Template template = this.getTemplate();
        if (template != null) {
            for (Argument ad : template.getArguments(false)) {
                Statement valueS;
                Property argProperty = ad.getPredicate();
                if (argProperty == null || (valueS = this.getProperty(argProperty)) == null) continue;
                map.put(argProperty, valueS.getObject());
            }
        }
        return map;
    }

    @Override
    public Map<String, RDFNode> getArgumentsMapByVarNames() {
        HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
        Template template = this.getTemplate();
        if (template != null) {
            for (Argument ad : template.getArguments(false)) {
                Property argProperty = ad.getPredicate();
                if (argProperty == null) continue;
                String varName = ad.getVarName();
                Statement valueS = this.getProperty(argProperty);
                if (valueS != null) {
                    map.put(varName, valueS.getObject());
                    continue;
                }
                if (ad.getDefaultValue() == null) continue;
                map.put(varName, ad.getDefaultValue());
            }
        }
        return map;
    }

    @Override
    public QuerySolutionMap getInitialBinding() {
        QuerySolutionMap map = new QuerySolutionMap();
        Map<String, RDFNode> input = this.getArgumentsMapByVarNames();
        for (String varName : input.keySet()) {
            RDFNode value = input.get(varName);
            map.add(varName, value);
        }
        return map;
    }

    @Override
    public Module getModule() {
        return this.getTemplate();
    }

    @Override
    public String getQueryString() {
        Map<String, RDFNode> map = this.getArgumentsMapByVarNames();
        StringPrintContext p = new StringPrintContext(new StringBuilder(), map);
        Template template = this.getTemplate();
        p.setUsePrefixes(false);
        template.getBody().print(p);
        return p.getString();
    }

    @Override
    public Template getTemplate() {
        Statement s = this.getProperty(RDF.type);
        if (s != null && s.getObject().isURIResource()) {
            return SPINModuleRegistry.get().getTemplate(s.getResource().getURI(), this.getModel());
        }
        return null;
    }

    @Override
    public void print(PrintContext p) {
        Template template = this.getTemplate();
        String str = template.getLabelTemplate();
        if (str != null) {
            Map<String, RDFNode> args = this.getArgumentsMapByVarNames();
            StringBuffer buffer = new StringBuffer();
            SPINLabels.appendTemplateCallLabel(buffer, str, args);
            p.print(buffer.toString());
        } else if (template.getComment() != null) {
            p.print(template.getComment());
        } else {
            p.print("<No spin:" + SPIN.labelTemplate.getLocalName() + " set for " + template.getURI() + ">");
        }
    }
}

