/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphCollection;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.graph.GraphUnionRead;

public class DatasetGraphMapLink
extends DatasetGraphCollection {
    private final DatasetGraphFactory.GraphMaker graphMaker;
    private final Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;
    private final Transactional txn = TransactionalLock.createMRSW();

    public static DatasetGraph cloneStructure(DatasetGraph dsg) {
        return new DatasetGraphMapLink(dsg);
    }

    public static DatasetGraph cloneStructure(DatasetGraph dsg, DatasetGraphFactory.GraphMaker graphMaker) {
        return new DatasetGraphMapLink(dsg, graphMaker);
    }

    private DatasetGraphMapLink(DatasetGraph dsg, DatasetGraphFactory.GraphMaker graphMaker) {
        this.graphMaker = graphMaker;
        this.defaultGraph = dsg.getDefaultGraph();
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            this.addGraph(gn, dsg.getGraph(gn));
        }
    }

    private DatasetGraphMapLink(DatasetGraph dsg) {
        this(dsg, DatasetGraphFactory.graphMakerMem);
    }

    private DatasetGraphMapLink(Graph dftGraph, DatasetGraphFactory.GraphMaker graphMaker) {
        this.graphMaker = graphMaker;
        this.defaultGraph = dftGraph;
    }

    DatasetGraphMapLink(DatasetGraphFactory.GraphMaker graphMaker) {
        this(graphMaker.create(), graphMaker);
    }

    public DatasetGraphMapLink(Graph dftGraph) {
        this.defaultGraph = dftGraph;
        this.graphMaker = DatasetGraphFactory.graphMakerMem;
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public void commit() {
        SystemARQ.sync(this);
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.graphs.containsKey(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (Quad.isUnionGraph(graphNode)) {
            return new GraphUnionRead(this);
        }
        if (Quad.isDefaultGraph(graphNode)) {
            return this.getDefaultGraph();
        }
        Graph g = this.graphs.get(graphNode);
        if (g == null && (g = this.getGraphCreate()) != null) {
            this.graphs.put(graphNode, g);
        }
        return g;
    }

    protected Graph getGraphCreate() {
        return this.graphMaker.create();
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.graphs.put(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.graphs.remove(graphName);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    public long size() {
        return this.graphs.size();
    }

    @Override
    public void close() {
        this.defaultGraph.close();
        for (Graph graph : this.graphs.values()) {
            graph.close();
        }
        super.close();
    }
}

