/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2;

public abstract class QueryIter2LoopOnLeft
extends QueryIter2 {
    Table tableRight = TableFactory.create(this.getRight());
    Binding slot = null;

    public QueryIter2LoopOnLeft(QueryIterator left, QueryIterator right, ExecutionContext qCxt) {
        super(left, right, qCxt);
        this.getRight().close();
    }

    @Override
    protected final void closeSubIterator() {
        this.tableRight.close();
    }

    @Override
    protected void requestSubCancel() {
    }

    @Override
    protected final boolean hasNextBinding() {
        if (this.slot != null) {
            return true;
        }
        while (this.getLeft().hasNext()) {
            Binding bindingLeft = this.getLeft().nextBinding();
            this.slot = this.getNextSlot(bindingLeft);
            if (this.slot == null) continue;
            this.slot = bindingLeft;
            return true;
        }
        this.getLeft().close();
        return false;
    }

    protected abstract Binding getNextSlot(Binding var1);

    @Override
    protected final Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            return null;
        }
        Binding x = this.slot;
        this.slot = null;
        return x;
    }
}

