/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging.java;

import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class TextFormatter
extends Formatter {
    private static final String dftformat = "%5$tT %3$-5s %2$-20s :: %6$s\n";
    private String format = "%5$tT %3$-5s %2$-20s :: %6$s\n";

    public TextFormatter() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String fmt = manager.getProperty(cname + ".format");
        if (fmt != null) {
            if (!fmt.endsWith("\n")) {
                fmt = fmt + "\n";
            }
            this.format = fmt;
        }
    }

    public TextFormatter(String fmt) {
        if (!fmt.endsWith("\n")) {
            fmt = fmt + "\n";
        }
        this.format = fmt;
    }

    @Override
    public String format(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "root";
        }
        int i = loggerName.lastIndexOf(46);
        String loggerNameShort = loggerName.substring(i + 1);
        String formatted$ = record.getMessage();
        if (record.getParameters() != null) {
            formatted$ = MessageFormat.format(formatted$, record.getParameters());
        }
        Level level = record.getLevel();
        String levelOutputName = this.levelOutputName(level);
        return String.format(this.format, loggerName, loggerNameShort, levelOutputName, Thread.currentThread().getName(), new Date(record.getMillis()), formatted$);
    }

    protected String levelOutputName(Level level) {
        if (Level.WARNING.equals(level)) {
            return "WARN";
        }
        if (Level.SEVERE.equals(level)) {
            return "ERROR";
        }
        if (Level.INFO.equals(level)) {
            return "INFO";
        }
        if (Level.CONFIG.equals(level)) {
            return "CONF";
        }
        if (Level.FINE.equals(level)) {
            return "DEBUG";
        }
        if (Level.FINER.equals(level)) {
            return "DEBUG";
        }
        if (Level.FINEST.equals(level)) {
            return "TRACE";
        }
        return level.getName();
    }
}

