/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.system;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaUtil;

public abstract class SPINArgumentChecker {
    private static SPINArgumentChecker singleton;

    public static SPINArgumentChecker get() {
        return singleton;
    }

    public static void set(SPINArgumentChecker value) {
        singleton = value;
    }

    public void check(Module module, QuerySolutionMap bindings) {
        LinkedList<String> errors = new LinkedList<String>();
        for (Argument arg : module.getArguments(false)) {
            Resource valueType;
            String varName = arg.getVarName();
            RDFNode value = bindings.get(varName);
            if (!arg.isOptional() && value == null) {
                errors.add("Missing required argument " + varName);
                continue;
            }
            if (value == null || (valueType = arg.getValueType()) == null) continue;
            if (value.isResource()) {
                if (RDFS.Resource.equals((Object)valueType) || JenaUtil.hasIndirectType((Resource)value, valueType.inModel(value.getModel()))) continue;
                StringBuffer sb = new StringBuffer("Resource ");
                sb.append(SPINLabels.get().getLabel((Resource)value));
                sb.append(" for argument ");
                sb.append(varName);
                sb.append(" must have type ");
                sb.append(SPINLabels.get().getLabel(valueType));
                errors.add(sb.toString());
                continue;
            }
            if (RDFS.Literal.equals((Object)valueType)) continue;
            String datatypeURI = value.asLiteral().getDatatypeURI();
            if (value.asLiteral().getLanguage().length() > 0) {
                datatypeURI = XSD.xstring.getURI();
            }
            if (valueType.getURI().equals(datatypeURI)) continue;
            StringBuffer sb = new StringBuffer("Literal ");
            sb.append(value.asLiteral().getLexicalForm());
            sb.append(" for argument ");
            sb.append(varName);
            sb.append(" must have datatype ");
            sb.append(SPINLabels.get().getLabel(valueType));
            errors.add(sb.toString());
        }
        if (!errors.isEmpty()) {
            this.handleErrors(module, bindings, errors);
        }
    }

    protected abstract void handleErrors(Module var1, QuerySolutionMap var2, List<String> var3);
}

