/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.ref;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformPropertyFunction;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineBase;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCheck;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.ref.Eval;
import org.apache.jena.sparql.engine.ref.Evaluator;
import org.apache.jena.sparql.engine.ref.EvaluatorFactory;
import org.apache.jena.sparql.util.Context;

public class QueryEngineRef
extends QueryEngineBase {
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        @Override
        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Query query, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRef engine = new QueryEngineRef(query, dataset, binding, context);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRef engine = new QueryEngineRef(op, dataset, binding, context);
            return engine.getPlan();
        }
    };

    public QueryEngineRef(Op op, DatasetGraph dataset, Context context) {
        this(op, dataset, BindingFactory.root(), context);
    }

    public QueryEngineRef(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    protected QueryEngineRef(Query query, DatasetGraph dataset, Binding input, Context context) {
        super(query, dataset, input, context);
    }

    @Override
    protected Op modifyOp(Op op) {
        TransformPropertyFunction t = new TransformPropertyFunction(this.context);
        op = Transformer.transform(t, op);
        return op;
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding binding, Context context) {
        if (binding.vars().hasNext()) {
            op = Substitute.substitute(op, binding);
        }
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory(context));
        Evaluator eval2 = EvaluatorFactory.create(execCxt);
        Table table = Eval.eval(eval2, op);
        QueryIterator qIter = table.iterator(execCxt);
        return QueryIteratorCheck.check(qIter, execCxt);
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }
}

