/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueDT
extends NodeValue {
    private final XMLGregorianCalendar datetime;

    public NodeValueDT(String lex, Node n) {
        super(n);
        if (XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype()) && lex.endsWith("Z")) {
            lex = lex.substring(0, lex.length() - 1);
            this.datetime = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex);
            this.datetime.setTimezone(0);
            return;
        }
        this.datetime = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex);
    }

    @Override
    public boolean isDateTime() {
        return XSDDatatype.XSDdateTime.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isDate() {
        return XSDDatatype.XSDdate.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isTime() {
        return XSDDatatype.XSDtime.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYear() {
        return XSDDatatype.XSDgYear.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYearMonth() {
        return XSDDatatype.XSDgYearMonth.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonth() {
        return XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonthDay() {
        return XSDDatatype.XSDgMonthDay.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGDay() {
        return XSDDatatype.XSDgDay.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public XMLGregorianCalendar getDateTime() {
        return (XMLGregorianCalendar)this.datetime.clone();
    }

    @Override
    protected Node makeNode() {
        return null;
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

