/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.ModulesUtil;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class ModuleImpl
extends AbstractSPINResourceImpl
implements Module {
    public ModuleImpl(Node node, EnhGraph eg) {
        super(node, eg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Argument> getArguments(boolean ordered) {
        ArrayList<Argument> results = new ArrayList<Argument>();
        StmtIterator it = null;
        JenaUtil.setGraphReadOptimization(true);
        try {
            Set<Resource> classes = JenaUtil.getAllSuperClasses(this);
            classes.add(this);
            for (Resource cls : classes) {
                it = cls.listProperties(SPIN.constraint);
                while (it.hasNext()) {
                    Statement s = it.nextStatement();
                    this.addArgumentFromConstraint(s, results);
                }
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
            JenaUtil.setGraphReadOptimization(false);
        }
        if (ordered) {
            Collections.sort(results, new Comparator<Argument>(){

                @Override
                public int compare(Argument o1, Argument o2) {
                    Property p1 = o1.getPredicate();
                    Property p2 = o2.getPredicate();
                    if (p1 != null && p2 != null) {
                        return p1.getLocalName().compareTo(p2.getLocalName());
                    }
                    return 0;
                }
            });
        }
        return results;
    }

    private void addArgumentFromConstraint(Statement constaint, List<Argument> results) {
        if (constaint.getObject().isAnon()) {
            StmtIterator types = constaint.getResource().listProperties(RDF.type);
            while (types.hasNext()) {
                Statement typeS = (Statement)types.next();
                if (!typeS.getObject().isURIResource()) continue;
                if (SPL.Argument.equals((Object)typeS.getObject())) {
                    results.add((Argument)constaint.getResource().as(Argument.class));
                    continue;
                }
                if (SPL.Attribute.equals((Object)typeS.getObject()) || !JenaUtil.hasSuperClass(typeS.getResource(), SPL.Argument.inModel(typeS.getModel()))) continue;
                results.add((Argument)constaint.getResource().as(Argument.class));
            }
        } else if (constaint.getObject().isURIResource() && JenaUtil.hasIndirectType(constaint.getResource(), SPL.Argument.inModel(constaint.getModel()))) {
            results.add((Argument)constaint.getResource().as(Argument.class));
        }
    }

    @Override
    public Map<String, Argument> getArgumentsMap() {
        HashMap<String, Argument> results = new HashMap<String, Argument>();
        for (Argument argument : this.getArguments(false)) {
            Property property = argument.getPredicate();
            if (property == null) continue;
            results.put(property.getLocalName(), argument);
        }
        return results;
    }

    @Override
    public Command getBody() {
        RDFNode node = ModulesUtil.getBody(this);
        if (node instanceof Resource) {
            return SPINFactory.asCommand((Resource)node);
        }
        return null;
    }

    @Override
    public String getComment() {
        return this.getString(RDFS.comment);
    }

    @Override
    public boolean isAbstract() {
        return SPINFactory.isAbstract(this);
    }

    @Override
    public void print(PrintContext p) {
    }
}

