/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.CommonConfig;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.CharBasedPNameTable;
import com.fasterxml.aalto.in.InputCharTypes;
import com.fasterxml.aalto.util.BufferRecycler;
import com.fasterxml.aalto.util.IllegalCharHandler;
import com.fasterxml.aalto.util.UriCanonicalizer;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;

public final class ReaderConfig
extends CommonConfig {
    public static final int DEFAULT_SMALL_BUFFER_LEN = 60;
    public static final int DEFAULT_CHAR_BUFFER_LEN = 4000;
    public static final int STANDALONE_UNKNOWN = 0;
    public static final int STANDALONE_YES = 1;
    public static final int STANDALONE_NO = 2;
    static final int F_NS_AWARE = 1;
    static final int F_COALESCING = 2;
    static final int F_DTD_AWARE = 4;
    static final int F_DTD_VALIDATING = 8;
    static final int F_EXPAND_ENTITIES = 16;
    static final int F_LAZY_PARSING = 256;
    static final int F_INTERN_NAMES = 512;
    static final int F_INTERN_NS_URIS = 1024;
    static final int F_REPORT_CDATA = 2048;
    static final int F_PRESERVE_LOCATION = 4096;
    static final int F_AUTO_CLOSE_INPUT = 8192;
    static final int DEFAULT_FLAGS = 7957;
    private static final HashMap<String, Object> sProperties = new HashMap();
    private final EncodingContext mEncCtxt;
    private final UriCanonicalizer mCanonicalizer;
    private final String mPublicId;
    private final String mSystemId;
    private final String mExtEncoding;
    private String mActualEncoding = null;
    private String mXmlDeclVersion = null;
    private String mXmlDeclEncoding = null;
    private int mXmlDeclStandalone = 0;
    private XMLReporter mReporter;
    private XMLResolver mResolver;
    private IllegalCharHandler illegalCharHandler;
    static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef;
    protected BufferRecycler _currRecycler = null;

    private ReaderConfig(String publicId, String systemId, String extEnc, EncodingContext encCtxt, int flags, int flagMods, XMLReporter rep, XMLResolver res, UriCanonicalizer canonicalizer) {
        super(flags, flagMods);
        this.mPublicId = publicId;
        this.mSystemId = systemId;
        this.mExtEncoding = extEnc;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        if (ref != null) {
            this._currRecycler = ref.get();
        }
        this.mEncCtxt = encCtxt;
        this._flags = flags;
        this._flagMods = flagMods;
        this.mReporter = rep;
        this.mResolver = res;
        this.mCanonicalizer = canonicalizer;
    }

    public ReaderConfig() {
        this(null, null, null, new EncodingContext(), 7957, 0, null, null, new UriCanonicalizer());
    }

    public void setActualEncoding(String actualEnc) {
        this.mActualEncoding = actualEnc;
    }

    public void setXmlDeclInfo(int version, String xmlDeclEnc, String standalone) {
        this.mXmlDeclVersion = version == 256 ? "1.0" : (version == 272 ? "1.1" : null);
        this.mXmlDeclEncoding = xmlDeclEnc;
        this.mXmlDeclStandalone = standalone == "yes" ? 1 : (standalone == "no" ? 2 : 0);
    }

    public final void setXmlVersion(String version) {
        this.mXmlDeclVersion = version;
    }

    public final void setXmlEncoding(String enc) {
        this.mXmlDeclEncoding = enc;
    }

    public final void setXmlStandalone(Boolean b) {
        this.mXmlDeclStandalone = b == null ? 0 : (b != false ? 1 : 2);
    }

    public void setXMLReporter(XMLReporter r) {
        this.mReporter = r;
    }

    public void setXMLResolver(XMLResolver r) {
        this.mResolver = r;
    }

    public void doCoalesceText(boolean state) {
        this.setFlag(2, state);
    }

    public void doAutoCloseInput(boolean state) {
        this.setFlag(8192, state);
    }

    public void doPreserveLocation(boolean state) {
        this.setFlag(4096, state);
    }

    public void doParseLazily(boolean state) {
        this.setFlag(256, state);
    }

    public void doReportCData(boolean state) {
        this.setFlag(2048, state);
    }

    public ReaderConfig createNonShared(String publicId, String systemId, String extEnc) {
        return new ReaderConfig(publicId, systemId, extEnc, this.mEncCtxt, this._flags, this._flagMods, this.mReporter, this.mResolver, this.mCanonicalizer);
    }

    @Override
    public String getExternalEncoding() {
        return this.mExtEncoding;
    }

    @Override
    public String getActualEncoding() {
        return this.mActualEncoding;
    }

    @Override
    public boolean isXml11() {
        return false;
    }

    protected int findPropertyId(String propName) {
        Integer I = (Integer)sProperties.get(propName);
        return I == null ? -1 : I;
    }

    @Override
    public final Object getProperty(String name, boolean isMandatory) {
        Object ob = sProperties.get(name);
        if (ob == null) {
            if (sProperties.containsKey(name)) {
                return null;
            }
            return super.getProperty(name, isMandatory);
        }
        if (ob instanceof Boolean) {
            return (boolean)((Boolean)ob);
        }
        if (!(ob instanceof Integer)) {
            throw new RuntimeException("Internal error: unrecognized property value type: " + ob.getClass().getName());
        }
        int f = (Integer)ob;
        return this.hasFlag(f);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        Object ob = sProperties.get(name);
        if (ob == null) {
            if (sProperties.containsKey(name)) {
                return false;
            }
            return super.setProperty(name, value);
        }
        if (ob instanceof Boolean) {
            return false;
        }
        if (!(ob instanceof Integer)) {
            throw new RuntimeException("Internal error");
        }
        int f = (Integer)ob;
        boolean state = (Boolean)value;
        this.setFlag(f, state);
        return true;
    }

    @Override
    public boolean isPropertySupported(String propName) {
        return sProperties.containsKey(propName) || super.isPropertySupported(propName);
    }

    public XMLReporter getXMLReporter() {
        return this.mReporter;
    }

    public XMLResolver getXMLResolver() {
        return this.mResolver;
    }

    public boolean willExpandEntities() {
        return this.hasFlag(16);
    }

    public boolean willCoalesceText() {
        return this.hasFlag(2);
    }

    public boolean willSupportNamespaces() {
        return true;
    }

    public boolean willParseLazily() {
        return this.hasFlag(256);
    }

    public boolean willInternNames() {
        return this.hasFlag(512);
    }

    public boolean willInternNsURIs() {
        return this.hasFlag(1024);
    }

    public boolean willReportCData() {
        return this.hasFlag(2048);
    }

    public boolean willPreserveLocation() {
        return this.hasFlag(4096);
    }

    public boolean willAutoCloseInput() {
        return this.hasFlag(8192);
    }

    public boolean hasInternNamesBeenEnabled() {
        return this.hasExplicitFlag(512);
    }

    public boolean hasInternNsURIsBeenEnabled() {
        return this.hasExplicitFlag(1024);
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getXmlDeclVersion() {
        return this.mXmlDeclVersion;
    }

    public String getXmlDeclEncoding() {
        return this.mXmlDeclEncoding;
    }

    public int getXmlDeclStandalone() {
        return this.mXmlDeclStandalone;
    }

    public void configureForXmlConformance() {
    }

    public void configureForConvenience() {
        this.doCoalesceText(true);
        this.doPreserveLocation(true);
    }

    public void configureForSpeed() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
    }

    public void configureForLowMemUsage() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
    }

    public void configureForRoundTripping() {
        this.doCoalesceText(false);
    }

    public String canonicalizeURI(char[] buf, int uriLen) {
        return this.mCanonicalizer.canonicalizeURI(buf, uriLen);
    }

    public char[] allocSmallCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getSmallCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeSmallCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnSmallCBuffer(buffer);
    }

    public char[] allocMediumCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getMediumCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeMediumCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnMediumCBuffer(buffer);
    }

    public char[] allocFullCBuffer(int minSize) {
        char[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getFullCBuffer(minSize)) != null) {
            return result;
        }
        return new char[minSize];
    }

    public void freeFullCBuffer(char[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullCBuffer(buffer);
    }

    public byte[] allocFullBBuffer(int minSize) {
        byte[] result;
        if (this._currRecycler != null && (result = this._currRecycler.getFullBBuffer(minSize)) != null) {
            return result;
        }
        return new byte[minSize];
    }

    public void freeFullBBuffer(byte[] buffer) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullBBuffer(buffer);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler recycler = new BufferRecycler();
        _recyclerRef.set(new SoftReference<BufferRecycler>(recycler));
        return recycler;
    }

    public ByteBasedPNameTable getBBSymbols() {
        if (this.mActualEncoding == "UTF-8") {
            return this.mEncCtxt.getUtf8Symbols();
        }
        if (this.mActualEncoding == "ISO-8859-1") {
            return this.mEncCtxt.getLatin1Symbols();
        }
        if (this.mActualEncoding == "US-ASCII") {
            return this.mEncCtxt.getAsciiSymbols();
        }
        throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
    }

    public CharBasedPNameTable getCBSymbols() {
        return this.mEncCtxt.getSymbols();
    }

    public void updateBBSymbols(ByteBasedPNameTable sym) {
        if (this.mActualEncoding == "UTF-8") {
            this.mEncCtxt.updateUtf8Symbols(sym);
        } else if (this.mActualEncoding == "ISO-8859-1") {
            this.mEncCtxt.updateLatin1Symbols(sym);
        } else if (this.mActualEncoding == "US-ASCII") {
            this.mEncCtxt.updateAsciiSymbols(sym);
        } else {
            throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
        }
    }

    public void updateCBSymbols(CharBasedPNameTable sym) {
        this.mEncCtxt.updateSymbols(sym);
    }

    public XmlCharTypes getCharTypes() {
        if (this.mActualEncoding == "UTF-8") {
            return InputCharTypes.getUtf8CharTypes();
        }
        if (this.mActualEncoding == "ISO-8859-1") {
            return InputCharTypes.getLatin1CharTypes();
        }
        if (this.mActualEncoding == "US-ASCII") {
            return InputCharTypes.getAsciiCharTypes();
        }
        throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
    }

    public void setIllegalCharHandler(IllegalCharHandler illegalCharHandler) {
        this.illegalCharHandler = illegalCharHandler;
    }

    public IllegalCharHandler getIllegalCharHandler() {
        return this.illegalCharHandler;
    }

    static {
        sProperties.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        sProperties.put("javax.xml.stream.isValidating", new Integer(8));
        sProperties.put("javax.xml.stream.isCoalescing", 2);
        sProperties.put("javax.xml.stream.isReplacingEntityReferences", 16);
        sProperties.put("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        sProperties.put("javax.xml.stream.supportDTD", 4);
        sProperties.put("javax.xml.stream.reporter", null);
        sProperties.put("javax.xml.stream.resolver", null);
        sProperties.put("javax.xml.stream.allocator", null);
        sProperties.put("com.ctc.wstx.lazyParsing", 256);
        sProperties.put("org.codehaus.stax2.internNames", 512);
        sProperties.put("org.codehaus.stax2.internNsUris", 1024);
        sProperties.put("org.codehaus.stax2.closeInputSource", 8192);
        sProperties.put("org.codehaus.stax2.preserveLocation", 4096);
        sProperties.put("org.codehaus.stax2.reportPrologWhitespace", Boolean.FALSE);
        sProperties.put("http://java.sun.com/xml/stream/properties/report-cdata-event", 2048);
        sProperties.put("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
        sProperties.put("org.codehaus.stax2.propDtdOverride", null);
        _recyclerRef = new ThreadLocal();
    }

    static final class EncodingContext {
        ByteBasedPNameTable mUtf8Table;
        ByteBasedPNameTable mLatin1Table;
        ByteBasedPNameTable mAsciiTable;
        CharBasedPNameTable mGeneralTable;

        EncodingContext() {
        }

        public synchronized ByteBasedPNameTable getUtf8Symbols() {
            if (this.mUtf8Table == null) {
                this.mUtf8Table = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mUtf8Table);
        }

        public synchronized void updateUtf8Symbols(ByteBasedPNameTable sym) {
            this.mUtf8Table.mergeFromChild(sym);
        }

        public synchronized ByteBasedPNameTable getLatin1Symbols() {
            if (this.mLatin1Table == null) {
                this.mLatin1Table = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mLatin1Table);
        }

        public synchronized void updateLatin1Symbols(ByteBasedPNameTable sym) {
            this.mLatin1Table.mergeFromChild(sym);
        }

        public synchronized ByteBasedPNameTable getAsciiSymbols() {
            if (this.mAsciiTable == null) {
                this.mAsciiTable = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mAsciiTable);
        }

        public synchronized void updateAsciiSymbols(ByteBasedPNameTable sym) {
            this.mAsciiTable.mergeFromChild(sym);
        }

        public synchronized CharBasedPNameTable getSymbols() {
            if (this.mGeneralTable == null) {
                this.mGeneralTable = new CharBasedPNameTable(64);
            }
            return new CharBasedPNameTable(this.mGeneralTable);
        }

        public synchronized void updateSymbols(CharBasedPNameTable sym) {
            this.mGeneralTable.mergeFromChild(sym);
        }
    }
}

