/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.entailment;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.rules.RulesEntailment;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.progress.ProgressMonitor;

public class SHACLEntailment {
    public static final Resource RDFS = ResourceFactory.createResource((String)"http://www.w3.org/ns/entailment/RDFS");
    private static SHACLEntailment singleton = new SHACLEntailment();
    private Map<String, Engine> engines = new HashMap<String, Engine>();

    public static SHACLEntailment get() {
        return singleton;
    }

    protected SHACLEntailment() {
        this.setEngine(RDFS.getURI(), new Engine(){

            @Override
            public Model createModelWithEntailment(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, ProgressMonitor monitor) {
                return ModelFactory.createRDFSModel((Model)dataset.getDefaultModel());
            }
        });
        this.setEngine(SH.Rules.getURI(), new RulesEntailment());
    }

    public Engine getEngine(String uri) {
        return this.engines.get(uri);
    }

    public void setEngine(String uri, Engine engine) {
        this.engines.put(uri, engine);
    }

    public Dataset withEntailment(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, Resource entailment, ProgressMonitor monitor) throws InterruptedException {
        if (entailment == null || dataset.getDefaultModel() == null) {
            return dataset;
        }
        Engine engine = this.getEngine(entailment.getURI());
        if (engine != null) {
            Model newDefaultModel = engine.createModelWithEntailment(dataset, shapesGraphURI, shapesGraph, monitor);
            return new DatasetWithDifferentDefaultModel(newDefaultModel, dataset);
        }
        return null;
    }

    public static interface Engine {
        public Model createModelWithEntailment(Dataset var1, URI var2, ShapesGraph var3, ProgressMonitor var4) throws InterruptedException;
    }
}

