/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.net.URI;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.arq.SHACLFunctions;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.filters.ExcludeMetaShapesFilter;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.vocabulary.TOSH;
import org.topbraid.spin.arq.ARQFactory;

public class ValidationUtil {
    public static Resource validateModel(Model dataModel, Model shapesModel, boolean validateShapes) {
        if (!shapesModel.contains(TOSH.hasShape, RDF.type, (RDFNode)null)) {
            Model unionModel = SHACLSystemModel.getSHACLModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{unionModel.getGraph(), shapesModel.getGraph()});
            shapesModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        }
        SHACLFunctions.registerFunctions(shapesModel);
        URI shapesGraphURI = URI.create("urn:x-shacl-shapes-graph:" + UUID.randomUUID().toString());
        Dataset dataset = ARQFactory.get().getDataset(dataModel);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        ShapesGraph shapesGraph = new ShapesGraph(shapesModel);
        if (!validateShapes) {
            shapesGraph.setShapeFilter(new ExcludeMetaShapesFilter());
        }
        ValidationEngine engine = ValidationEngineFactory.get().create(dataset, shapesGraphURI, shapesGraph, null);
        try {
            engine.applyEntailments();
            return engine.validateAll();
        }
        catch (InterruptedException ex) {
            return null;
        }
    }
}

