/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.inference.SPINRuleComparator;
import org.topbraid.spin.util.CommandWrapper;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class DefaultSPINRuleComparator
implements SPINRuleComparator {
    private List<Resource> properties;

    public DefaultSPINRuleComparator(Model model) {
        Property spinRule = model.getProperty(SPIN.rule.getURI());
        this.properties = new ArrayList<Resource>(JenaUtil.getAllSubProperties(spinRule));
        this.properties.add((Resource)spinRule);
        boolean again = true;
        while (again) {
            again = false;
            for (int j = 0; j < this.properties.size(); ++j) {
                for (int i = j + 1; i < this.properties.size(); ++i) {
                    Resource oj;
                    Resource oi = this.properties.get(i);
                    if (!oi.hasProperty(SPIN.nextRuleProperty, (RDFNode)(oj = this.properties.get(j)))) continue;
                    this.properties.set(i, oj);
                    this.properties.set(j, oi);
                    again = true;
                }
            }
        }
    }

    @Override
    public int compare(CommandWrapper w1, CommandWrapper w2) {
        if (this.properties.size() > 1) {
            Property p2;
            Property p1 = w1.getStatement() != null ? w1.getStatement().getPredicate() : SPIN.rule;
            Property property = p2 = w2.getStatement() != null ? w2.getStatement().getPredicate() : SPIN.rule;
            if (!p1.equals(p2)) {
                int index1 = this.properties.indexOf(p1);
                int index2 = this.properties.indexOf(p2);
                int compare = Integer.valueOf(index1).compareTo(index2);
                if (compare != 0) {
                    return compare;
                }
            }
        }
        return w1.getText().compareTo(w2.getText());
    }
}

