/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.impl.ModuleCallImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;

public class FunctionCallImpl
extends ModuleCallImpl
implements FunctionCall {
    private static final String SP_ARG = SP.arg.getURI();

    public FunctionCallImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public List<RDFNode> getArguments() {
        Map<Property, RDFNode> values = this.getArgumentsMap();
        Property[] ps = this.getArgumentProperties(values);
        ArrayList<RDFNode> results = new ArrayList<RDFNode>(ps.length);
        for (Property key : ps) {
            RDFNode node = values.get(key);
            results.add(SPINFactory.asExpression(node));
        }
        return results;
    }

    private Property[] getArgumentProperties(Map<Property, RDFNode> values) {
        Property[] ps = new Property[values.size()];
        LinkedList<Property> others = new LinkedList<Property>();
        for (Property p : values.keySet()) {
            if (p.getURI().startsWith(SP_ARG) && !p.equals(SP.arg)) {
                int index = Integer.valueOf(p.getURI().substring(SP_ARG.length()));
                ps[index - 1] = p;
                continue;
            }
            others.add(p);
        }
        if (!others.isEmpty()) {
            Collections.sort(others, new Comparator<Property>(){

                @Override
                public int compare(Property arg0, Property arg1) {
                    return arg0.getLocalName().compareTo(arg1.getLocalName());
                }
            });
            Iterator it = others.iterator();
            for (int i = 0; i < ps.length; ++i) {
                if (ps[i] != null) continue;
                ps[i] = (Property)it.next();
            }
        }
        return ps;
    }

    @Override
    public Map<Property, RDFNode> getArgumentsMap() {
        HashMap<Property, RDFNode> values = new HashMap<Property, RDFNode>();
        StmtIterator it = this.listProperties();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (RDF.type.equals(s.getPredicate())) continue;
            values.put(s.getPredicate(), s.getObject());
        }
        return values;
    }

    @Override
    public Resource getFunction() {
        Resource type = null;
        StmtIterator it = this.listProperties(RDF.type);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isURIResource()) continue;
            Resource candidate = s.getResource();
            if (type == null) {
                type = candidate;
                continue;
            }
            if (this.getModel().contains(null, RDFS.subClassOf, (RDFNode)candidate)) continue;
            type = candidate;
        }
        if (type != null) {
            if (JenaUtil.hasIndirectType(type, SPIN.Function.inModel(type.getModel()))) {
                return type;
            }
            Function global = SPINModuleRegistry.get().getFunction(type.getURI(), null);
            if (global != null) {
                return global;
            }
            return type;
        }
        return null;
    }

    @Override
    public Module getModule() {
        Resource function = this.getFunction();
        if (function != null) {
            return (Module)function.as(Function.class);
        }
        return null;
    }

    private String getSymbol(Resource function) {
        Statement s;
        if (function != null && (s = function.getProperty(SPIN.symbol)) != null && s.getObject().isLiteral()) {
            return s.getString();
        }
        return null;
    }

    public static boolean isSetOperator(String symbol) {
        return "IN".equals(symbol) || "NOT IN".equals(symbol);
    }

    @Override
    public void print(PrintContext p) {
        Resource function = this.getFunction();
        List<RDFNode> args = this.getArguments();
        String symbol = this.getSymbol(function);
        if (symbol != null && (!Character.isLetter(symbol.charAt(0)) || FunctionCallImpl.isSetOperator(symbol))) {
            this.printOperator(p, symbol, args);
        } else if (symbol != null && (SP.exists.equals((Object)function) || SP.notExists.equals((Object)function))) {
            this.printExistsOrNotExists(p, symbol);
        } else {
            this.printFunction(p, function, args);
        }
    }

    void printOperator(PrintContext p, String operator, List<RDFNode> args) {
        if (p.isNested()) {
            p.print("(");
        }
        boolean set = FunctionCallImpl.isSetOperator(operator);
        if (args.size() == 1 && !set) {
            p.print(operator);
            this.printNestedExpressionString(p, args.get(0));
        } else {
            this.printNestedExpressionString(p, args.get(0));
            p.print(" ");
            p.print(operator);
            p.print(" ");
            if (set) {
                p.print("(");
                for (int i = 1; i < args.size(); ++i) {
                    if (i > 1) {
                        p.print(", ");
                    }
                    RDFNode arg = args.get(i);
                    this.printNestedExpressionString(p, arg);
                }
                p.print(")");
            } else {
                this.printNestedExpressionString(p, args.get(1));
            }
        }
        if (p.isNested()) {
            p.print(")");
        }
    }

    void printExistsOrNotExists(PrintContext p, String symbol) {
        p.print(symbol);
        this.printNestedElementList(p, SP.elements);
    }

    void printFunction(PrintContext p, Resource function, List<RDFNode> args) {
        this.printFunctionQName(p, function);
        p.print("(");
        Iterator<RDFNode> it = args.iterator();
        while (it.hasNext()) {
            RDFNode param = it.next();
            this.printNestedExpressionString(p, param);
            if (!it.hasNext()) continue;
            p.print(", ");
        }
        p.print(")");
    }

    private void printFunctionQName(PrintContext p, Resource function) {
        String symbol = this.getSymbol(function);
        if (symbol != null) {
            p.print(symbol);
        } else {
            String uri = function.getURI();
            p.printURIResource(this.getModel().getResource(uri));
        }
    }
}

