/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class ModulesUtil {
    public static RDFNode getBody(Resource module) {
        Statement s = module.getProperty(SPIN.body);
        if (s == null) {
            return ModulesUtil.getSuperClassesBody(module, new HashSet<Resource>());
        }
        return s.getObject();
    }

    public static Map<Property, RDFNode> getPotentialBindings(Module module, RDFNode[] values) {
        HashMap<Property, RDFNode> results = new HashMap<Property, RDFNode>();
        for (Argument argument : module.getArguments(false)) {
            Resource argType;
            Property argProperty = argument.getPredicate();
            if (argProperty == null || (argType = argument.getValueType()) == null) continue;
            for (RDFNode value : values) {
                if (value instanceof Resource) {
                    Resource resource = (Resource)value;
                    if (!JenaUtil.hasIndirectType(resource, argType)) continue;
                    results.put(argProperty, (RDFNode)resource);
                    continue;
                }
                Literal literal = (Literal)value;
                if (!argType.getURI().equals(literal.getDatatypeURI())) continue;
                results.put(argProperty, (RDFNode)literal);
            }
        }
        return results;
    }

    private static RDFNode getSuperClassesBody(Resource module, Set<Resource> reached) {
        StmtIterator it = module.listProperties(RDFS.subClassOf);
        while (it.hasNext()) {
            Resource superClass;
            Statement next = it.nextStatement();
            if (!next.getObject().isResource() || reached.contains(superClass = next.getResource())) continue;
            reached.add(superClass);
            Statement s = superClass.getProperty(SPIN.body);
            if (s != null) {
                it.close();
                return s.getObject();
            }
            RDFNode body = ModulesUtil.getSuperClassesBody(module, reached);
            if (body == null) continue;
            it.close();
            return body;
        }
        return null;
    }
}

