/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.http.Params;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateProcessRemoteBase
implements UpdateProcessor {
    private static Logger log = LoggerFactory.getLogger(UpdateProcessRemoteBase.class);
    public static final Symbol HTTP_CONTEXT = Symbol.create("httpContext");
    private final UpdateRequest request;
    private final String endpoint;
    private final Context context;
    private HttpClient client;
    private Params params;
    protected List<String> defaultGraphURIs = new ArrayList<String>();
    protected List<String> namedGraphURIs = new ArrayList<String>();

    public UpdateProcessRemoteBase(UpdateRequest request, String endpoint, Context context) {
        this.request = request;
        this.endpoint = endpoint;
        this.context = Context.setupContext(context, null);
        UpdateProcessRemoteBase.applyServiceConfig(endpoint, this);
    }

    private static void applyServiceConfig(String serviceURI, UpdateProcessRemoteBase engine) {
        Map serviceContextMap = (Map)engine.context.get(Service.serviceContext);
        if (serviceContextMap != null && serviceContextMap.containsKey(serviceURI)) {
            HttpClient client;
            Context serviceContext = (Context)serviceContextMap.get(serviceURI);
            if (log.isDebugEnabled()) {
                log.debug("Endpoint URI {} has SERVICE Context: {} ", (Object)serviceURI, (Object)serviceContext);
            }
            if ((client = (HttpClient)serviceContext.get(Service.queryClient)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using context-supplied client for endpoint URI {}", (Object)serviceURI);
                }
                engine.setClient(client);
            }
        }
    }

    @Override
    public DatasetGraph getDatasetGraph() {
        return null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getQueryString() {
        return this.getParams().httpString();
    }

    public Params getParams() {
        Params ps;
        Params params = ps = this.params != null ? new Params(this.params) : new Params();
        if (this.defaultGraphURIs != null) {
            for (String defaultGraph : this.defaultGraphURIs) {
                ps.addParam("using-graph-uri", defaultGraph);
            }
        }
        if (this.namedGraphURIs != null) {
            for (String namedGraph : this.namedGraphURIs) {
                ps.addParam("using-named-graph-uri", namedGraph);
            }
        }
        return ps;
    }

    public UpdateRequest getUpdateRequest() {
        return this.request;
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String namedGraph) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(namedGraph);
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void setDefaultGraphs(List<String> defaultGraphs) {
        this.defaultGraphURIs = defaultGraphs;
    }

    public void setNamedGraphs(List<String> namedGraphs) {
        this.namedGraphURIs = namedGraphs;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.getContext().put(HTTP_CONTEXT, httpContext);
    }

    public HttpContext getHttpContext() {
        return (HttpContext)this.getContext().get(HTTP_CONTEXT);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public HttpClient getClient() {
        return this.client;
    }
}

