/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.OpEval;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.PlanOp;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.mgt.QueryEngineInfo;
import org.apache.jena.sparql.util.Context;

public abstract class QueryEngineBase
implements OpEval,
Closeable {
    public static final QueryEngineInfo queryEngineInfo = new QueryEngineInfo();
    protected DatasetGraph dataset = null;
    protected Context context;
    private Binding startBinding;
    private Query query = null;
    private Op queryOp = null;
    private Plan plan = null;

    protected QueryEngineBase(Query query, DatasetGraph dataset, Binding input, Context cxt) {
        this(dataset, input, cxt);
        this.query = query;
        query.setResultVars();
        this.setOp(this.createOp(query));
    }

    protected QueryEngineBase(Op op, DatasetGraph dataset, Binding input, Context cxt) {
        this(dataset, input, cxt);
        if (this.context == null) {
            this.context = Context.setupContext(this.context, dataset);
        }
        this.query = null;
        this.setOp(op);
    }

    private QueryEngineBase(DatasetGraph dataset, Binding input, Context context) {
        this.context = context;
        this.dataset = dataset;
        if (input == null) {
            Log.warn((Object)this, (String)"Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.createPlan();
        }
        return this.plan;
    }

    protected Plan createPlan() {
        Op op = this.queryOp;
        if (!this.startBinding.isEmpty()) {
            op = Substitute.substitute(op, this.startBinding);
            this.context.put(ARQConstants.sysCurrentAlgebra, op);
        }
        op = this.modifyOp(op);
        QueryIterator queryIterator = null;
        queryIterator = this.dataset != null ? this.evaluate(op, this.dataset, this.startBinding, this.context) : this.evaluateNoMgt(op, this.dataset, this.startBinding, this.context);
        return new PlanOp(this.getOp(), this, queryIterator);
    }

    protected Op modifyOp(Op op) {
        return op;
    }

    protected Op createOp(Query query) {
        Op op = Algebra.compile(query);
        return op;
    }

    @Override
    public final QueryIterator evaluate(Op op, DatasetGraph dsg, Binding binding, Context context) {
        if (this.query != null) {
            Explain.explain("QUERY", this.query, context);
        }
        Explain.explain("ALGEBRA", op, context);
        queryEngineInfo.incQueryCount();
        queryEngineInfo.setLastQueryExecAt();
        queryEngineInfo.setLastQueryString((Query)context.get(ARQConstants.sysCurrentQuery));
        queryEngineInfo.setLastOp(op);
        return this.eval(op, dsg, binding, context);
    }

    private QueryIterator evaluateNoMgt(Op op, DatasetGraph dsg, Binding binding, Context context) {
        return this.eval(op, dsg, binding, context);
    }

    protected abstract QueryIterator eval(Op var1, DatasetGraph var2, Binding var3, Context var4);

    public Op getOp() {
        return this.queryOp;
    }

    protected Binding getStartBinding() {
        return this.startBinding;
    }

    public void close() {
    }

    protected void setOp(Op op) {
        this.queryOp = op;
        this.context.put(ARQConstants.sysCurrentAlgebra, op);
    }
}

