/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ClosableIterator;

public abstract class AbstractGraphListener
implements GraphListener {
    public void notifyAddArray(Graph g, Triple[] triples) {
        this.notifyAddIterator(g, Arrays.asList(triples).iterator());
    }

    public void notifyAddGraph(Graph g, Graph added) {
        this.notifyAddIterator(g, (Iterator<Triple>)added.find(Triple.ANY));
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        if (it instanceof ClosableIterator) {
            this.notifyAddList(g, IteratorCollection.iteratorToList(it));
        } else {
            while (it.hasNext()) {
                Triple t = it.next();
                this.notifyAddTriple(g, t);
            }
        }
    }

    public void notifyAddList(Graph g, List<Triple> triples) {
        this.notifyAddIterator(g, triples.iterator());
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.notifyDeleteIterator(g, Arrays.asList(triples).iterator());
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.notifyDeleteIterator(g, (Iterator<Triple>)removed.find(Triple.ANY));
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        if (it instanceof ClosableIterator) {
            this.notifyDeleteList(g, IteratorCollection.iteratorToList(it));
        } else {
            while (it.hasNext()) {
                Triple triple = it.next();
                this.notifyDeleteTriple(g, triple);
            }
        }
    }

    public void notifyDeleteList(Graph g, List<Triple> list) {
        this.notifyDeleteIterator(g, list.iterator());
    }

    public void notifyEvent(Graph source, Object value) {
        if (value instanceof GraphEvents) {
            if (GraphEvents.removeAll.equals(value)) {
                this.notifyRemoveAll(source, Triple.ANY);
            } else {
                GraphEvents event = (GraphEvents)value;
                if ("remove".equals(event.getTitle())) {
                    this.notifyRemoveAll(source, (Triple)event.getContent());
                }
            }
        }
    }

    protected abstract void notifyRemoveAll(Graph var1, Triple var2);
}

