/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;
import org.apache.xerces.util.XMLChar;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQ2SPIN;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.model.update.Update;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;

public class SPTextUtil {
    public static List<Property> sparqlProperties = new LinkedList<Property>(Arrays.asList(SH.ask, SH.construct, SH.select, SH.update, SP.text));

    public static void addSPARQLProperty(Property predicate) {
        sparqlProperties.add(predicate);
    }

    public static void addSPText(Command command) {
        MultiUnion unionGraph = new MultiUnion(new Graph[]{command.getModel().getGraph(), SPIN.getModel().getGraph()});
        unionGraph.setBaseGraph(command.getModel().getGraph());
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        Command spinCommand = SPINFactory.asCommand(command.inModel(unionModel));
        StringPrintContext p = new StringPrintContext();
        p.setUsePrefixes(true);
        p.setPrintPrefixes(false);
        spinCommand.print(p);
        String str = p.getString();
        command.addProperty(SP.text, (RDFNode)command.getModel().createTypedLiteral(str));
    }

    public static void deleteSPINRDF(Model model) {
        for (Resource type : JenaUtil.getAllSubClasses(SP.Query.inModel(SP.getModel()))) {
            for (Resource instance : model.listSubjectsWithProperty(RDF.type, (RDFNode)type).toList()) {
                Command command = SPINFactory.asCommand(instance);
                for (Statement s : command.listProperties().toList()) {
                    if (RDF.type.equals(s.getPredicate()) || SP.text.equals(s.getPredicate())) continue;
                    SPTextUtil.deleteWithDependingBNodes(s);
                }
            }
        }
    }

    private static void deleteWithDependingBNodes(Statement s) {
        if (s.getSubject().isAnon()) {
            StmtIterator it = s.getModel().listStatements(null, null, (RDFNode)s.getSubject());
            if (it.hasNext()) {
                it.next();
                if (it.hasNext()) {
                    it.close();
                    return;
                }
            }
            it.close();
        }
        if (s.getObject().isAnon()) {
            for (Statement d : s.getResource().listProperties().toList()) {
                SPTextUtil.deleteWithDependingBNodes(d);
            }
        }
        s.remove();
    }

    public static void ensureSPINRDFExists(Model model) {
        for (Resource instance : model.listSubjectsWithProperty(SP.text).toList()) {
            if (SPTextUtil.hasSPINRDF(instance)) continue;
            String text = instance.getProperty(SP.text).getString();
            Model baseModel = JenaUtil.createMemoryModel();
            MultiUnion unionGraph = new MultiUnion(new Graph[]{baseModel.getGraph(), model.getGraph()});
            unionGraph.setBaseGraph(baseModel.getGraph());
            baseModel.getGraph().getPrefixMapping().setNsPrefixes((PrefixMapping)model);
            Model tempModel = ModelFactory.createModelForGraph((Graph)unionGraph);
            Command tempCommand = SPINFactory.asCommand(instance) instanceof Update ? ARQ2SPIN.parseUpdate(text, tempModel) : ARQ2SPIN.parseQuery(text, tempModel);
            tempCommand.removeAll(RDF.type);
            for (Statement s : baseModel.listStatements().toList()) {
                if (s.getSubject().equals((Object)tempCommand)) {
                    instance.addProperty(s.getPredicate(), s.getObject());
                    continue;
                }
                instance.getModel().add(s);
            }
        }
    }

    public static void ensureSPTextExists(Model model) {
        for (Resource type : JenaUtil.getAllSubClasses(SP.Query.inModel(SP.getModel()))) {
            for (Resource instance : model.listSubjectsWithProperty(RDF.type, (RDFNode)type).toList()) {
                Command command = SPINFactory.asCommand(instance);
                if (instance.hasProperty(SP.text)) continue;
                SPTextUtil.addSPText(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSPINRDF(Resource command) {
        try (StmtIterator it = command.listProperties();){
            while (it.hasNext()) {
                Statement o = (Statement)it.next();
                if (RDF.type.equals(o.getPredicate()) || SP.text.equals(o.getPredicate()) || SPIN.thisUnbound.equals(o.getPredicate())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean isQNameCharacter(char c) {
        return c != ':' && XMLChar.isName((int)c);
    }

    public static String replaceQName(String text, String qname, String newQName, String newURI) {
        if (newQName == null) {
            newQName = "<" + newURI + ">";
        }
        int index = text.lastIndexOf(qname);
        while (index >= 0) {
            if (!(index != 0 && SPTextUtil.isQNameCharacter(text.charAt(index - 1)) || index + qname.length() != text.length() && SPTextUtil.isQNameCharacter(text.charAt(index + qname.length())))) {
                text = text.substring(0, index) + newQName + text.substring(index + qname.length());
            }
            index = text.lastIndexOf(qname, index - 1);
        }
        return text;
    }

    public static boolean textContainsQName(String text, String qname) {
        int index = text.indexOf(qname);
        while (index >= 0) {
            if (!(index != 0 && SPTextUtil.isQNameCharacter(text.charAt(index - 1)) || index + qname.length() != text.length() && SPTextUtil.isQNameCharacter(text.charAt(index + qname.length())))) {
                return true;
            }
            index = text.indexOf(qname, index + 1);
        }
        return false;
    }
}

