/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.Statics;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Negative$;
import spire.algebra.Sign$Positive$;
import spire.algebra.Sign$Zero$;
import spire.math.Algebraic;
import spire.math.Algebraic$;
import spire.math.Complex;
import spire.math.Natural;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational$;
import spire.math.RationalAlgebra;
import spire.math.Real;
import spire.math.Real$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;
import spire.std.package$long$;
import spire.util.Opt$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001da!B\u0001\u0003\u0003C9!\u0001\u0003*bi&|g.\u00197\u000b\u0005\r!\u0011\u0001B7bi\"T\u0011!B\u0001\u0006gBL'/Z\u0002\u0001'\u0011\u0001\u0001b\u0004\n\u0011\u0005%iQ\"\u0001\u0006\u000b\u0005\rY!\"\u0001\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u00059Q!aC*dC2\fg*^7cKJ\u0004\"!\u0003\t\n\u0005EQ!aF*dC2\fg*^7fe&\u001c7i\u001c8wKJ\u001c\u0018n\u001c8t!\r\u00192D\b\b\u0003)eq!!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u000e\f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001H\u000f\u0003\u000f=\u0013H-\u001a:fI*\u0011!d\u0003\t\u0003?\u0001i\u0011A\u0001\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003yAQ\u0001\n\u0001\u0007\u0002\u0015\n\u0011B\\;nKJ\fGo\u001c:\u0016\u0003\u0019\u0002\"aH\u0014\n\u0005!\u0012!\u0001C*bM\u0016duN\\4\t\u000b)\u0002a\u0011A\u0013\u0002\u0017\u0011,gn\\7j]\u0006$xN\u001d\u0005\u0006Y\u00011\t!L\u0001\u0015]VlWM]1u_JL5OV1mS\u0012duN\\4\u0016\u00039\u0002\"a\f\u0019\u000e\u0003-I!!M\u0006\u0003\u000f\t{w\u000e\\3b]\")1\u0007\u0001D\t[\u00059b.^7fe\u0006$xN]!cg&\u001bh+\u00197jI2{gn\u001a\u0005\u0006k\u00011\tAN\u0001\u0010]VlWM]1u_J\f5\u000fT8oOV\tq\u0007\u0005\u00020q%\u0011\u0011h\u0003\u0002\u0005\u0019>tw\rC\u0003<\u0001\u0019\u0005Q&\u0001\feK:|W.\u001b8bi>\u0014\u0018j\u001d,bY&$Gj\u001c8h\u0011\u0015i\u0004A\"\u0005.\u0003e!WM\\8nS:\fGo\u001c:BENL5OV1mS\u0012duN\\4\t\u000b}\u0002a\u0011\u0001\u001c\u0002#\u0011,gn\\7j]\u0006$xN]!t\u0019>tw\rC\u0003B\u0001\u0019\u0005Q&A\u0006jgZ\u000bG.\u001b3M_:<\u0007\"B\"\u0001\r\u0003!\u0015aB5t/\"|G.\u001a\u000b\u0002]!)a\t\u0001C\u0001\u000f\u0006IAn\u001c8h-\u0006dW/\u001a\u000b\u0002o!)\u0011\n\u0001C\u0001\u0015\u0006A\u0011N\u001c;WC2,X\rF\u0001L!\tyC*\u0003\u0002N\u0017\t\u0019\u0011J\u001c;\t\u000b=\u0003A\u0011\u0001)\u0002\u0015\u0019dw.\u0019;WC2,X\rF\u0001R!\ty#+\u0003\u0002T\u0017\t)a\t\\8bi\")Q\u000b\u0001C!-\u0006QQO\u001c3fe2L\u0018N\\4\u0015\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t1\fgn\u001a\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016L\u0001\u0004PE*,7\r\u001e\u0005\u0006A\u0002!\t!Y\u0001\u0004C\n\u001cX#\u0001\u0010\t\u000b\r\u0004A\u0011A1\u0002\u000f%tg/\u001a:tK\")Q\r\u0001D\u0001C\u0006Q!/Z2jaJ|7-\u00197\t\u000b\u001d\u0004a\u0011\u00015\u0002\rMLwM\\;n+\u0005Y\u0005\"\u00026\u0001\r\u0003i\u0013AB5t5\u0016\u0014x\u000eC\u0003m\u0001\u0019\u0005Q&A\u0003jg>sW\rC\u0003o\u0001\u0019\u0005!%\u0001\u0007v]\u0006\u0014\u0018p\u0018\u0013nS:,8\u000fC\u0003q\u0001\u0019\u0005\u0011/A\u0003%a2,8\u000f\u0006\u0002\u001fe\")1o\u001ca\u0001=\u0005\u0019!\u000f[:\t\u000bU\u0004a\u0011\u0001<\u0002\r\u0011j\u0017N\\;t)\tqr\u000fC\u0003ti\u0002\u0007a\u0004C\u0003z\u0001\u0019\u0005!0\u0001\u0004%i&lWm\u001d\u000b\u0003=mDQa\u001d=A\u0002yAQ! \u0001\u0007\u0002y\fA\u0001\n3jmR\u0011ad \u0005\u0006gr\u0004\rA\b\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003\ra7-\u001c\u000b\u0004=\u0005\u001d\u0001BB:\u0002\u0002\u0001\u0007a\u0004C\u0004\u0002\f\u0001!\t!!\u0004\u0002\u0007\u001d\u001cG\rF\u0002\u001f\u0003\u001fAaa]A\u0005\u0001\u0004q\u0002bBA\n\u0001\u0011\u0005\u0011QC\u0001\u0007i>\u0014V-\u00197\u0016\u0005\u0005]\u0001cA\u0010\u0002\u001a%\u0019\u00111\u0004\u0002\u0003\tI+\u0017\r\u001c\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003-!x.\u00117hK\n\u0014\u0018-[2\u0016\u0005\u0005\r\u0002cA\u0010\u0002&%\u0019\u0011q\u0005\u0002\u0003\u0013\u0005cw-\u001a2sC&\u001c\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\ri>\u0014\u0015n\u001a#fG&l\u0017\r\u001c\u000b\u0007\u0003_\t)$!\u000f\u0011\u0007M\t\t$C\u0002\u00024u\u0011!BQ5h\t\u0016\u001c\u0017.\\1m\u0011\u001d\t9$!\u000bA\u0002-\u000bQa]2bY\u0016D\u0001\"a\u000f\u0002*\u0001\u0007\u0011QH\u0001\u0005[>$W\r\u0005\u0003\u0002@\u0005\rSBAA!\u0015\t\u00191,\u0003\u0003\u0002F\u0005\u0005#\u0001\u0004*pk:$\u0017N\\4N_\u0012,\u0007bBA\u0016\u0001\u0011\u0005\u0011\u0011\n\u000b\u0005\u0003_\tY\u0005\u0003\u0005\u0002N\u0005\u001d\u0003\u0019AA(\u0003\ti7\r\u0005\u0003\u0002@\u0005E\u0013\u0002BA*\u0003\u0003\u00121\"T1uQ\u000e{g\u000e^3yi\"1\u0011q\u000b\u0001\u0007\u0002\u0015\n!\u0002^8TC\u001a,Gj\u001c8h\u0011\u001d\tY\u0006\u0001C\u0003\u0003;\n\u0001\u0002^8CS\u001eLe\u000e^\u000b\u0003\u0003?\u00022aEA1\u0013\r\t\u0019'\b\u0002\u0007\u0005&<\u0017J\u001c;\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u0005Q1\u000f[8siZ\u000bG.^3\u0015\u0005\u0005-\u0004cA\u0018\u0002n%\u0019\u0011qN\u0006\u0003\u000bMCwN\u001d;\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005I!-\u001f;f-\u0006dW/\u001a\u000b\u0003\u0003o\u00022aLA=\u0013\r\tYh\u0003\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u0000\u00011\t!Y\u0001\u0006M2|wN\u001d\u0005\u0007\u0003\u0007\u0003a\u0011A1\u0002\t\r,\u0017\u000e\u001c\u0005\u0007\u0003\u000f\u0003a\u0011A1\u0002\u000bI|WO\u001c3\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\u00069!o\\;oIR{Gc\u0001\u0010\u0002\u0010\"9\u0011\u0011SAE\u0001\u00041\u0013!\u00023f]>l\u0007bBAK\u0001\u0019\u0005\u0011qS\u0001\u0004a><Hc\u0001\u0010\u0002\u001a\"9\u00111TAJ\u0001\u0004Y\u0015aA3ya\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016\u0001B:jO:,\"!a)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+\u0005\u0003\u001d\tGnZ3ce\u0006LA!!,\u0002(\n!1+[4o\u0011\u0019\t\t\f\u0001D\u0001Q\u0006a1m\\7qCJ,Gk\\(oK\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016aA7j]R\u0019a$!/\t\rM\f\u0019\f1\u0001\u001f\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000b1!\\1y)\rq\u0012\u0011\u0019\u0005\u0007g\u0006m\u0006\u0019\u0001\u0010\t\r\u0005\u0015\u0007\u0001\"\u0001b\u0003)a\u0017.\\5u)>Le\u000e\u001e\u0005\u0007\u0003\u0013\u0004A\u0011A1\u0002\u00171LW.\u001b;U_2{gn\u001a\u0005\b\u0003\u001b\u0004A\u0011AAh\u0003\u001da\u0017.\\5u)>$2AHAi\u0011\u001d\ti,a3A\u0002\u0019Bq!!6\u0001\t\u0003\t9.\u0001\nmS6LG\u000fR3o_6Lg.\u0019;peR{Gc\u0001\u0010\u0002Z\"9\u00111\\Aj\u0001\u00041\u0013!\u00027j[&$\bbBAp\u0001\u0011\u0005\u0013\u0011]\u0001\u0007KF,\u0018\r\\:\u0015\u00079\n\u0019\u000f\u0003\u0005\u0002f\u0006u\u0007\u0019AAt\u0003\u0011!\b.\u0019;\u0011\u0007=\nI/C\u0002\u0002l.\u00111!\u00118zS\u0015\u0001\u0011q\u001eBk\r\u001d\t\t0a=\u0007\u0007\u001f\u00131BQ5h%\u0006$\u0018n\u001c8bY\u001a1\u0011A\u0001E\u0001\u0003k\u001c\u0002\"a=\u0002x\u0006u(1\u0001\t\u0004_\u0005e\u0018bAA~\u0017\t1\u0011I\\=SK\u001a\u00042aHA\u0000\u0013\r\u0011\tA\u0001\u0002\u0012%\u0006$\u0018n\u001c8bY&s7\u000f^1oG\u0016\u001c\bcA\u0018\u0003\u0006%\u0019!qA\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0005\n\u0019\u0010\"\u0001\u0003\fQ\u0011!Q\u0002\t\u0004?\u0005M\bB\u0003B\t\u0003g\u0014\r\u0011\"\u0003\u0003\u0014\u0005q!+\u0019;j_:\fGn\u0015;sS:<WC\u0001B\u000b!\u0011\u00119B!\t\u000e\u0005\te!\u0002\u0002B\u000e\u0005;\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0005?Y\u0011\u0001B;uS2LAAa\t\u0003\u001a\t)!+Z4fq\"I!qEAzA\u0003%!QC\u0001\u0010%\u0006$\u0018n\u001c8bYN#(/\u001b8hA!Q!1FAz\u0005\u0004%IAa\u0005\u0002\u001b%sG/Z4feN#(/\u001b8h\u0011%\u0011y#a=!\u0002\u0013\u0011)\"\u0001\bJ]R,w-\u001a:TiJLgn\u001a\u0011\t\u0013\tM\u00121\u001fb\u0001\n\u0003\t\u0017\u0001\u0002>fe>D\u0001Ba\u000e\u0002t\u0002\u0006IAH\u0001\u0006u\u0016\u0014x\u000e\t\u0005\n\u0005w\t\u0019P1A\u0005\u0002\u0005\f1a\u001c8f\u0011!\u0011y$a=!\u0002\u0013q\u0012\u0001B8oK\u0002B\u0011Ba\u0011\u0002t\u0012\u0005!A!\u0012\u0002\u0011Q|Gi\\;cY\u0016$bAa\u0012\u0003N\tE\u0003cA\u0018\u0003J%\u0019!1J\u0006\u0003\r\u0011{WO\u00197f\u0011\u001d\u0011yE!\u0011A\u0002\u0019\n\u0011A\u001c\u0005\b\u0005'\u0012\t\u00051\u0001'\u0003\u0005!\u0007\u0002\u0003B,\u0003g$\tA!\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000by\u0011YF!\u0018\t\u0011\t=#Q\u000ba\u0001\u0003?B\u0001Ba\u0015\u0003V\u0001\u0007\u0011q\f\u0005\t\u0005/\n\u0019\u0010\"\u0001\u0003bQ)aDa\u0019\u0003f!9!q\nB0\u0001\u00049\u0004b\u0002B*\u0005?\u0002\ra\u000e\u0005\n\u0005S\n\u0019\u0010\"\u0001\u0003\u0005W\nABY;jY\u0012<\u0016\u000e\u001e5ESZ$\u0012B\bB7\u0005c\u0012)H!\u001f\t\u000f\t=$q\ra\u0001o\u0005\u0019a.^7\t\u000f\tM$q\ra\u0001o\u0005!anZ2e\u0011\u001d\u00119Ha\u001aA\u0002]\n!A\u001d3\t\u000f\tm$q\ra\u0001o\u0005!A\u000eZ3o\u0011!\u00119&a=\u0005\u0002\t}D#\u0002\u0010\u0003\u0002\n\r\u0005b\u0002B(\u0005{\u0002\rA\n\u0005\b\u0005'\u0012i\b1\u0001'\u0011!\u00119&a=\u0005\u0004\t\u001dEc\u0001\u0010\u0003\n\"9!1\u0012BC\u0001\u0004Y\u0015!\u0001=\t\u0011\t]\u00131\u001fC\u0002\u0005\u001f#2A\bBI\u0011\u001d\u0011YI!$A\u0002]B\u0001Ba\u0016\u0002t\u0012\r!Q\u0013\u000b\u0004=\t]\u0005\u0002\u0003BF\u0005'\u0003\r!a\u0018\t\u0011\t]\u00131\u001fC\u0002\u00057#2A\bBO\u0011\u001d\u0011YI!'A\u0002EC\u0001Ba\u0016\u0002t\u0012\r!\u0011\u0015\u000b\u0004=\t\r\u0006\u0002\u0003BF\u0005?\u0003\rAa\u0012\t\u0011\t]\u00131\u001fC\u0002\u0005O#2A\bBU\u0011!\u0011YI!*A\u0002\u0005=\u0002\u0002\u0003B,\u0003g$\tA!,\u0015\u0007y\u0011y\u000b\u0003\u0005\u00032\n-\u0006\u0019\u0001BZ\u0003\u0005\u0011\b\u0003\u0002B[\u0005{sAAa.\u0003:B\u0011QcC\u0005\u0004\u0005w[\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003@\n\u0005'AB*ue&twMC\u0002\u0003<.A\u0001Ba\u0016\u0002t\u0012\r!Q\u0019\u000b\u0004=\t\u001d\u0007b\u0002B(\u0005\u0007\u0004\rA\n\u0005\t\u0005/\n\u0019\u0010b\u0001\u0003LR\u0019aD!4\t\u0011\t-%\u0011\u001aa\u0001\u0005\u001f\u00042a\bBi\u0013\r\u0011\u0019N\u0001\u0002\u0007\u001dVl'-\u001a:\u0007\u000f\t]\u00171\u001f\u0004\u0003Z\naAj\u001c8h%\u0006$\u0018n\u001c8bYN)!Q\u001b\u0010\u0003\u0004!Q!q\nBk\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0015\t}'Q\u001bB\u0001B\u0003%q'\u0001\u0002oA!Q!1\u000bBk\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0015\t\u0015(Q\u001bB\u0001B\u0003%q'\u0001\u0002eA!9\u0011E!6\u0005\u0002\t%HC\u0002Bv\u0005_\u0014\t\u0010\u0005\u0003\u0003n\nUWBAAz\u0011\u001d\u0011yEa:A\u0002]BqAa\u0015\u0003h\u0002\u0007q\u0007\u0003\u0004%\u0005+$\t!\n\u0005\u0007U\tUG\u0011A\u0013\t\rU\u0012)\u000e\"\u00017\u0011\u0019a#Q\u001bC\u0001[!11G!6\u0005\u00025Baa\u0010Bk\t\u00031\u0004BB\u001e\u0003V\u0012\u0005Q\u0006\u0003\u0004>\u0005+$\t!\f\u0005\u0007K\nUG\u0011A1\t\r\u001d\u0014)\u000e\"\u0011i\u0011\u0019\u0019%Q\u001bC!\t\"1!N!6\u0005B5Ba\u0001\u001cBk\t\u0003j\u0003bBB\b\u0005+$\t%L\u0001\fSN4\u0016\r\\5e\u0007\"\f'\u000fC\u0004\u0004\u0014\tUG\u0011I\u0017\u0002\u0017%\u001ch+\u00197jI\nKH/\u001a\u0005\b\u0007/\u0011)\u000e\"\u0011.\u00031I7OV1mS\u0012\u001c\u0006n\u001c:u\u0011\u001d\u0019YB!6\u0005B5\n!\"[:WC2LG-\u00138u\u0011\u0019\t%Q\u001bC![!9\u0011q\u000bBk\t\u0003*\u0003\u0002CB\u0012\u0005+$\te!\n\u0002\u0017\u0011|WO\u00197f-\u0006dW/\u001a\u000b\u0003\u0005\u000fBaA\u001cBk\t\u0003\u0012\u0003b\u00029\u0003V\u0012\u000511\u0006\u000b\u0004=\r5\u0002b\u0002BY\u0007S\u0001\rA\b\u0005\bk\nUG\u0011AB\u0019)\rq21\u0007\u0005\b\u0005c\u001by\u00031\u0001\u001f\u0011\u001dI(Q\u001bC\u0001\u0007o!2AHB\u001d\u0011\u001d\u0011\tl!\u000eA\u0002yAq! Bk\t\u0003\u0019i\u0004F\u0002\u001f\u0007\u007fAqA!-\u0004<\u0001\u0007a\u0004C\u0004\u0002\u0000\tUG\u0011A1\t\u000f\u0005\r%Q\u001bC\u0001C\"9\u0011q\u0011Bk\t\u0003\t\u0007\u0002CAK\u0005+$\ta!\u0013\u0015\u0007y\u0019Y\u0005C\u0004\u0002\u001c\u000e\u001d\u0003\u0019A&\t\u000f\u0005E&Q\u001bC\u0001Q\"A1\u0011\u000bBk\t\u0003\u0019\u0019&A\u0004d_6\u0004\u0018M]3\u0015\u0007-\u001b)\u0006C\u0004\u00032\u000e=\u0003\u0019\u0001\u0010\t\r\u0019\u0013)\u000e\"\u0011H\u0011!\tyN!6\u0005B\rmCc\u0001\u0018\u0004^!A\u0011Q]B-\u0001\u0004\t9\u000fC\u0004\u0004b\tUG\u0011\t&\u0002\u0011!\f7\u000f[\"pI\u0016D\u0001b!\u001a\u0003V\u0012\u00053qM\u0001\ti>\u001cFO]5oOR\u0011!1\u0017\u0015\t\u0005+\u001cYg!\u001d\u0004tA\u0019qf!\u001c\n\u0007\r=4B\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0001\u0001\u0003\u0005\u0004x\u0005MH\u0011BB=\u00031awN\\4SCRLwN\\1m)\u0019\u0011Yoa\u001f\u0004~!9!qJB;\u0001\u00049\u0004b\u0002B*\u0007k\u0002\ra\u000e\u0005\t\u0007\u0003\u000b\u0019\u0010\"\u0003\u0004\u0004\u0006Y!-[4SCRLwN\\1m)\u0019\u0019)ia\"\u0004\nB!!Q^Ax\u0011\u001d\u0011yea A\u0002\u0019BqAa\u0015\u0004\u0000\u0001\u0007a\u0005C\u0005\u0004\u000e\u0006M\u0018\u0011!C\u0005-\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f'\u0015\tyO\bB\u0002\u0011)\u0011y%a<\u0003\u0006\u0004%\t!\n\u0005\u000b\u0005?\fyO!A!\u0002\u00131\u0003B\u0003B*\u0003_\u0014)\u0019!C\u0001K!Q!Q]Ax\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u000f\u0005\ny\u000f\"\u0001\u0004\u001cR11QQBO\u0007?CqAa\u0014\u0004\u001a\u0002\u0007a\u0005C\u0004\u0003T\re\u0005\u0019\u0001\u0014\t\r\u0011\ny\u000f\"\u0001&\u0011\u0019Q\u0013q\u001eC\u0001K!1Q'a<\u0005\u0002YBa\u0001LAx\t\u0003i\u0003BB\u001a\u0002p\u0012\u0005Q\u0006\u0003\u0004@\u0003_$\tA\u000e\u0005\u0007w\u0005=H\u0011A\u0017\t\ru\ny\u000f\"\u0001.\u0011\u0019)\u0017q\u001eC\u0001C\"1q-a<\u0005B!DaaQAx\t\u0003\"\u0005B\u00026\u0002p\u0012\u0005S\u0006\u0003\u0004m\u0003_$\t%\f\u0005\b\u0007\u001f\ty\u000f\"\u0011.\u0011\u001d\u0019\u0019\"a<\u0005B5Bqaa\u0006\u0002p\u0012\u0005S\u0006C\u0004\u0004\u001c\u0005=H\u0011I\u0017\t\r\u0005\u000by\u000f\"\u0011.\u0011\u001d\t9&a<\u0005B\u0015B\u0001ba\t\u0002p\u0012\u00053Q\u0005\u0005\u0007]\u0006=H\u0011\t\u0012\t\u000fA\fy\u000f\"\u0001\u0004NR\u0019ada4\t\u000f\tE61\u001aa\u0001=!9Q/a<\u0005\u0002\rMGc\u0001\u0010\u0004V\"9!\u0011WBi\u0001\u0004q\u0002bB=\u0002p\u0012\u00051\u0011\u001c\u000b\u0004=\rm\u0007b\u0002BY\u0007/\u0004\rA\b\u0005\b{\u0006=H\u0011ABp)\rq2\u0011\u001d\u0005\b\u0005c\u001bi\u000e1\u0001\u001f\u0011\u001d\ty(a<\u0005\u0002\u0005Dq!a!\u0002p\u0012\u0005\u0011\rC\u0004\u0002\b\u0006=H\u0011A1\t\u0011\u0005U\u0015q\u001eC\u0001\u0007W$2AHBw\u0011\u001d\tYj!;A\u0002-Cq!!-\u0002p\u0012\u0005\u0001\u000e\u0003\u0005\u0004R\u0005=H\u0011ABz)\rY5Q\u001f\u0005\b\u0005c\u001b\t\u00101\u0001\u001f\u0011!\ty.a<\u0005B\reHc\u0001\u0018\u0004|\"A\u0011Q]B|\u0001\u0004\t9\u000fC\u0004\u0004b\u0005=H\u0011\t&\t\u0011\r\u0015\u0014q\u001eC!\u0007OB\u0003\"a<\u0004l\rE41O\u0004\b\t\u000b\u0011\u0001\u0012\u0001B\u0007\u0003!\u0011\u0016\r^5p]\u0006d\u0007")
public abstract class Rational
extends ScalaNumber
implements ScalaNumericConversions,
Ordered<Rational> {
    public static NumberTag.LargeTag<Rational> RationalTag() {
        return Rational$.MODULE$.RationalTag();
    }

    public static RationalAlgebra RationalAlgebra() {
        return Rational$.MODULE$.RationalAlgebra();
    }

    public static Rational apply(Number number) {
        return Rational$.MODULE$.apply(number);
    }

    public static Rational apply(SafeLong safeLong) {
        return Rational$.MODULE$.apply(safeLong);
    }

    public static Rational apply(String string) {
        return Rational$.MODULE$.apply(string);
    }

    public static Rational apply(BigDecimal bigDecimal) {
        return Rational$.MODULE$.apply(bigDecimal);
    }

    public static Rational apply(double d) {
        return Rational$.MODULE$.apply(d);
    }

    public static Rational apply(float f) {
        return Rational$.MODULE$.apply(f);
    }

    public static Rational apply(BigInt bigInt) {
        return Rational$.MODULE$.apply(bigInt);
    }

    public static Rational apply(long l) {
        return Rational$.MODULE$.apply(l);
    }

    public static Rational apply(int n) {
        return Rational$.MODULE$.apply(n);
    }

    public static Rational apply(SafeLong safeLong, SafeLong safeLong2) {
        return Rational$.MODULE$.apply(safeLong, safeLong2);
    }

    public static Rational apply(long l, long l2) {
        return Rational$.MODULE$.apply(l, l2);
    }

    public static Rational apply(BigInt bigInt, BigInt bigInt2) {
        return Rational$.MODULE$.apply(bigInt, bigInt2);
    }

    public static Rational one() {
        return Rational$.MODULE$.one();
    }

    public static Rational zero() {
        return Rational$.MODULE$.zero();
    }

    public boolean $less(Object that) {
        return Ordered.$less$((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.$greater$((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.compareTo$((Ordered)this, (Object)that);
    }

    public char toChar() {
        return ScalaNumericAnyConversions.toChar$((ScalaNumericAnyConversions)this);
    }

    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$((ScalaNumericAnyConversions)this);
    }

    public short toShort() {
        return ScalaNumericAnyConversions.toShort$((ScalaNumericAnyConversions)this);
    }

    public int toInt() {
        return ScalaNumericAnyConversions.toInt$((ScalaNumericAnyConversions)this);
    }

    public long toLong() {
        return ScalaNumericAnyConversions.toLong$((ScalaNumericAnyConversions)this);
    }

    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$((ScalaNumericAnyConversions)this);
    }

    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$((ScalaNumericAnyConversions)this);
    }

    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$((ScalaNumericAnyConversions)this);
    }

    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$((ScalaNumericAnyConversions)this, (Object)x);
    }

    public abstract SafeLong numerator();

    public abstract SafeLong denominator();

    public abstract boolean numeratorIsValidLong();

    public abstract boolean numeratorAbsIsValidLong();

    public abstract long numeratorAsLong();

    public abstract boolean denominatorIsValidLong();

    public abstract boolean denominatorAbsIsValidLong();

    public abstract long denominatorAsLong();

    public abstract boolean isValidLong();

    public abstract boolean isWhole();

    public long longValue() {
        return this.toBigInt().longValue();
    }

    public int intValue() {
        return Predef$.MODULE$.long2Long(this.longValue()).intValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public Object underlying() {
        return this;
    }

    public Rational abs() {
        return this.signum() < 0 ? this.unary_$minus() : this;
    }

    public Rational inverse() {
        return this.reciprocal();
    }

    public abstract Rational reciprocal();

    public abstract int signum();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public abstract Rational unary_$minus();

    public abstract Rational $plus(Rational var1);

    public abstract Rational $minus(Rational var1);

    public abstract Rational $times(Rational var1);

    public abstract Rational $div(Rational var1);

    public Rational lcm(Rational rhs) {
        return this.isZero() || rhs.isZero() ? Rational$.MODULE$.zero() : this.$div(this.gcd(rhs)).$times(rhs);
    }

    public Rational gcd(Rational rhs) {
        Rational rational;
        if (this.isZero()) {
            rational = rhs.abs();
        } else if (rhs.isZero()) {
            rational = this.abs();
        } else if (this.isOne() && rhs.isOne()) {
            rational = this;
        } else {
            LongRef newNumAsLong = LongRef.create((long)0L);
            ObjectRef newNumAsSafeLong = ObjectRef.create((Object)((Object)((SafeLong)((Object)Opt$.MODULE$.empty()))));
            if (this.numeratorAbsIsValidLong() && rhs.numeratorAbsIsValidLong()) {
                newNumAsLong.elem = package$.MODULE$.gcd(this.numeratorAsLong(), rhs.numeratorAsLong());
            } else {
                SafeLong newNum = this.numerator().gcd(rhs.numerator());
                if (newNum.isValidLong()) {
                    newNumAsLong.elem = newNum.toLong();
                } else {
                    newNumAsSafeLong.elem = Opt$.MODULE$.apply(newNum);
                }
            }
            if (this.denominatorAbsIsValidLong() && rhs.denominatorAbsIsValidLong()) {
                long ld = this.denominatorAsLong();
                long rd = rhs.denominatorAsLong();
                long dengcd = package$.MODULE$.gcd(ld, rd);
                long tmp = ld / dengcd;
                rational = Rational.checked$attempt$macro$428$1(newNumAsLong, newNumAsSafeLong, rd, tmp);
            } else {
                Rational rational2;
                SafeLong newDenAsSafeLong = this.denominator().lcm(rhs.denominator());
                SafeLong safeLong = (SafeLong)((Object)newNumAsSafeLong.elem);
                SafeLong safeLong2 = Opt$.MODULE$.unapply(safeLong);
                if (!Opt$.MODULE$.isEmpty$extension(safeLong2)) {
                    SafeLong sl = Opt$.MODULE$.get$extension(safeLong2);
                    rational2 = Rational$.MODULE$.apply(sl, newDenAsSafeLong);
                } else {
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(newNumAsLong.elem), newDenAsSafeLong);
                }
                rational = rational2;
            }
        }
        return rational;
    }

    public Real toReal() {
        return Real$.MODULE$.apply(this);
    }

    public Algebraic toAlgebraic() {
        return Algebraic$.MODULE$.apply(this);
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode mode) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, scale, mode));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, mc));
    }

    public abstract SafeLong toSafeLong();

    public final BigInt toBigInt() {
        return this.toSafeLong().toBigInt();
    }

    public short shortValue() {
        return (short)this.longValue();
    }

    public byte byteValue() {
        return (byte)this.longValue();
    }

    public abstract Rational floor();

    public abstract Rational ceil();

    public abstract Rational round();

    public Rational roundTo(SafeLong denom) {
        return this.$times(Rational$.MODULE$.apply(denom)).round().$div(Rational$.MODULE$.apply(denom));
    }

    public abstract Rational pow(int var1);

    public Sign sign() {
        return Sign$.MODULE$.apply(this.signum());
    }

    public abstract int compareToOne();

    public Rational min(Rational rhs) {
        return this.compare((Object)rhs) < 0 ? this : rhs;
    }

    public Rational max(Rational rhs) {
        return this.compare((Object)rhs) > 0 ? this : rhs;
    }

    public Rational limitToInt() {
        return this.limitTo(SafeLong$.MODULE$.apply(scala.package$.MODULE$.BigInt().apply(Integer.MAX_VALUE)));
    }

    public Rational limitToLong() {
        return this.limitTo(SafeLong$.MODULE$.apply(scala.package$.MODULE$.BigInt().apply(Long.MAX_VALUE)));
    }

    public Rational limitTo(SafeLong max) {
        Rational rational;
        if (this.signum() < 0) {
            rational = this.unary_$minus().limitTo(max).unary_$minus();
        } else {
            Predef$.MODULE$.require(max.signum() > 0, (Function0 & Serializable & scala.Serializable)() -> "Limit must be a positive integer.");
            SafeLong half = max.$greater$greater(1);
            SafeLong floor = SafeLong$.MODULE$.apply(this.toBigInt());
            rational = floor.$greater$eq((Object)max) ? Rational$.MODULE$.apply(max) : (floor.$greater$eq((Object)max.$greater$greater(1)) ? Rational$.MODULE$.apply(floor.toLong()) : (this.compareToOne() < 0 ? this.limitDenominatorTo(max) : this.limitDenominatorTo(max.$times(this.denominator()).$div(this.numerator()))));
        }
        return rational;
    }

    public Rational limitDenominatorTo(SafeLong limit) {
        Rational rational;
        Predef$.MODULE$.require(limit.signum() > 0, (Function0 & Serializable & scala.Serializable)() -> "Cannot limit denominator to non-positive number.");
        Sign sign = this.sign();
        if (Sign$Zero$.MODULE$.equals(sign)) {
            rational = this;
        } else if (Sign$Positive$.MODULE$.equals(sign)) {
            rational = this.closest$1(Rational$.MODULE$.apply(this.toBigInt()), new LongRational(1L, 0L), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else if (Sign$Negative$.MODULE$.equals(sign)) {
            rational = this.closest$1(new LongRational(-1L, 0L), Rational$.MODULE$.apply(this.toBigInt()), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else {
            throw new MatchError((Object)sign);
        }
        return rational;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Real) {
            Real real = (Real)object;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)real.toRational()))) return false;
            return true;
        }
        if (object instanceof Algebraic) {
            Algebraic algebraic = (Algebraic)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)algebraic), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            if (!this.isWhole()) return false;
            BigInt bigInt2 = this.toBigInt();
            BigInt bigInt3 = bigInt;
            if (bigInt2 != null) {
                if (!bigInt2.equals(bigInt3)) return false;
                return true;
            }
            if (bigInt3 == null) return true;
            return false;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            try {
                BigDecimal bigDecimal2 = this.toBigDecimal(bigDecimal.mc());
                BigDecimal bigDecimal3 = bigDecimal;
                if (bigDecimal2 != null) {
                    if (!bigDecimal2.equals(bigDecimal3)) return false;
                    return true;
                }
                if (bigDecimal3 == null) return true;
                return false;
            }
            catch (ArithmeticException ae) {
                return false;
            }
        }
        if (object instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)SafeLong$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)safeLong))) return false;
            return true;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            Number number2 = Number$.MODULE$.apply(this);
            Number number3 = number;
            if (number2 != null) {
                if (!number2.equals(number3)) return false;
                return true;
            }
            if (number3 == null) return true;
            return false;
        }
        if (object instanceof Natural) {
            Natural natural = (Natural)((Object)object);
            if (!this.isWhole()) return false;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)Rational$.MODULE$.apply(natural.toBigInt())))) return false;
            return true;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)complex), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)quaternion), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (!(object instanceof Long)) return this.unifiedPrimitiveEquals(object);
        long l = BoxesRunTime.unboxToLong((Object)object);
        if (!this.isValidLong()) return false;
        if (this.toLong() != l) return false;
        return true;
    }

    private static final Rational checked$fallback$macro$429$1(LongRef newNumAsLong$1, ObjectRef newNumAsSafeLong$1, long rd$1, long tmp$1) {
        SafeLong newDenAsSafeLong = SafeLong$.MODULE$.apply(tmp$1).$times(rd$1);
        return Opt$.MODULE$.isEmpty$extension((SafeLong)((Object)newNumAsSafeLong$1.elem)) ? Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(newNumAsLong$1.elem), newDenAsSafeLong) : Rational$.MODULE$.apply(Opt$.MODULE$.get$extension((SafeLong)((Object)newNumAsSafeLong$1.elem)), newDenAsSafeLong);
    }

    private static final Rational checked$attempt$macro$428$1(LongRef newNumAsLong$1, ObjectRef newNumAsSafeLong$1, long rd$1, long tmp$1) {
        long z$macro$430 = tmp$1 * rd$1;
        if (tmp$1 != 0L && (rd$1 != z$macro$430 / tmp$1 || tmp$1 == -1L && rd$1 == Long.MIN_VALUE)) {
            return Rational.checked$fallback$macro$429$1(newNumAsLong$1, newNumAsSafeLong$1, rd$1, tmp$1);
        }
        long newDenAsLong = z$macro$430;
        return Opt$.MODULE$.isEmpty$extension((SafeLong)((Object)newNumAsSafeLong$1.elem)) ? Rational$.MODULE$.apply(newNumAsLong$1.elem, newDenAsLong) : Rational$.MODULE$.apply(Opt$.MODULE$.get$extension((SafeLong)((Object)newNumAsSafeLong$1.elem)), SafeLong$.MODULE$.apply(newDenAsLong));
    }

    private static final SafeLong nextK$1(SafeLong curr) {
        return Opt$.MODULE$.isEmpty$extension(curr) ? Opt$.MODULE$.apply(SafeLong$.MODULE$.apply(2L)) : Opt$.MODULE$.apply(Opt$.MODULE$.get$extension(curr).$times(2L));
    }

    /*
     * Unable to fully structure code
     */
    private final Rational closest$1(Rational l, Rational u, SafeLong lk, SafeLong rk, SafeLong limit$1) {
        while (true) {
            block9: {
                block8: {
                    if ((var9_8 = new Tuple2.mcZZ.sp(Opt$.MODULE$.nonEmpty$extension(lk), Opt$.MODULE$.nonEmpty$extension(rk))) == null) break block8;
                    var10_9 = var9_8._1$mcZ$sp();
                    var11_10 = var9_8._2$mcZ$sp();
                    if (!var10_9 || var11_10) break block8;
                    var7_6 = Rational$.MODULE$.apply(Opt$.MODULE$.get$extension(lk).$times(l.numerator()).$plus(u.numerator()), Opt$.MODULE$.get$extension(lk).$times(l.denominator()).$plus(u.denominator()));
                    break block9;
                }
                if (var9_8 == null) ** GOTO lbl-1000
                var12_11 = var9_8._1$mcZ$sp();
                var13_12 = var9_8._2$mcZ$sp();
                if (!var12_11 && var13_12) {
                    var7_6 = Rational$.MODULE$.apply(l.numerator().$plus(Opt$.MODULE$.get$extension(rk).$times(u.numerator())), l.denominator().$plus(Opt$.MODULE$.get$extension(rk).$times(u.denominator())));
                } else lbl-1000:
                // 2 sources

                {
                    var7_6 = Rational$.MODULE$.apply(l.numerator().$plus(u.numerator()), l.denominator().$plus(u.denominator()));
                }
            }
            mediant = var7_6;
            if (mediant.denominator().$greater((Object)limit$1)) {
                if (Opt$.MODULE$.nonEmpty$extension(lk) || Opt$.MODULE$.nonEmpty$extension(rk)) {
                    rk = (SafeLong)Opt$.MODULE$.empty();
                    lk = (SafeLong)Opt$.MODULE$.empty();
                    continue;
                }
                if (this.$minus(l).abs().$greater((Object)u.$minus(this).abs())) {
                    v0 = u;
                    break;
                }
                v0 = l;
                break;
            }
            if (BoxesRunTime.equalsNumNum((java.lang.Number)mediant, (java.lang.Number)this)) {
                v0 = mediant;
                break;
            }
            if (mediant.$less((Object)this)) {
                rk = Rational.nextK$1(rk);
                lk = (SafeLong)Opt$.MODULE$.empty();
                l = mediant;
                continue;
            }
            rk = (SafeLong)Opt$.MODULE$.empty();
            lk = Rational.nextK$1(lk);
            u = mediant;
        }
        return v0;
    }

    public Rational() {
        ScalaNumericAnyConversions.$init$((ScalaNumericAnyConversions)this);
        Ordered.$init$((Ordered)this);
    }

    public static final class BigRational
    extends Rational
    implements scala.Serializable {
        public static final long serialVersionUID = 0L;
        private final SafeLong n;
        private final SafeLong d;

        public SafeLong n() {
            return this.n;
        }

        public SafeLong d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return this.n();
        }

        @Override
        public SafeLong denominator() {
            return this.d();
        }

        @Override
        public long numeratorAsLong() {
            return this.n().toLong();
        }

        @Override
        public boolean numeratorIsValidLong() {
            return this.n().isValidLong();
        }

        @Override
        public boolean numeratorAbsIsValidLong() {
            return this.n().isValidLong() && this.n().toLong() != Long.MIN_VALUE;
        }

        @Override
        public long denominatorAsLong() {
            return this.d().toLong();
        }

        @Override
        public boolean denominatorIsValidLong() {
            return this.d().isValidLong();
        }

        @Override
        public boolean denominatorAbsIsValidLong() {
            return this.d().isValidLong() && this.d().toLong() != Long.MIN_VALUE;
        }

        @Override
        public Rational reciprocal() {
            return this.signum() < 0 ? Rational$.MODULE$.apply(this.d().unary_$minus(), this.n().unary_$minus()) : Rational$.MODULE$.spire$math$Rational$$bigRational(this.d(), this.n());
        }

        @Override
        public int signum() {
            return this.n().signum();
        }

        @Override
        public boolean isWhole() {
            return this.d().isOne();
        }

        @Override
        public boolean isZero() {
            return false;
        }

        @Override
        public boolean isOne() {
            return false;
        }

        @Override
        public boolean isValidChar() {
            return false;
        }

        @Override
        public boolean isValidByte() {
            return false;
        }

        @Override
        public boolean isValidShort() {
            return false;
        }

        @Override
        public boolean isValidInt() {
            return false;
        }

        @Override
        public boolean isValidLong() {
            return false;
        }

        @Override
        public SafeLong toSafeLong() {
            return this.n().$div(this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(this.n(), this.d());
        }

        @Override
        public Rational unary_$minus() {
            return Rational$.MODULE$.apply(this.n().unary_$minus(), this.d());
        }

        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.$plus(this);
            } else if (rational2 instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)rational2;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational3 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$plus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational3 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.unary_$minus().$plus(this);
            } else if (rational2 instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)rational2;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational3 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$minus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational3 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.$times(this);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                SafeLong a = this.n().gcd(bigRational.d());
                SafeLong b = this.d().gcd(bigRational.n());
                rational = Rational$.MODULE$.apply(this.n().$div(a).$times(bigRational.n().$div(b)), this.d().$div(b).$times(bigRational.d().$div(a)));
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.inverse().$times(this);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                SafeLong a = this.n().gcd(bigRational.n());
                SafeLong b = this.d().gcd(bigRational.d());
                SafeLong num = this.n().$div(a).$times(bigRational.d().$div(b));
                SafeLong den = this.d().$div(b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            return this.isWhole() ? this : (this.n().signum() >= 0 ? Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one()) : Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L), SafeLong$.MODULE$.one()));
        }

        @Override
        public Rational ceil() {
            return this.isWhole() ? this : (this.n().signum() >= 0 ? Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L), SafeLong$.MODULE$.one()) : Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one()));
        }

        @Override
        public Rational round() {
            SafeLong m;
            SafeLong m2;
            Rational rational = this.n().signum() >= 0 ? ((m2 = this.n().$percent(this.d())).$greater$eq((Object)this.d().$minus(m2)) ? Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L)) : Rational$.MODULE$.apply(this.n().$div(this.d()))) : ((m = this.n().$percent(this.d()).unary_$minus()).$greater$eq((Object)this.d().$minus(m)) ? Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L)) : Rational$.MODULE$.apply(this.n().$div(this.d())));
            return rational;
        }

        @Override
        public Rational pow(int exp) {
            return exp == 0 ? Rational$.MODULE$.one() : (exp < 0 ? Rational$.MODULE$.apply(this.d().pow(-exp), this.n().pow(-exp)) : Rational$.MODULE$.apply(this.n().pow(exp), this.d().pow(exp)));
        }

        @Override
        public int compareToOne() {
            return this.n().compare((Object)this.d());
        }

        public int compare(Rational r) {
            int n;
            Rational rational = r;
            if (rational instanceof LongRational) {
                LongRational longRational = (LongRational)rational;
                long dgcd = package$.MODULE$.gcd(longRational.d(), this.d().$percent(longRational.d()).toLong());
                n = dgcd == 1L ? this.n().$times(longRational.d()).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d())) : this.n().$times(longRational.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d().$div(dgcd)));
            } else if (rational instanceof BigRational) {
                BigRational bigRational = (BigRational)rational;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                n = dgcd.isOne() ? this.n().$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : bigRational.d().$div(dgcd).$times(this.n()).compare((Object)this.d().$div(dgcd).$times(bigRational.n()));
            } else {
                throw new MatchError((Object)rational);
            }
            return n;
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            Object object = that;
            if (object instanceof BigRational) {
                BigRational bigRational = (BigRational)((Object)object);
                bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.n()), (java.lang.Number)((Object)bigRational.n())) && BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.d()), (java.lang.Number)((Object)bigRational.d()));
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            return 29 * (37 * Statics.anyHash((Object)((Object)this.n())) + Statics.anyHash((Object)((Object)this.d())));
        }

        public String toString() {
            return this.isWhole() ? this.n().toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.n(), this.d()}));
        }

        public BigRational(SafeLong n, SafeLong d) {
            this.n = n;
            this.d = d;
        }
    }

    public static final class LongRational
    extends Rational
    implements scala.Serializable {
        public static final long serialVersionUID = 0L;
        private final long n;
        private final long d;

        public long n() {
            return this.n;
        }

        public long d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return SafeLong$.MODULE$.apply(this.n());
        }

        @Override
        public SafeLong denominator() {
            return SafeLong$.MODULE$.apply(this.d());
        }

        @Override
        public long numeratorAsLong() {
            return this.n();
        }

        @Override
        public boolean numeratorIsValidLong() {
            return true;
        }

        @Override
        public boolean numeratorAbsIsValidLong() {
            return this.n() != Long.MIN_VALUE;
        }

        @Override
        public long denominatorAsLong() {
            return this.d();
        }

        @Override
        public boolean denominatorIsValidLong() {
            return true;
        }

        @Override
        public boolean denominatorAbsIsValidLong() {
            return this.d() != Long.MIN_VALUE;
        }

        @Override
        public Rational reciprocal() {
            if (this.n() == 0L) {
                throw new ArithmeticException("reciprocal called on 0/1");
            }
            return this.n() > 0L ? Rational$.MODULE$.spire$math$Rational$$longRational(this.d(), this.n()) : (this.n() == Long.MIN_VALUE || this.d() == Long.MIN_VALUE ? Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(this.d()).unary_$minus(), SafeLong$.MODULE$.apply(this.n()).unary_$minus()) : Rational$.MODULE$.spire$math$Rational$$longRational(-this.d(), -this.n()));
        }

        @Override
        public int signum() {
            return Long.signum(this.n());
        }

        @Override
        public boolean isWhole() {
            return this.d() == 1L;
        }

        @Override
        public boolean isZero() {
            return this.n() == 0L;
        }

        @Override
        public boolean isOne() {
            return this.d() == 1L && this.n() == 1L;
        }

        @Override
        public boolean isValidChar() {
            return this.isWhole() && RichLong$.MODULE$.isValidChar$extension(this.n());
        }

        @Override
        public boolean isValidByte() {
            return this.isWhole() && RichLong$.MODULE$.isValidByte$extension(this.n());
        }

        @Override
        public boolean isValidShort() {
            return this.isWhole() && RichLong$.MODULE$.isValidShort$extension(this.n());
        }

        @Override
        public boolean isValidInt() {
            return this.isWhole() && RichLong$.MODULE$.isValidInt$extension(this.n());
        }

        @Override
        public boolean isValidLong() {
            return this.isWhole();
        }

        @Override
        public SafeLong toSafeLong() {
            return SafeLong$.MODULE$.apply(this.n() / this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(SafeLong$.MODULE$.apply(this.n()), SafeLong$.MODULE$.apply(this.d()));
        }

        @Override
        public Rational unary_$minus() {
            return this.n() == Long.MIN_VALUE ? Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.safe64(), SafeLong$.MODULE$.apply(this.d())) : Rational$.MODULE$.spire$math$Rational$$longRational(-this.n(), this.d());
        }

        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                Rational rational3;
                LongRational longRational = (LongRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    long x$macro$438 = this.n();
                    long y$macro$439 = longRational.d();
                    long z$macro$437 = x$macro$438 * y$macro$439;
                    if (x$macro$438 != 0L && (y$macro$439 != z$macro$437 / x$macro$438 || x$macro$438 == -1L && y$macro$439 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$433$1(longRational);
                    }
                    long x$macro$435 = z$macro$437;
                    long x$macro$441 = longRational.n();
                    long y$macro$442 = this.d();
                    long z$macro$440 = x$macro$441 * y$macro$442;
                    if (x$macro$441 != 0L && (y$macro$442 != z$macro$440 / x$macro$441 || x$macro$441 == -1L && y$macro$442 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$433$1(longRational);
                    }
                    long y$macro$436 = z$macro$440;
                    long z$macro$434 = x$macro$435 + y$macro$436;
                    if (((x$macro$435 ^ y$macro$436 ^ 0xFFFFFFFFFFFFFFFFL) & (x$macro$435 ^ z$macro$434)) < 0L) {
                        return this.checked$fallback$macro$433$1(longRational);
                    }
                    long x$macro$444 = this.d();
                    long y$macro$445 = longRational.d();
                    long z$macro$443 = x$macro$444 * y$macro$445;
                    if (x$macro$444 != 0L && (y$macro$445 != z$macro$443 / x$macro$444 || x$macro$444 == -1L && y$macro$445 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$433$1(longRational);
                    }
                    rational3 = Rational$.MODULE$.apply(z$macro$434, z$macro$443);
                } else {
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$451 = this.n();
                    long z$macro$450 = x$macro$451 * rden;
                    if (x$macro$451 != 0L && (rden != z$macro$450 / x$macro$451 || x$macro$451 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$446$1(dgcd, lden, rden, longRational);
                    }
                    long x$macro$448 = z$macro$450;
                    long x$macro$453 = longRational.n();
                    long z$macro$452 = x$macro$453 * lden;
                    if (x$macro$453 != 0L && (lden != z$macro$452 / x$macro$453 || x$macro$453 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$446$1(dgcd, lden, rden, longRational);
                    }
                    long y$macro$449 = z$macro$452;
                    long z$macro$447 = x$macro$448 + y$macro$449;
                    if (((x$macro$448 ^ y$macro$449 ^ 0xFFFFFFFFFFFFFFFFL) & (x$macro$448 ^ z$macro$447)) < 0L) {
                        return this.checked$fallback$macro$446$1(dgcd, lden, rden, longRational);
                    }
                    long num = z$macro$447;
                    long ngcd = package$.MODULE$.gcd(num, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$455 = longRational.d();
                        long z$macro$454 = lden * y$macro$455;
                        if (lden != 0L && (y$macro$455 != z$macro$454 / lden || lden == -1L && y$macro$455 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$446$1(dgcd, lden, rden, longRational);
                        }
                        rational3 = Rational$.MODULE$.apply(num, z$macro$454);
                    } else {
                        rational3 = Rational$.MODULE$.buildWithDiv(num, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational3;
            } else if (rational2 instanceof BigRational) {
                Rational rational4;
                BigRational bigRational = (BigRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational4 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$plus(bigRational.n().$times(lden));
                    SafeLong safeLong = num;
                    if (safeLong instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                        long x = safeLongLong.x();
                        l = package$.MODULE$.gcd(x, dgcd);
                    } else if (safeLong instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                        BigInteger x = safeLongBigInteger.x();
                        l = package$.MODULE$.gcd(dgcd, x.mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)safeLong);
                    }
                    long ngcd = l;
                    rational4 = ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational4;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                Rational rational3;
                LongRational longRational = (LongRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    long x$macro$461 = this.n();
                    long y$macro$462 = longRational.d();
                    long z$macro$460 = x$macro$461 * y$macro$462;
                    if (x$macro$461 != 0L && (y$macro$462 != z$macro$460 / x$macro$461 || x$macro$461 == -1L && y$macro$462 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$456$1(longRational);
                    }
                    long x$macro$458 = z$macro$460;
                    long x$macro$464 = longRational.n();
                    long y$macro$465 = this.d();
                    long z$macro$463 = x$macro$464 * y$macro$465;
                    if (x$macro$464 != 0L && (y$macro$465 != z$macro$463 / x$macro$464 || x$macro$464 == -1L && y$macro$465 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$456$1(longRational);
                    }
                    long y$macro$459 = z$macro$463;
                    long z$macro$457 = x$macro$458 - y$macro$459;
                    if (((x$macro$458 ^ y$macro$459) & (x$macro$458 ^ z$macro$457)) < 0L) {
                        return this.checked$fallback$macro$456$1(longRational);
                    }
                    long x$macro$467 = this.d();
                    long y$macro$468 = longRational.d();
                    long z$macro$466 = x$macro$467 * y$macro$468;
                    if (x$macro$467 != 0L && (y$macro$468 != z$macro$466 / x$macro$467 || x$macro$467 == -1L && y$macro$468 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$456$1(longRational);
                    }
                    rational3 = Rational$.MODULE$.apply(z$macro$457, z$macro$466);
                } else {
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$474 = this.n();
                    long z$macro$473 = x$macro$474 * rden;
                    if (x$macro$474 != 0L && (rden != z$macro$473 / x$macro$474 || x$macro$474 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$469$1(dgcd, lden, rden, longRational);
                    }
                    long x$macro$471 = z$macro$473;
                    long x$macro$476 = longRational.n();
                    long z$macro$475 = x$macro$476 * lden;
                    if (x$macro$476 != 0L && (lden != z$macro$475 / x$macro$476 || x$macro$476 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$469$1(dgcd, lden, rden, longRational);
                    }
                    long y$macro$472 = z$macro$475;
                    long z$macro$470 = x$macro$471 - y$macro$472;
                    if (((x$macro$471 ^ y$macro$472) & (x$macro$471 ^ z$macro$470)) < 0L) {
                        return this.checked$fallback$macro$469$1(dgcd, lden, rden, longRational);
                    }
                    long num = z$macro$470;
                    long ngcd = package$.MODULE$.gcd(num, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$478 = longRational.d();
                        long z$macro$477 = lden * y$macro$478;
                        if (lden != 0L && (y$macro$478 != z$macro$477 / lden || lden == -1L && y$macro$478 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$469$1(dgcd, lden, rden, longRational);
                        }
                        rational3 = Rational$.MODULE$.apply(num, z$macro$477);
                    } else {
                        rational3 = Rational$.MODULE$.buildWithDiv(num, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational3;
            } else if (rational2 instanceof BigRational) {
                Rational rational4;
                BigRational bigRational = (BigRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational4 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$minus(bigRational.n().$times(lden));
                    SafeLong safeLong = num;
                    if (safeLong instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                        long x = safeLongLong.x();
                        l = package$.MODULE$.gcd(x, dgcd);
                    } else if (safeLong instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                        BigInteger x = safeLongBigInteger.x();
                        l = package$.MODULE$.gcd(dgcd, x.mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)safeLong);
                    }
                    long ngcd = l;
                    rational4 = ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational4;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            if (this.n() == 0L) {
                rational = Rational$.MODULE$.zero();
            } else {
                Rational rational2;
                Rational rational3 = r;
                if (rational3 instanceof LongRational) {
                    LongRational longRational = (LongRational)rational3;
                    long a = package$.MODULE$.gcd(this.n(), longRational.d());
                    long b = package$.MODULE$.gcd(this.d(), longRational.n());
                    long n1 = this.n() / a;
                    long n2 = longRational.n() / b;
                    long d1 = this.d() / b;
                    long d2 = longRational.d() / a;
                    long z$macro$480 = n1 * n2;
                    if (n1 != 0L && (n2 != z$macro$480 / n1 || n1 == -1L && n2 == Long.MIN_VALUE)) {
                        return LongRational.checked$fallback$macro$479$1(n1, n2, d1, d2);
                    }
                    long z$macro$481 = d1 * d2;
                    if (d1 != 0L && (d2 != z$macro$481 / d1 || d1 == -1L && d2 == Long.MIN_VALUE)) {
                        return LongRational.checked$fallback$macro$479$1(n1, n2, d1, d2);
                    }
                    rational2 = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$480, z$macro$481);
                } else if (rational3 instanceof BigRational) {
                    BigRational bigRational = (BigRational)rational3;
                    long a = package$.MODULE$.gcd(this.n(), bigRational.d().$percent(this.n()).toLong());
                    long b = package$.MODULE$.gcd(this.d(), bigRational.n().$percent(this.d()).toLong());
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.n().$div(b)), SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.d().$div(a)));
                } else {
                    throw new MatchError((Object)rational3);
                }
                rational = rational2;
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                if (longRational.n() == 0L) {
                    throw new ArithmeticException("divide (/) by 0");
                }
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), longRational.n());
                long b = package$.MODULE$.gcd(this.d(), longRational.d());
                long n1 = this.n() / a;
                long n2 = longRational.n() / a;
                LongRef d1 = LongRef.create((long)(this.d() / b));
                LongRef d2 = LongRef.create((long)(longRational.d() / b));
                if (n2 < 0L) {
                    d1.elem = -d1.elem;
                    d2.elem = -d2.elem;
                }
                long z$macro$483 = n1 * d2.elem;
                if (n1 != 0L && (d2.elem != z$macro$483 / n1 || n1 == -1L && d2.elem == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$482$1(n1, n2, d1, d2);
                }
                long z$macro$484 = d1.elem * n2;
                if (d1.elem != 0L && (n2 != z$macro$484 / d1.elem || d1.elem == -1L && n2 == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$482$1(n1, n2, d1, d2);
                }
                rational = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$483, z$macro$484);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), bigRational.n().$percent(this.n()).toLong());
                long b = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                SafeLong num = SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.d().$div(b));
                SafeLong den = SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            return this.d() == 1L ? this : (this.n() >= 0L ? Rational$.MODULE$.apply(this.n() / this.d(), 1L) : Rational$.MODULE$.apply(this.n() / this.d() - 1L, 1L));
        }

        @Override
        public Rational ceil() {
            return this.d() == 1L ? this : (this.n() >= 0L ? Rational$.MODULE$.apply(this.n() / this.d() + 1L, 1L) : Rational$.MODULE$.apply(this.n() / this.d(), 1L));
        }

        @Override
        public Rational round() {
            long m;
            long m2;
            Rational rational = this.n() >= 0L ? ((m2 = this.n() % this.d()) >= this.d() - m2 ? Rational$.MODULE$.apply(this.n() / this.d() + 1L) : Rational$.MODULE$.apply(this.n() / this.d())) : ((m = -(this.n() % this.d())) >= this.d() - m ? Rational$.MODULE$.apply(this.n() / this.d() - 1L) : Rational$.MODULE$.apply(this.n() / this.d()));
            return rational;
        }

        @Override
        public Rational pow(int exp) {
            return exp == 0 ? Rational$.MODULE$.one() : (exp < 0 ? this.reciprocal().pow(-exp) : Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).pow(exp), SafeLong$.MODULE$.apply(this.d()).pow(exp)));
        }

        @Override
        public int compareToOne() {
            return new RichLong(Predef$.MODULE$.longWrapper(this.n())).compare((Object)BoxesRunTime.boxToLong((long)this.d()));
        }

        public int compare(Rational r) {
            int n;
            Rational rational = r;
            if (rational instanceof LongRational) {
                LongRational longRational = (LongRational)rational;
                n = this.checked$attempt$macro$485$1(longRational);
            } else if (rational instanceof BigRational) {
                BigRational bigRational = (BigRational)rational;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                n = dgcd == 1L ? SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d().$div(dgcd)).compare((Object)bigRational.n().$times(this.d() / dgcd));
            } else {
                throw new MatchError((Object)rational);
            }
            return n;
        }

        @Override
        public long longValue() {
            return this.d() == 1L ? this.n() : this.n() / this.d();
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            Object object = that;
            if (object instanceof LongRational) {
                LongRational longRational = (LongRational)((Object)object);
                bl = this.n() == longRational.n() && this.d() == longRational.d();
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            return this.d() == 1L ? this.unifiedPrimitiveHashcode() : 29 * (37 * Statics.longHash((long)this.n()) + Statics.longHash((long)this.d()));
        }

        public String toString() {
            return this.isWhole() ? ((Object)BoxesRunTime.boxToLong((long)this.n())).toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.n()), BoxesRunTime.boxToLong((long)this.d())}));
        }

        private final Rational checked$fallback$macro$433$1(LongRational x2$1) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$1.d()).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$1.d()));
        }

        private final Rational checked$fallback$macro$446$1(long dgcd$1, long lden$2, long rden$1, LongRational x2$1) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$1).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(lden$2));
            long ngcd = package$.MODULE$.gcd(dgcd$1, num.$percent(dgcd$1).toLong());
            return ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d())) : Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d() / ngcd));
        }

        private final Rational checked$fallback$macro$456$1(LongRational x2$2) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$2.d()).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$2.d()));
        }

        private final Rational checked$fallback$macro$469$1(long dgcd$2, long lden$3, long rden$2, LongRational x2$2) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$2).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(lden$3));
            long ngcd = package$.MODULE$.gcd(dgcd$2, num.$percent(dgcd$2).toLong());
            return ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d())) : Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d() / ngcd));
        }

        private static final Rational checked$fallback$macro$479$1(long n1$1, long n2$1, long d1$1, long d2$1) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$1).$times(n2$1), SafeLong$.MODULE$.apply(d1$1).$times(d2$1));
        }

        private static final Rational checked$fallback$macro$482$1(long n1$2, long n2$2, LongRef d1$2, LongRef d2$2) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$2).$times(d2$2.elem), SafeLong$.MODULE$.apply(d1$2.elem).$times(n2$2));
        }

        private final int checked$fallback$macro$486$1(LongRational x2$3) {
            long dgcd = package$.MODULE$.gcd(this.d(), x2$3.d());
            return dgcd == 1L ? SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d()).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d())) : SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d() / dgcd));
        }

        private final int checked$attempt$macro$485$1(LongRational x2$3) {
            long x$macro$488 = this.n();
            long y$macro$489 = x2$3.d();
            long z$macro$487 = x$macro$488 * y$macro$489;
            if (x$macro$488 != 0L && (y$macro$489 != z$macro$487 / x$macro$488 || x$macro$488 == -1L && y$macro$489 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$486$1(x2$3);
            }
            long x$macro$491 = x2$3.n();
            long y$macro$492 = this.d();
            long z$macro$490 = x$macro$491 * y$macro$492;
            if (x$macro$491 != 0L && (y$macro$492 != z$macro$490 / x$macro$491 || x$macro$491 == -1L && y$macro$492 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$486$1(x2$3);
            }
            return package$long$.MODULE$.LongAlgebra().compare$mcJ$sp(z$macro$487, z$macro$490);
        }

        public LongRational(long n, long d) {
            this.n = n;
            this.d = d;
        }
    }
}

