%dw 2.0
/**
 * Transforms the specified binary into the hexadecimal String representation
 */
fun toHex(content: Binary): String = native("system::BinaryToHexFunctionValue")

/**
 * Converts an hexadecimal string representation into a binary
 */
fun fromHex(hexString: String): Binary = native("system::HexToBinaryFunctionValue")

/**
 * Transforms the specified binary into the base64 string representation
 */
fun toBase64(content: Binary): String = native("system::BinaryToBase64FunctionValue")

/**
 * Converts a base64 string representation into a binary
 */
fun fromBase64(base64String: String): Binary = native("system::Base64ToBinaryFunctionValue")