/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.js.model;

import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.topbraid.shacl.js.model.JSBlankNode;
import org.topbraid.shacl.js.model.JSLiteral;
import org.topbraid.shacl.js.model.JSNamedNode;
import org.topbraid.shacl.js.model.JSTerm;
import org.topbraid.shacl.js.model.JSTriple;

public class JSFactory {
    public static final String BLANK_NODE = "BlankNode";
    public static final String DATATYPE = "datatype";
    public static final String LANGUAGE = "language";
    public static final String LITERAL = "Literal";
    public static final String NAMED_NODE = "NamedNode";
    public static final String TERM_TYPE = "termType";
    public static final String VALUE = "value";

    public static Node getNode(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSTerm) {
            return ((JSTerm)obj).getNode();
        }
        if (obj instanceof Map) {
            Map som = (Map)obj;
            String value = (String)som.get(VALUE);
            if (value == null) {
                throw new IllegalArgumentException("Missing value");
            }
            String termType = (String)som.get(TERM_TYPE);
            if (NAMED_NODE.equals(termType)) {
                return NodeFactory.createURI((String)value);
            }
            if (BLANK_NODE.equals(termType)) {
                return NodeFactory.createBlankNode((String)value);
            }
            if (LITERAL.equals(termType)) {
                String lang = (String)som.get(LANGUAGE);
                Map dt = (Map)som.get(DATATYPE);
                String dtURI = (String)dt.get(VALUE);
                RDFDatatype datatype = TypeMapper.getInstance().getSafeTypeByName(dtURI);
                return NodeFactory.createLiteral((String)value, (String)lang, (RDFDatatype)datatype);
            }
            throw new IllegalArgumentException("Unsupported term type " + termType);
        }
        return null;
    }

    public static Node getNodeSafe(Object obj) {
        try {
            return JSFactory.getNode(obj);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static JSTerm asJSTerm(Node node) {
        if (node.isURI()) {
            return new JSNamedNode(node);
        }
        if (node.isBlank()) {
            return new JSBlankNode(node);
        }
        if (node.isLiteral()) {
            return new JSLiteral(node);
        }
        throw new IllegalArgumentException("Unsupported node type " + node);
    }

    public static JSTriple asJSTriple(Triple triple) {
        return new JSTriple(triple);
    }
}

