/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.js.JSGraph;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.NashornUtil;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.validation.SHACLException;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.util.ExceptionUtil;
import org.topbraid.spin.util.JenaUtil;

class JSRule
extends Rule {
    JSRule(Resource rule) {
        super(rule);
    }

    @Override
    public void execute(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        Resource rule = this.getResource();
        String functionName = JenaUtil.getStringProperty(rule, SH.jsFunctionName);
        if (functionName == null) {
            throw new IllegalArgumentException("Missing JavaScript function name at rule " + rule);
        }
        ProgressMonitor monitor = ruleEngine.getProgressMonitor();
        for (RDFNode focusNode : focusNodes) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            boolean nested = SHACLScriptEngineManager.begin();
            JSScriptEngine engine = SHACLScriptEngineManager.getCurrentEngine();
            SHJSExecutable as = (SHJSExecutable)rule.as(SHJSExecutable.class);
            JSGraph dataJSGraph = new JSGraph(ruleEngine.getDataset().getDefaultModel().getGraph(), engine);
            JSGraph shapesJSGraph = new JSGraph(ruleEngine.getDataset().getDefaultModel().getGraph(), engine);
            try {
                engine.executeLibraries(as);
                engine.put("$data", dataJSGraph);
                engine.put("$shapes", shapesJSGraph);
                QuerySolutionMap bindings = new QuerySolutionMap();
                bindings.add(SH.thisVar.getVarName(), focusNode);
                Object result = engine.invokeFunction(functionName, (QuerySolution)bindings);
                if (!NashornUtil.isArray(result)) continue;
                for (Object tripleO : NashornUtil.asArray(result)) {
                    Node object;
                    Node predicate;
                    Node subject;
                    if (NashornUtil.isArray(tripleO)) {
                        Object[] nodes = NashornUtil.asArray(tripleO);
                        subject = JSFactory.getNode(nodes[0]);
                        predicate = JSFactory.getNode(nodes[1]);
                        object = JSFactory.getNode(nodes[2]);
                        ruleEngine.infer(Triple.create((Node)subject, (Node)predicate, (Node)object), this, shape);
                        continue;
                    }
                    if (tripleO instanceof Map) {
                        Map triple = (Map)tripleO;
                        subject = JSFactory.getNode(triple.get("subject"));
                        predicate = JSFactory.getNode(triple.get("predicate"));
                        object = JSFactory.getNode(triple.get("object"));
                        ruleEngine.infer(Triple.create((Node)subject, (Node)predicate, (Node)object), this, shape);
                        continue;
                    }
                    throw new SHACLException("Array members produced by rule must be either arrays with three nodes, or JS objects with subject, predicate and object");
                }
            }
            catch (ScriptException ex) {
                ExceptionUtil.throwUnchecked(ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ExprEvalException((Throwable)ex);
            }
            finally {
                dataJSGraph.close();
                SHACLScriptEngineManager.end(nested);
            }
        }
    }

    public String toString() {
        String label = this.getLabel();
        if (label == null) {
            Statement s = this.getResource().getProperty(SH.jsFunctionName);
            label = s != null && s.getObject().isLiteral() ? s.getString() : "(Missing JavaScript function name)";
        }
        return this.getLabelStart("JavaScript") + label;
    }
}

