/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.Aggregations;
import org.topbraid.spin.model.Aggregation;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Attribute;
import org.topbraid.spin.model.Bind;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.Describe;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Exists;
import org.topbraid.spin.model.Filter;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Minus;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.NotExists;
import org.topbraid.spin.model.Optional;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.model.Service;
import org.topbraid.spin.model.SubQuery;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.model.TriplePath;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Union;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.TriplePatternImpl;
import org.topbraid.spin.model.update.Clear;
import org.topbraid.spin.model.update.Create;
import org.topbraid.spin.model.update.Delete;
import org.topbraid.spin.model.update.DeleteData;
import org.topbraid.spin.model.update.DeleteWhere;
import org.topbraid.spin.model.update.Drop;
import org.topbraid.spin.model.update.Insert;
import org.topbraid.spin.model.update.InsertData;
import org.topbraid.spin.model.update.Load;
import org.topbraid.spin.model.update.Modify;
import org.topbraid.spin.model.update.Update;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class SPINFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Aggregation asAggregation(Resource resource) {
        StmtIterator it = resource.listProperties(RDF.type);
        JenaUtil.setGraphReadOptimization(true);
        try {
            while (it.hasNext()) {
                RDFNode type = ((Statement)it.next()).getObject();
                if (!(type instanceof Resource) || Aggregations.getName((Resource)type) == null) continue;
                it.close();
                Aggregation aggregation = (Aggregation)resource.as(Aggregation.class);
                return aggregation;
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
        return null;
    }

    public static Command asCommand(Resource resource) {
        Query query = SPINFactory.asQuery(resource);
        if (query != null) {
            return query;
        }
        return SPINFactory.asUpdate(resource);
    }

    public static Element asElement(Resource resource) {
        TriplePattern triplePattern = SPINFactory.asTriplePattern((RDFNode)resource);
        if (triplePattern != null) {
            return triplePattern;
        }
        if (resource.canAs(TriplePath.class)) {
            return (Element)resource.as(TriplePath.class);
        }
        if (resource.canAs(Filter.class)) {
            return (Element)resource.as(Filter.class);
        }
        if (resource.canAs(Bind.class)) {
            return (Element)resource.as(Bind.class);
        }
        if (resource.canAs(Optional.class)) {
            return (Element)resource.as(Optional.class);
        }
        if (resource.canAs(NamedGraph.class)) {
            return (Element)resource.as(NamedGraph.class);
        }
        if (resource.canAs(Minus.class)) {
            return (Element)resource.as(Minus.class);
        }
        if (resource.canAs(Exists.class)) {
            return (Element)resource.as(Exists.class);
        }
        if (resource.canAs(NotExists.class)) {
            return (Element)resource.as(NotExists.class);
        }
        if (resource.canAs(Service.class)) {
            return (Element)resource.as(Service.class);
        }
        if (resource.canAs(SubQuery.class)) {
            return (Element)resource.as(SubQuery.class);
        }
        if (resource.canAs(Union.class)) {
            return (Element)resource.as(Union.class);
        }
        if (resource.canAs(Values.class)) {
            return (Element)resource.as(Values.class);
        }
        if (SPINFactory.isElementList(resource)) {
            return (Element)resource.as(ElementList.class);
        }
        return null;
    }

    public static RDFNode asExpression(RDFNode node) {
        if (node instanceof Resource) {
            Variable var = SPINFactory.asVariable(node);
            if (var != null) {
                return var;
            }
            Aggregation aggr = SPINFactory.asAggregation((Resource)node);
            if (aggr != null) {
                return aggr;
            }
            FunctionCall functionCall = SPINFactory.asFunctionCall((Resource)node);
            if (functionCall != null) {
                return functionCall;
            }
        }
        return node;
    }

    public static Function asFunction(Resource resource) {
        return (Function)resource.as(Function.class);
    }

    public static FunctionCall asFunctionCall(Resource resource) {
        Statement s;
        if (resource.isAnon() && (s = resource.getProperty(RDF.type)) != null && s.getObject().isURIResource() && !SP.Variable.equals((Object)s.getObject())) {
            return (FunctionCall)resource.as(FunctionCall.class);
        }
        return null;
    }

    public static Query asQuery(Resource resource) {
        if (resource.canAs(Select.class)) {
            return (Query)resource.as(Select.class);
        }
        if (resource.canAs(Construct.class)) {
            return (Query)resource.as(Construct.class);
        }
        if (resource.canAs(Ask.class)) {
            return (Query)resource.as(Ask.class);
        }
        if (resource.canAs(Describe.class)) {
            return (Query)resource.as(Describe.class);
        }
        return null;
    }

    public static Template asTemplate(Resource resource) {
        return (Template)resource.as(Template.class);
    }

    public static TemplateCall asTemplateCall(RDFNode node) {
        Statement s;
        if (node instanceof Resource && (s = ((Resource)node).getProperty(RDF.type)) != null && s.getObject().isURIResource()) {
            String uri = s.getResource().getURI();
            Template template = SPINModuleRegistry.get().getTemplate(uri, s.getModel());
            if (template != null) {
                return (TemplateCall)node.as(TemplateCall.class);
            }
        }
        return null;
    }

    public static TriplePattern asTriplePattern(RDFNode node) {
        if (node instanceof Resource && ((Resource)node).hasProperty(SP.predicate)) {
            return new TriplePatternImpl(node.asNode(), (EnhGraph)((Resource)node).getModel());
        }
        return null;
    }

    public static Update asUpdate(Resource resource) {
        if (resource.canAs(Modify.class)) {
            return (Update)resource.as(Modify.class);
        }
        if (resource.canAs(Clear.class)) {
            return (Update)resource.as(Clear.class);
        }
        if (resource.canAs(Create.class)) {
            return (Update)resource.as(Create.class);
        }
        if (resource.canAs(DeleteData.class)) {
            return (Update)resource.as(DeleteData.class);
        }
        if (resource.canAs(DeleteWhere.class)) {
            return (Update)resource.as(DeleteWhere.class);
        }
        if (resource.canAs(Drop.class)) {
            return (Update)resource.as(Drop.class);
        }
        if (resource.canAs(InsertData.class)) {
            return (Update)resource.as(InsertData.class);
        }
        if (resource.canAs(Load.class)) {
            return (Update)resource.as(Load.class);
        }
        if (resource.canAs(Delete.class)) {
            return (Update)resource.as(Delete.class);
        }
        if (resource.canAs(Insert.class)) {
            return (Update)resource.as(Insert.class);
        }
        return null;
    }

    public static Variable asVariable(RDFNode node) {
        if (node instanceof Resource && ((Resource)node).hasProperty(SP.varName)) {
            return (Variable)node.as(Variable.class);
        }
        return null;
    }

    public static Argument createArgument(Model model, Property argProperty, Resource argType, boolean optional) {
        Argument a = (Argument)model.createResource(SPL.Argument).as(Argument.class);
        if (argProperty != null) {
            a.addProperty(SPL.predicate, (RDFNode)argProperty);
        }
        if (argType != null) {
            a.addProperty(SPL.valueType, (RDFNode)argType);
        }
        if (optional) {
            a.addProperty(SPL.optional, (RDFNode)model.createTypedLiteral(true));
        }
        return a;
    }

    public static Attribute createAttribute(Model model, Property argProperty, Resource argType, Integer minCount, Integer maxCount) {
        Attribute a = (Attribute)model.createResource(SPL.Attribute).as(Attribute.class);
        if (argProperty != null) {
            a.addProperty(SPL.predicate, (RDFNode)argProperty);
        }
        if (argType != null) {
            a.addProperty(SPL.valueType, (RDFNode)argType);
        }
        if (minCount != null) {
            a.addProperty(SPL.minCount, (RDFNode)model.createTypedLiteral(minCount.intValue()));
        }
        if (maxCount != null) {
            a.addProperty(SPL.maxCount, (RDFNode)model.createTypedLiteral(maxCount.intValue()));
        }
        return a;
    }

    public static Ask createAsk(Model model, ElementList where) {
        Ask ask = (Ask)model.createResource(SP.Ask).as(Ask.class);
        ask.addProperty(SP.where, (RDFNode)where);
        return ask;
    }

    public static Bind createBind(Model model, Variable variable, RDFNode expression) {
        Bind bind = (Bind)model.createResource(SP.Bind).as(Bind.class);
        if (variable != null) {
            bind.addProperty(SP.variable, (RDFNode)variable);
        }
        if (expression != null) {
            bind.addProperty(SP.expression, expression);
        }
        return bind;
    }

    public static ElementList createElementList(Model model, Element[] elements) {
        if (elements.length > 0) {
            return (ElementList)model.createList((RDFNode[])elements).as(ElementList.class);
        }
        return (ElementList)RDF.nil.inModel(model).as(ElementList.class);
    }

    public static ElementList createElementList(Model model, Iterator<Element> elements) {
        if (elements.hasNext()) {
            return (ElementList)model.createList(elements).as(ElementList.class);
        }
        return (ElementList)RDF.nil.inModel(model).as(ElementList.class);
    }

    public static Exists createExists(Model model, ElementList elements) {
        Exists notExists = (Exists)model.createResource(SP.Exists).as(Exists.class);
        notExists.addProperty(SP.elements, (RDFNode)elements);
        return notExists;
    }

    public static Filter createFilter(Model model, RDFNode expression) {
        Filter filter = (Filter)model.createResource(SP.Filter).as(Filter.class);
        filter.addProperty(SP.expression, expression);
        return filter;
    }

    public static FunctionCall createFunctionCall(Model model, Resource function) {
        return (FunctionCall)model.createResource(function).as(FunctionCall.class);
    }

    public static Minus createMinus(Model model, ElementList elements) {
        Minus minus = (Minus)model.createResource(SP.Minus).as(Minus.class);
        minus.addProperty(SP.elements, (RDFNode)elements);
        return minus;
    }

    public static NamedGraph createNamedGraph(Model model, Resource graphNameNode, RDFList elements) {
        NamedGraph result = (NamedGraph)model.createResource(SP.NamedGraph).as(NamedGraph.class);
        result.addProperty(SP.graphNameNode, (RDFNode)graphNameNode);
        result.addProperty(SP.elements, (RDFNode)elements);
        return result;
    }

    public static NotExists createNotExists(Model model, ElementList elements) {
        NotExists notExists = (NotExists)model.createResource(SP.NotExists).as(NotExists.class);
        notExists.addProperty(SP.elements, (RDFNode)elements);
        return notExists;
    }

    public static Optional createOptional(Model model, ElementList elements) {
        Optional optional = (Optional)model.createResource(SP.Optional).as(Optional.class);
        optional.addProperty(SP.elements, (RDFNode)elements);
        return optional;
    }

    public static Service createService(Model model, Resource serviceURI, ElementList elements) {
        Service service = (Service)model.createResource(SP.Service).as(Service.class);
        service.addProperty(SP.serviceURI, (RDFNode)serviceURI);
        service.addProperty(SP.elements, (RDFNode)elements);
        return service;
    }

    public static SubQuery createSubQuery(Model model, Query subQuery) {
        SubQuery result = (SubQuery)model.createResource(SP.SubQuery).as(SubQuery.class);
        result.addProperty(SP.query, (RDFNode)subQuery);
        return result;
    }

    public static TemplateCall createTemplateCall(Model model, Resource template) {
        TemplateCall templateCall = (TemplateCall)model.createResource(template).as(TemplateCall.class);
        return templateCall;
    }

    public static TriplePath createTriplePath(Model model, Resource subject, Resource path, RDFNode object) {
        TriplePath triplePath = (TriplePath)model.createResource(SP.TriplePath).as(TriplePath.class);
        triplePath.addProperty(SP.subject, (RDFNode)subject);
        triplePath.addProperty(SP.path, (RDFNode)path);
        triplePath.addProperty(SP.object, object);
        return triplePath;
    }

    public static TriplePattern createTriplePattern(Model model, RDFNode subject, Resource predicate, RDFNode object) {
        TriplePattern triplePattern = (TriplePattern)model.createResource().as(TriplePattern.class);
        triplePattern.addProperty(SP.subject, subject);
        triplePattern.addProperty(SP.predicate, (RDFNode)predicate);
        triplePattern.addProperty(SP.object, object);
        return triplePattern;
    }

    public static Union createUnion(Model model, ElementList elements) {
        Union union = (Union)model.createResource(SP.Union).as(Union.class);
        union.addProperty(SP.elements, (RDFNode)elements);
        return union;
    }

    public static Values createValues(Model model, Table data, boolean untyped) {
        Resource blank = untyped ? model.createResource() : model.createResource(SP.Values);
        Values values = (Values)blank.as(Values.class);
        ArrayList<Literal> vars = new ArrayList<Literal>(data.getVarNames().size());
        for (String varName : data.getVarNames()) {
            vars.add(model.createTypedLiteral(varName));
        }
        RDFList varList = model.createList(vars.iterator());
        values.addProperty(SP.varNames, (RDFNode)varList);
        Iterator bindings = data.rows();
        if (bindings.hasNext()) {
            LinkedList<RDFList> lists = new LinkedList<RDFList>();
            while (bindings.hasNext()) {
                ArrayList<Object> nodes = new ArrayList<Object>(data.getVarNames().size());
                Binding binding = (Binding)bindings.next();
                for (String varName : data.getVarNames()) {
                    Node value = binding.get(Var.alloc((String)varName));
                    if (value == null) {
                        nodes.add(SP.undef);
                        continue;
                    }
                    nodes.add(model.asRDFNode(value));
                }
                lists.add(model.createList(nodes.iterator()));
            }
            values.addProperty(SP.bindings, (RDFNode)model.createList(lists.iterator()));
        }
        return values;
    }

    public static Variable createVariable(Model model, String varName) {
        Variable variable = (Variable)model.createResource().as(Variable.class);
        variable.addProperty(SP.varName, (RDFNode)model.createTypedLiteral(varName));
        return variable;
    }

    public static Attribute getAttribute(Resource cls, Property property) {
        StmtIterator it = JenaUtil.listAllProperties(cls, SPIN.constraint);
        while (it.hasNext()) {
            Attribute a;
            RDFNode object = it.nextStatement().getObject();
            if (!(object instanceof Resource) || !((Resource)object).hasProperty(RDF.type, (RDFNode)SPL.Attribute) || !property.equals((a = (Attribute)object.as(Attribute.class)).getPredicate())) continue;
            it.close();
            return a;
        }
        return null;
    }

    public static Resource getTemplateMetaClass(Command command) {
        if (command instanceof Ask) {
            return SPIN.AskTemplate;
        }
        if (command instanceof Construct) {
            return SPIN.ConstructTemplate;
        }
        if (command instanceof Select) {
            return SPIN.SelectTemplate;
        }
        if (command instanceof Update) {
            return SPIN.UpdateTemplate;
        }
        throw new IllegalArgumentException("Unsupported Command type: " + command.getClass());
    }

    public static boolean isAbstract(Resource module) {
        return module.hasProperty(SPIN.abstract_, (RDFNode)module.getModel().createTypedLiteral(true));
    }

    public static boolean isElementList(Resource resource) {
        if (RDF.nil.equals((Object)resource)) {
            return true;
        }
        Statement firstS = resource.getProperty(RDF.first);
        if (firstS != null && firstS.getObject().isResource()) {
            Resource first = firstS.getResource();
            return SPINFactory.asElement(first) != null;
        }
        return false;
    }

    public static boolean isModuleInstance(Resource resource) {
        Resource moduleClass = SPIN.Module.inModel(resource.getModel());
        for (Resource type : JenaUtil.getTypes(resource)) {
            if (!JenaUtil.hasIndirectType(type, moduleClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQueryProperty(Property predicate) {
        return SPIN.query.equals(predicate) || JenaUtil.hasSuperProperty(predicate, SPIN.query);
    }

    public static boolean isTemplateCall(RDFNode node) {
        TemplateCall templateCall = SPINFactory.asTemplateCall(node);
        return templateCall != null && templateCall.getTemplate() != null;
    }

    public static boolean isVariable(RDFNode node) {
        return SPINFactory.asVariable(node) != null;
    }
}

