/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.functions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.RuntimeConfigProperties$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.DefaultEvaluationContext;
import org.mule.weave.v2.model.DefaultEvaluationContext$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.reader.ResourceManager;
import org.mule.weave.v2.module.writer.ConfigurableEncoding;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.util.StringValueUtils$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

public final class WriteFunctionValue$ {
    public static WriteFunctionValue$ MODULE$;
    private final String DATA_WEAVE_MIMETYPE;
    private final Integer maxValueLength;

    static {
        new WriteFunctionValue$();
    }

    public String DATA_WEAVE_MIMETYPE() {
        return this.DATA_WEAVE_MIMETYPE;
    }

    public Integer maxValueLength() {
        return this.maxValueLength;
    }

    private Either<String, byte[]> processResult(InputStream stream, String charset) {
        Left left;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(stream, charset);){
            try {
                left = package$.MODULE$.Left().apply((Object)source.mkString());
            }
            catch (MalformedInputException x) {
                byte[] byArray;
                Right$ right$ = package$.MODULE$.Right();
                InputStream inputStream = stream;
                if (inputStream instanceof SeekableStream) {
                    SeekableStream seekableStream = (SeekableStream)((Object)inputStream);
                    byArray = BinaryValue$.MODULE$.getBytesFromSeekableStream(seekableStream, BinaryValue$.MODULE$.getBytesFromSeekableStream$default$2());
                } else {
                    byArray = BinaryValue$.MODULE$.getBytesFromInputStream(stream);
                }
                left = right$.apply((Object)byArray);
            }
        }
        return left;
    }

    public Either<String, byte[]> write(Value<?> value, Writer writer, LocationCapable location, EvaluationContext ctx) {
        Left left;
        Charset charset;
        ServiceManager serviceManager = ctx.serviceManager();
        boolean x$6 = ctx.closeAfterExecution();
        LoggingService x$3 = serviceManager.loggingService();
        Map<Class<?>, ?> x$4 = serviceManager.customService();
        ResourceManager x$5 = ServiceManager$.MODULE$.$lessinit$greater$default$2();
        ServiceManager x$7 = new ServiceManager(x$3, x$5, x$4);
        boolean x$8 = DefaultEvaluationContext$.MODULE$.apply$default$1();
        try (DefaultEvaluationContext childExecutionContext = new DefaultEvaluationContext(x$8, x$7, x$6);){
            writer.startDocument(location);
            writer.writeValue(value, childExecutionContext);
            writer.endDocument(location);
        }
        Writer writer2 = writer;
        if (writer2 instanceof ConfigurableEncoding) {
            Writer writer3 = writer2;
            charset = ((ConfigurableEncoding)((Object)writer3)).charset();
        } else {
            charset = Charset.defaultCharset();
        }
        Charset charset2 = charset;
        Object object = writer.result();
        if (object instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object;
            left = package$.MODULE$.Right().apply((Object)byteArrayOutputStream.toByteArray());
        } else if (object instanceof AutoPersistedOutputStream) {
            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object;
            left = this.processResult((InputStream)((Object)autoPersistedOutputStream.getInputStream()), charset2.name());
        } else if (object instanceof SeekableStream) {
            SeekableStream seekableStream = (SeekableStream)object;
            left = this.processResult((InputStream)((Object)seekableStream), charset2.name());
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            left = this.processResult(inputStream, charset2.name());
        } else if (object instanceof Object) {
            Object object2 = object;
            left = package$.MODULE$.Left().apply((Object)String.valueOf(object2));
        } else {
            throw new MatchError(object);
        }
        Left result = left;
        return result;
    }

    public LocationCapable write$default$3() {
        return UnknownLocationCapable$.MODULE$;
    }

    public String toDwString(Value<?> value, int maxLength, EvaluationContext ctx) {
        return StringValueUtils$.MODULE$.abbreviate(this.toDwString(value, ctx), maxLength);
    }

    public String toDwString(Value<?> value, EvaluationContext ctx) {
        String string;
        Option<DataFormat> maybeFormat = DataFormatManager$.MODULE$.byName("weave");
        Option<DataFormat> option = maybeFormat;
        if (None$.MODULE$.equals(option)) {
            string = String.valueOf(value.evaluate(ctx));
        } else if (option instanceof Some) {
            String string2;
            Either<String, byte[]> result;
            Some some = (Some)option;
            DataFormat dataFormat = (DataFormat)some.value();
            Writer writer = dataFormat.writer((Option<Object>)None$.MODULE$, dataFormat.writer$default$2());
            writer.setOption((Location)UnknownLocation$.MODULE$, "indent", "");
            Either<String, byte[]> either = result = this.write(value, writer, this.write$default$3(), ctx);
            if (either instanceof Left) {
                String str;
                Left left = (Left)either;
                string2 = str = (String)left.value();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                byte[] bytes = (byte[])right.value();
                string2 = new String(bytes, StandardCharsets.UTF_8);
            } else {
                throw new MatchError(either);
            }
            string = string2;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private WriteFunctionValue$() {
        MODULE$ = this;
        this.DATA_WEAVE_MIMETYPE = "application/dw";
        this.maxValueLength = RuntimeConfigProperties$.MODULE$.MAX_STRING_VALUE_MESSAGE_LENGTH();
    }
}

