/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.io;

import java.io.File;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;
    private final File tmpdir;
    private final SecureRandom random;
    private final ExecutorService scheduler;

    static {
        new FileHelper$();
    }

    public File tmpdir() {
        return this.tmpdir;
    }

    public SecureRandom random() {
        return this.random;
    }

    public ExecutorService scheduler() {
        return this.scheduler;
    }

    public File createTempFile(String prefix, String suffix) {
        long n = this.random().nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        if (!this.tmpdir().exists()) {
            throw new RuntimeException("The specified temporary " + this.tmpdir().getAbsolutePath() + " directory does not exits. Please create the directory or provide a different one.");
        }
        return new File(this.tmpdir(), prefix + n + suffix);
    }

    public void deleteAsync(File tmp) {
        this.scheduler().submit(new Runnable(tmp){
            private final File tmp$1;

            public void run() {
                this.tmp$1.delete();
            }
            {
                this.tmp$1 = tmp$1;
            }
        });
    }

    public void deleteDirectory(File folder) {
        Path path = Path$.MODULE$.apply(folder);
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> path.deleteRecursively());
    }

    public String baseName(File x) {
        return x.getName().substring(0, x.getName().lastIndexOf("."));
    }

    public String getExtension(File output) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(output.getName())).drop(output.getName().lastIndexOf(46));
    }

    public File createBufferFile(String name) {
        return this.createTempFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dw-buffer-", "-"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), ".tmp");
    }

    private FileHelper$() {
        MODULE$ = this;
        this.tmpdir = new File(System.getProperty("java.io.tmpdir"));
        this.random = new SecureRandom();
        this.scheduler = Executors.newFixedThreadPool(10);
    }
}

