/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.constraints.ConstraintViolation;
import org.topbraid.spin.constraints.ObjectPropertyPath;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.constraints.SubjectPropertyPath;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SHACL2SPINBridge {
    public static ConstraintViolation createConstraintViolation(Resource shResult) {
        Resource path;
        String message = JenaUtil.getStringProperty(shResult, SH.resultMessage);
        Resource root = JenaUtil.getResourceProperty(shResult, SH.focusNode);
        LinkedList<SimplePropertyPath> paths = new LinkedList<SimplePropertyPath>();
        if (root != null && (path = JenaUtil.getResourceProperty(shResult, SH.resultPath)) != null) {
            if (path.isURIResource()) {
                paths.add(new ObjectPropertyPath(root, JenaUtil.asProperty(path)));
            } else {
                Resource inverse = JenaUtil.getResourceProperty(path, SH.inversePath);
                if (inverse != null && inverse.isURIResource()) {
                    paths.add(new SubjectPropertyPath(root, JenaUtil.asProperty(inverse)));
                }
            }
        }
        ConstraintViolation cv = new ConstraintViolation(root, paths, null, message, null);
        if (shResult.hasProperty(SH.resultSeverity, (RDFNode)SH.Violation)) {
            cv.setLevel(SPIN.Error);
        } else if (shResult.hasProperty(SH.resultSeverity, (RDFNode)SH.Warning)) {
            cv.setLevel(SPIN.Warning);
        } else if (shResult.hasProperty(SH.resultSeverity, (RDFNode)SH.Info)) {
            cv.setLevel(SPIN.Info);
        }
        return cv;
    }

    public static List<ConstraintViolation> createConstraintViolations(Model resultsModel) {
        LinkedList<ConstraintViolation> results = new LinkedList<ConstraintViolation>();
        for (Resource shResult : JenaUtil.getAllInstances(SH.ValidationResult.inModel(resultsModel))) {
            results.add(SHACL2SPINBridge.createConstraintViolation(shResult));
        }
        return results;
    }

    public static Resource createValidationResult(ConstraintViolation cv, Model results) {
        String message;
        Collection<SimplePropertyPath> paths;
        Resource result = results.createResource(SPIN.Fatal.equals((Object)cv.getLevel()) ? DASH.FailureResult : SH.ValidationResult);
        if (SPIN.Info.equals((Object)cv.getLevel())) {
            result.addProperty(SH.resultSeverity, (RDFNode)SH.Info);
        } else if (SPIN.Warning.equals((Object)cv.getLevel())) {
            result.addProperty(SH.resultSeverity, (RDFNode)SH.Warning);
        }
        Resource root = cv.getRoot();
        if (root != null) {
            result.addProperty(SH.focusNode, (RDFNode)root);
        }
        if ((paths = cv.getPaths()).size() == 1) {
            SimplePropertyPath path = paths.iterator().next();
            result.addProperty(SH.focusNode, (RDFNode)root);
            if (path instanceof ObjectPropertyPath) {
                result.addProperty(SH.resultPath, (RDFNode)path.getPredicate());
            } else {
                Resource inverse = result.getModel().createResource();
                inverse.addProperty(SH.inversePath, (RDFNode)path.getPredicate());
                result.addProperty(SH.resultPath, (RDFNode)inverse);
            }
            if (cv.getValue() != null) {
                result.addProperty(SH.value, cv.getValue());
            }
        }
        if ((message = cv.getMessage()) != null) {
            result.addProperty(SH.resultMessage, message);
        }
        return result;
    }
}

